#include "main.h"

/************************************************************
 *                     get_dqs_config
 ************************************************************/
/* gets and writes all user-configurable parameters for ../SRC/dqs.h */

void get_dqs_config()
{
       char swap[MAXLEN];
       int  static_config=0;
       char NERR_FILE[MAXSTR];
       char NLOG_FILE[MAXSTR];
       int  result=0,i,bad;
       char *tmpstr,
       *ans,
       *possible_adm,
       *possible_manager;
       struct passwd *pw;       
       
       printf("##############################################################\n\n");
       printf("WE ARE NOW SETTING UP ../SRC/dqs.h\n\n");
       printf("typing a question mark (?) at any prompt will provide brief help info\n\n\n");
       strcpy(swap,conf_dir);
       PUT_NULL(swap);
       
       
       /* set up a few goodies*/
       strcpy(NCONF_FILE,(strcat(conf_dir,"/conf_file")));
       PUT_NULL(NCONF_FILE);
       
       strcpy(conf_dir,swap);
       PUT_NULL(conf_dir);
       
       strcpy(NRESOLVE_FILE,(strcat(conf_dir,"/resolve_file")));
       PUT_NULL(NRESOLVE_FILE);
       
       strcpy(conf_dir,swap);
       PUT_NULL(conf_dir);
       
       strcpy(NKEY_FILE,(strcat(conf_dir,"/key_file")));
       PUT_NULL(NKEY_FILE);
       
       strcpy(conf_dir,swap);
       PUT_NULL(conf_dir);
       
       DPRINTF((" NCONF_FILE ==:%s:\n",NCONF_FILE));
       DPRINTF((" NRESOLVE_FILE ==:%s:\n",NRESOLVE_FILE));
       DPRINTF((" NKEY_FILE ==:%s:\n",NKEY_FILE));

       if(SIMPLE_INSTALL){
          set_def(&static_configuration, t_static_configuration);

       }
       else{
           get_line(& static_configuration, t_static_configuration);
       }
       
       if (strcmp(static_configuration,"TRUE")==0) static_config=1;
       DPRINTF(("static_config == :%d:\n",static_config));
       
       MALLOC_STR(key_file);
       strcpy(key_file,conf_dir);
       strcat(key_file,"/key_file");
       PUT_NULL(key_file);
       
       MALLOC_STR(conf_file);
       strcpy(conf_file,conf_dir);
       strcat(conf_file,"/conf_file");
       PUT_NULL(conf_file); 
       
       MALLOC_STR(err_file);
       strcpy(err_file,qmaster_spool_dir);
       strcat(err_file,"/err_file");
       PUT_NULL(err_file); 
       
       
       MALLOC_STR(resolve_file);
       strcpy(resolve_file,conf_dir);
       strcat(resolve_file,"/resolve_file");
       PUT_NULL(resolve_file); 
       
       MALLOC_STR(log_file);
       strcpy(log_file,qmaster_spool_dir);
       strcat(log_file,"/log_file");
       PUT_NULL(log_file);
       
       if(SIMPLE_INSTALL)  has_automount=0;
       else{
           
       
           if(get_line(&ans, t_has_automounter) ){
	             has_automount =1;
		     get_line(&automount, t_automounter_prefix);
	        }
          else{
	         DPRINTF(("No automounter specified\n"));
      	      has_automount = 0;
           }
          free(ans);
       }

       if(SIMPLE_INSTALL){
           set_def(&afs, t_use_AFS);
       }
       else{
            get_line(&afs, t_use_AFS);
       }
       
       /* now if they don't have afs just use defaults as dummies */
       if (!strcmp(afs,"FALSE")){  /* don't have afs*/
	      DPRINTF(("Specified no afs\n"));
	      
              set_def(&klog, t_klog);
              set_def(&reauth_time, t_reauth_time);
       }
       else{ 
	      
	      DPRINTF(("User specified use_afs\n"));
	      copy_key_file();
	      printf("#######NOTE######## \n");
	      printf("You will have to set the permissions on ALL of the\n");
	      printf("DQS MADE DIRECTORIES (conf_dir,spool_dir) Must be set by hand \n");
	      printf("FAILURE to do so could result in MASSIVE SECURITY HOLES !!!!!\n");

	      get_line(&klog, t_klog);
	      get_line(&reauth_time,t_reauth_time);
       }

       if(SIMPLE_INSTALL){ 
	 if (getuid()) {
	   set_def(&reserved_port, t_no_use_reserved_port);
	   set_def(&qmaster_service, t_qmaster_service_ur);
	   set_def(&dqs_execd_service, t_dqs_execd_service_ur);
	   set_def(&intercell_service, t_intercell_service_ur);
	 }
	 else {
	   set_def(&reserved_port, t_use_reserved_port);
	   set_def(&qmaster_service, t_qmaster_service);
	   set_def(&dqs_execd_service, t_dqs_execd_service);
	   set_def(&intercell_service, t_intercell_service);
	 }
       }
       else{       
	    bad=1;

            MALLOC_STR(tmpstr);	   
            get_line(&reserved_port, t_use_reserved_port);

	    while(bad==1){               
               get_line(&qmaster_service, t_qmaster_service);

             /*###            QMASTER SERVICE      ####*/
             /* check to see if it is in /etc/services already, if it is repeat

       	     request for service*/
             printf("Checking /etc/services to see if service already in use....\n");

             sprintf(tmpstr, "grep %s /etc/services",qmaster_service);
             PUT_NULL(tmpstr);
             printf("exec'ing : %s :\n",tmpstr);
             printf("====================================================\n");
             result  = exec_it(tmpstr);
             printf("====================================================\n");
             if (result ==0) /* need to get another guess*/

    	      printf("QMASTER_SERVICE :%s:  ALREADY IN /etc/services\n",qmaster_service);

    	      

     	      if(get_line(&ans,t_keep_qmaster_entry)  ){
    		     printf("keeping above entry\n");
            	      jbzero(ans,MAXSTR);
	              free(ans);
		     already_has_port_nums=1;
		     
		     break; 
	      }
	      
	      for(i=0;i<strlen(qmaster_service);i++) /*just in case*/
	      qmaster_service[i]='\0';
	      
	      free(qmaster_service);
	      
	      for(i=0;i<strlen(tmpstr);i++) 
	      tmpstr[i]='\0';
       }
       
             /*#####DQS_EXECD SERVICE    ############*/
	    bad=1;
	    while(bad==1){
               get_line(&dqs_execd_service, t_dqs_execd_service);


             /* check to see if it is in /etc/services already, if it is repeat

       	     request for service*/
             printf("Checking /etc/services to see if service already in use....\n");
             sprintf(tmpstr, "grep %s /etc/services",dqs_execd_service);
             PUT_NULL(tmpstr);
             printf("exec'ing : %s :\n",tmpstr);
             printf("====================================================\n");
             result  = exec_it(tmpstr);
             printf("====================================================\n");
             if (result ==0) /* need to get another guess*/

    	      printf("DQSEXECD_SERVICE :%s:  ALREADY IN /etc/services\n",dqs_execd_service);

    	      

     	      if(get_line(&ans,t_keep_dqs_execd_entry)  ){
    		     printf("keeping above entry\n");
            	      jbzero(ans,MAXSTR);
	              free(ans);
		     already_has_port_nums=1;
		     
		     break; 
	      }
	      
	      for(i=0;i<strlen(dqs_execd_service);i++) /*just in case*/
	      dqs_execd_service[i]='\0';
	      
	      free(dqs_execd_service);
	      
	      for(i=0;i<strlen(tmpstr);i++) 
	      tmpstr[i]='\0';
	      
	      sprintf(tmpstr, "grep %s /etc/services",dqs_execd_service);
	      PUT_NULL(tmpstr);
	      printf("exec'ing : %s :\n",tmpstr);
	      printf("====================================================\n");
	      result  = exec_it(tmpstr);
	      printf("====================================================\n");
	      if (result !=0) bad =0; /* quit*/
       }
       
             /*######   INTERCELL SERVICE  ######*/
	    bad=1;
	    while(bad==1){
               get_line(&intercell_service, t_intercell_service);

             /* check to see if it is in /etc/services already, if it is repeat
       	     request for service*/

             printf("Checking /etc/services to see if service already in use....\n");
             sprintf(tmpstr, "grep %s /etc/services",intercell_service);
             PUT_NULL(tmpstr);
             printf("exec'ing : %s :\n",tmpstr);
             printf("====================================================\n");
             result  = exec_it(tmpstr);
             printf("====================================================\n");
             if (result ==0) /* need to get another guess*/

    	      printf("INTERCELL_SERVICE :%s:  ALREADY IN /etc/services\n",qmaster_service);

    	      

     	      if(get_line(&ans,t_keep_intercell_entry)  ){
    		     printf("keeping above entry\n");
            	      jbzero(ans,MAXSTR);
	              free(ans);
		     already_has_port_nums=1;
		     
		     break; 
	      }
	      
	      for(i=0;i<strlen(intercell_service);i++) /*just in case*/
	      intercell_service[i]='\0';
	      
	      free(intercell_service);
	      
	      for(i=0;i<strlen(tmpstr);i++) 
	      tmpstr[i]='\0';
       }
       
       if(tmpstr) free(tmpstr);       
   }  /* SIMPLE INSTALL */

       if(SIMPLE_INSTALL){
           set_def(&mailer, t_mailer);
           set_def(&mail_has_subj_line, t_mail_has_subj_line);
       }
       else{       
          get_line(&mailer, t_mailer);   
          get_line(&mail_has_subj_line,t_mail_has_subj_line);
       }
       /** NOW get administrator **/

       
       if(SIMPLE_INSTALL){
            set_def(&administrator,t_administrator);
       }
       else{
            get_line(&administrator, t_administrator);
       }
       
       DTRACE;
       
       if(SIMPLE_INSTALL){
	 if (!getuid()) {
           set_def(&default_manager, t_default_manager);
	 } else {
	   if(!(strcmp(reserved_port,"FALSE"))){
	     set_def(&default_manager, t_default_manager);
             get_line(&default_manager2, t_administrator2);
             has_manager2=1;
	   }
	 }
       }
       else{
            get_line(&default_manager, t_default_manager );

            /* if we're running as joe user, make an  administrative position 
        	*  for them */
            if(!(strcmp(reserved_port,"FALSE"))){
	      DTRACE;
	      
	      get_line(&default_manager2, t_administrator2);
	      has_manager2=1;
            }
       }       /* SIMPLE INSTALL */

       MALLOC_STR(dqs_bin);
       strcpy(dqs_bin,bin_dir);
       
       if(SIMPLE_INSTALL){
       	   set_def(&log_mail, t_logmail);
       }
       else{       
          get_line(&log_mail, t_logmail);    
       }

       if(SIMPLE_INSTALL){
              set_def(&default_rerun, t_default_rerun);
       }
       else{    
          get_line(&default_rerun, t_default_rerun);
   	   }

       if(SIMPLE_INSTALL){
          set_def(&default_account, t_default_account);
       }
       else    {
          get_line(&default_account, t_default_account);
   	   }

       if(SIMPLE_INSTALL){
           set_def(&default_sort_seq_no, t_default_sort_seq_no);
       }
       else{
           get_line(&default_sort_seq_no,t_default_sort_seq_no);
       }

       if(SIMPLE_INSTALL){
            set_def(&sync_io, t_sync_io);
       }
       else{
          get_line(&sync_io, t_sync_io);
       }

       if(SIMPLE_INSTALL){
            set_def(&user_access, t_user_access);
       }
       else{
          get_line(&user_access, t_user_access);
       }

	   if(SIMPLE_INSTALL){
           set_def(&logfacility, t_logfacility );
       }
	   else{
             get_line(&logfacility, t_logfacility);
       }

       if(SIMPLE_INSTALL){
       	    set_def(&loglevel, t_loglevel);
       }
       else{
          get_line(&loglevel, t_loglevel);
       }
       
       if(SIMPLE_INSTALL){
            set_def(&min_uid, t_min_uid);
       }
       else{
           get_line(&min_uid, t_min_uid);
       }
       
       if(SIMPLE_INSTALL){
           set_def(&min_gid, t_min_gid);
       }
       else{
          get_line(&min_gid, t_min_gid);
           }
       
       if(SIMPLE_INSTALL){
            set_def(&load_log_time, t_load_log_time);
       }
       else{
          get_line(&load_log_time, t_load_log_time);
       }

       if(SIMPLE_INSTALL){
       	   set_def(&max_unheard, t_max_unheard);
       }
       else{
           get_line(&max_unheard, t_max_unheard); 
	   }

	   if(SIMPLE_INSTALL){
           set_def(&schedule_time, t_schedule_time);
       }
	   else{
           get_line(&schedule_time, t_schedule_time);
       }
       
       if(SIMPLE_INSTALL){
          set_def(&stat_log_time, t_stat_log_time);
       }
       else{
          get_line(&stat_log_time, t_stat_log_time);
       }
       
       if(SIMPLE_INSTALL){
            set_def(&maxujobs, t_maxujobs);
       }
       else{
          get_line(&maxujobs, t_maxujobs);
       }

       if(SIMPLE_INSTALL){
            set_def(&output_handling, t_output_handling);
       }
       else{
       	  get_line(&output_handling,t_output_handling);
       }
       	  
       if(SIMPLE_INSTALL){
       	  set_def(&addon_script, t_addon_script);
       }
       else{
          get_line(&addon_script, t_addon_script);
       }

       if(SIMPLE_INSTALL){
       	  set_def(&addon_info, t_addon_info);
       }
       else{
          get_line(&addon_info, t_addon_info);
       }
       
       if(SIMPLE_INSTALL){
       	  set_def(&copy_file_delay, t_copy_file_delay);
       }
       else{
          get_line(&copy_file_delay, t_copy_file_delay);
       }
       if(SIMPLE_INSTALL){
       	  set_def(&link_file_path, t_link_file_path);
       }
       else{
          get_line(&link_file_path, t_link_file_path);
       }
       if(SIMPLE_INSTALL){
       	  set_def(&slave_loop_time, t_slave_loop_time);
       }
       else{
          get_line(&slave_loop_time, t_slave_loop_time);
       }
       if(SIMPLE_INSTALL){
       	  set_def(&pvm_root, t_pvm_root);
       }
       else{
          get_line(&pvm_root, t_pvm_root);
       }

       if(SIMPLE_INSTALL){
         set_def(&alarms, t_alarms);
         set_def(&alarmm, t_alarmm);
         set_def(&alarml, t_alarml);
	   }
       else{       
          printf("\n **************NOTE******************\n");
          printf("UNLESS YOU REALLY KNOW WHAT YOUR DOING DON'T \n");
          printf(" TOUCH THESE ALARM TIMES\n");
       
          get_line(&alarms, t_alarms);
       
          get_line(&alarmm, t_alarmm);
          
          get_line(&alarml, t_alarml);
       }

       
}	

/***********************************************************************
  DUMP_DQS_CONFIG
  ************************************************************************/
/* writes current options to disk in file called ../SRC/dqs.h.new */

void dump_dqs_config(){
       
       FILE* outfd;
       DTRACE;

       if(!(outfd = fopen("../SRC/dqs.h","w"))) err_crit("can't open ../SRC/dqs.h for writing\n");    
       
       fprintf(outfd,"#define STATIC_CONFIGURATION      %s\n",static_configuration);
       fprintf(outfd,"#define CONF_FILE                 \"%s\"\n",conf_file);
       fprintf(outfd,"#define RESOLVE_FILE              \"%s\"\n",resolve_file);
       fprintf(outfd,"#define KEY_FILE                  \"%s\"\n",key_file);
       fprintf(outfd,"#define AFS                       %s\n",afs);
       fprintf(outfd,"#define ERR_FILE                  \"%s\"\n",err_file);
       fprintf(outfd,"#define LOG_FILE                  \"%s\"\n",log_file);
       
       fprintf(outfd,"#define QMASTER_SPOOL_DIR         \"%s\"\n",qmaster_spool_dir);
       fprintf(outfd,"#define EXECD_SPOOL_DIR           \"%s\"\n",execd_spool_dir);

       fprintf(outfd,"#define DEFAULT_CELL              \"%s\"\n",default_cell);
       fprintf(outfd,"#define RESERVED_PORT             %s\n",reserved_port);
       fprintf(outfd,"#define DQS_EXECD_SERVICE         \"%s\"\n",dqs_execd_service);
       fprintf(outfd,"#define QMASTER_SERVICE           \"%s\"\n",qmaster_service);
       fprintf(outfd,"#define INTERCELL_SERVICE         \"%s\"\n",intercell_service);
       fprintf(outfd,"#define KLOG                      \"%s\"\n",klog);
       fprintf(outfd,"#define REAUTH_TIME               %s\n",reauth_time);
       
       fprintf(outfd,"#define MAILER                    \"%s\"\n",mailer);
       fprintf(outfd,"#define DQS_BIN                   \"%s\"\n",dqs_bin);
       fprintf(outfd,"#define ADMINISTRATOR             \"%s\"\n",administrator);
       
       fprintf(outfd,"#define DEFAULT_ACCOUNT           \"%s\"\n",default_account);
       fprintf(outfd,"#define DEFAULT_HOST              \"%s\"\n",default_host);
       
       
       fprintf(outfd,"#define LOGMAIL                   %s\n",log_mail); 
       fprintf(outfd,"#define DEFAULT_RERUN             %s\n",default_rerun);
       fprintf(outfd,"#define DEFAULT_SORT_SEQ_NO       %s\n",default_sort_seq_no);
       fprintf(outfd,"#define SYNC_IO                   %s\n",sync_io);
       
       
       fprintf(outfd,"#define USER_ACCESS               %s\n",user_access);
       fprintf(outfd,"#define LOGFACILITY               %s\n",logfacility);
       fprintf(outfd,"#define LOGLEVEL                  %s\n",loglevel);
       
       fprintf(outfd,"#define MIN_UID                   %s\n",min_uid);
       fprintf(outfd,"#define MIN_GID                   %s\n",min_gid);
       fprintf(outfd,"#define MAXUJOBS                  %s\n",maxujobs);
       fprintf(outfd,"#define OUTPUT_HANDLING           %s\n",output_handling);
       fprintf(outfd,"#define ADDON_SCRIPT              %s\n",addon_script);
       fprintf(outfd,"#define ADDON_INFO                %s\n",addon_info);
                            
       
       fprintf(outfd,"#define LOAD_LOG_TIME             %s\n",load_log_time);
       fprintf(outfd,"#define STAT_LOG_TIME             %s\n",stat_log_time);
       fprintf(outfd,"#define SCHEDULE_TIME             %s\n",schedule_time);
       
       
       fprintf(outfd,"#define MAX_UNHEARD               %s\n",max_unheard);
       fprintf(outfd,"#define ALARMS                    %s\n",alarms);
       fprintf(outfd,"#define ALARMM                    %s\n",alarmm);
       fprintf(outfd,"#define ALARML                    %s\n",alarml);
       
       fprintf(outfd,"#define MAIL_HAS_SUBJ_LINE        %s\n",mail_has_subj_line);


       fprintf(outfd,"#define DEFAULT_MANAGER           \"%s\"\n",default_manager);
       if(has_manager2){
 	      fprintf(outfd,"#define DEFAULT_MANAGER2           \"%s\"\n",default_manager2);
       }
       if(has_automount){
	      fprintf(outfd,"#define AUTO_MOUNT                 \"%s\"\n",automount);
       }
           
       fprintf(outfd,"#define PVM_ROOT                       \"%s\"\n",pvm_root);             
       fprintf(outfd,"#ifdef SUN\n#define volatile\n#define labs abs\n#endif\n");
       fprintf(outfd,"#define SLAVE_LOOP_TIME                 \"%s\"\n",slave_loop_time);
       fprintf(outfd,"#define LINK_FILE_PATH                  \"%s\"\n",link_file_path);
       fprintf(outfd,"#define COPY_FILE_DELAY                 \"%s\"\n",copy_file_delay);

fprintf(outfd,"/* To use the link strategy you must ensure, that                  */\n");
fprintf(outfd,"/* (1) a file with the value of TMP_LINK_OUTPUT_FILES exists in    */\n");
fprintf(outfd,"/*     the directory EXECD_SPOOL_DIR and contains the required     */\n");
fprintf(outfd," /*     global path to the directory EXECD_SPOOL_DIR/local.         */\n");
fprintf(outfd," /*     To be able to access this directory from any node via       */\n");
fprintf(outfd," /*     NFS/AFS it is referenced using the contents of the file     */\n");
fprintf(outfd," /*              EXECD_SPOOL_DIR/TMP_LINK_OUTPUT_FILES              */\n");
fprintf(outfd," /*     as the head of the pathname. For example:                   */\n");
fprintf(outfd," /*       We use the NFS automounter and have any EXECD_SPOOL_DIR   */\n");
fprintf(outfd," /*       imported as /import/dqs_execd_spool.<hostname> where      */\n");
fprintf(outfd," /*       hostname is the name of the involved worker node.         */\n");
fprintf(outfd," /*       So we created on the worker node 'rznb1' a file           */\n");
fprintf(outfd," /*           EXECD_SPOOL_DIR/netpath                               */\n");
fprintf(outfd," /*       with the contents                                         */\n");
fprintf(outfd," /*           /import/dqs_execd_spool.rznb1                         */\n");
fprintf(outfd," /*       and set the above #define to                              */\n");
fprintf(outfd," /*           #define TMP_LINK_OUTPUT_FILES 'netpath'               */\n");
fprintf(outfd," /* (2) all directories EXECD_SPOOL_DIR are accessible from each    */\n");
fprintf(outfd," /*     node a user can place his output files                      */\n");
fprintf(outfd," /*-----------------------------------------------------------------*/\n");


       
       fclose(outfd);
}


/************************************************************
 *                    GET_ADMINISTRATOR
 ************************************************************/
char * get_administrator()
{
       
       char * adm;
       struct passwd *pw;
       struct hostent *host_struct;
       char *hname;



       MALLOC_STR(hname);
       MALLOC_STR(adm);


       if (gethostname(hname,MAXSTR)==-1) err_cont("Gethostname fails");  
       
       if( (pw = getpwuid(getuid())) ==NULL){
              DPRINTF(("Can't getpwuid.... using defaults\n"));
	      strcpy(adm,ADMINISTRATOR);
	      PUT_NULL(adm);
              return(adm);
       }
       
       sprintf(adm,"%s@%s",pw->pw_name,hname);
       PUT_NULL(adm);
       DPRINTF(("   get_administrator returning :%s:\n",adm));
       return(adm);
}





