// -*- C++ -*-
#ifndef __COREOPTION_H
#define __COREOPTION_H


#include "Option.h"


//
// Remarks:
//
// * CthughaBuffer must be inidializes BEFORE any initial values 
//   are set for the CoreOptions
//


class CoreOptionEntry {
protected:
    char * name;				// name (short)
    char * desc;				// description or long name
    OptionOnOff use;				// in use or not
public:
    CoreOptionEntry(const char * n, const char * d, int inUse = 1);
    virtual ~CoreOptionEntry() {
	delete name; name = NULL;
	delete desc; desc = NULL;
    }
    virtual int operator()() {	return 0;    }	// do nothing by default

    const char * Name() const {	return name; }
    const char * Desc() const { return desc; }

    virtual int sameName(const char * other);

    friend class CoreOption;
    friend class InterfaceList;
};

class OffEntry : public CoreOptionEntry {
public:
    OffEntry(const char * name = "off") : CoreOptionEntry(name, "", 1) {}
    virtual int sameName(const char * other);
};

class OnEntry : public CoreOptionEntry {
public:
    OnEntry() : CoreOptionEntry("on", "", 1) {}
    virtual int sameName(const char * other);
};
    




class CoreOption : public Option{
protected:
    //
    // buffer this option belongs to
    //
    int buffer;

    //
    // List of all core options
    //
    static CoreOption * first;	
    static int nCoreOptions;
    CoreOption * next;		

    // 
    // History and Hot Values
    //
    int * oldValues;
    int history;
    int * hot;

    //
    // Entries
    //
    CoreOptionEntry ** entries;
    int nEntries;
    int firstEntries;

    char initialEntry[256];

    void doSave();
    void doRestore();

    void getIniUsage();
    void putIniUsage();


    //
    // general loading
    //
protected:
    int isCompressed(const char * name);
    int hasExtension(const char * name, const char * extension);
    
    CoreOptionEntry * load(const char * name, 
			   char * total_name, 
			   const char * dir,
			   CoreOptionEntry* (*loader)(FILE *, 
						      const char *, 
						      const char *,
						      const char *));
    void loadDir(const char * dir, 
		 const char * extension,
		 CoreOptionEntry * (*loader)(FILE *, 
					     const char *, 
					     const char *,
					     const char *) );

public:    
    int load(const char * searchPath[], 
	     const char * extraPath, 
	     const char * extension,
	     CoreOptionEntry * (* load_function)(FILE *, 
						 const char *, 
						 const char *,
						 const char *) );


public:
    CoreOption(int buffer, const char * name, CoreOptionEntry ** entries, int nEntries);
    CoreOption & operator=(const CoreOption & other);

    void setInitialEntry(const char * i) {
	strncpy(initialEntry, i, 256);
    }


    virtual const char * name() const;

    //
    // Changeing
    //
    OptionOnOff lock;				// individual lock

    static void changeToInitial();
    void change(const char * to, int doSave=1);
    void change(int by, int doSave=1);
    void changeRandom(int save_=1);

    int optNr(const char * n);

    void change(int) {
	printfe("internal error. wrong change called for option `%s'.\n", name());
    }
    void change(const char *) {
	printfe("internal error. wrong change called for option `%s'.\n", name());
    }

    static void changeOne();
    static void changeAll();


    virtual const char * text() const;

    //
    // Entries
    //
    virtual const char * text(int i) const {		// get name of entry i
	if( (i < 0) || (i >= nEntries))
	    return "unknown";
	return entries[i]->name;
    }
    void add(CoreOptionEntry *);			// add a new entry
    int defined(const char * name);			// check if entry is already defines

    virtual int operator()() {				// do the action of the current entry
	if( (value < 0) || (value >= nEntries))
	    return 0;
	return (entries[value]->operator()());
    }

    CoreOptionEntry * operator[](int i) {		// get the i-th entry
	if( (i < 0) || (i >= nEntries)) 
	    return NULL;
	return entries[i];
    }
    CoreOptionEntry * current() {			// get the current entry
	return operator[](value);
    }
    int currentN() const {				// get current value
	return value;
    }
    const char * currentName() const {			// return current name
	if( (value < 0) || (value >= nEntries))
	    return "unknown";
	return entries[value]->name;
    }
    const char * currentDesc() const {			// return current description
	if( (value < 0) || (value >= nEntries))
	    return "";
	return entries[value]->desc;
    }
    int getNEntries() const { 
	return nEntries; 
    }

    //
    // control History and Hot Values
    //

    static void save();
    static void restore();

    static void save(int to);
    static void restore(int from);

    //
    // access ini file
    //
    static void putIniInitials();			// put current values
    static void getIniInitials();			// get initial values

    static void getHotIni();			
    static void putHotIni();

    static void getIniUsages();
    static void putIniUsages();


    friend class InterfaceList;
};


extern CoreOption screen;
extern CoreOption flashlight;


#endif


