;;; Errno constant definitions.
;;; Copyright (c) 1993 by Olin Shivers.
;;; Copyright (c) 1994 by Brian D. Carlstrom.

;;; These are the correct values for Linux systems.

(define errno/2big 7) ; 2big is not a legit Scheme symbol. Lose, lose.

(define-enum-constants errno
  ;; POSIX:
 
 (perm		 1	); Operation Not Permitted 
 (noent		 2	); No Such File Or Directory 
 (srch		 3	); No Such Process 
 (intr		 4	); Interrupted System Call 
 (io		 5	); I/O Error 
 (nxio		 6	); No Such Device Or Address 
 (2big		 7	); Arg List Too Long 
 (noexec	 8	); Exec Format Error 
 (badf		 9	); Bad File Number 
 (child		10	); No Child Processes 
 (again		11	); Try Again 
 (nomem		12	); Out Of Memory 
 (acces		13	); Permission Denied 
 (fault		14	); Bad Address 
 (notblk	15	); Block Device Required 
 (busy		16	); Device Or Resource Busy 
 (exist		17	); File Exists 
 (xdev		18	); Cross-Device Link 
 (nodev		19	); No Such Device 
 (notdir	20	); Not A Directory 
 (isdir		21	); Is A Directory 
 (inval		22	); Invalid Argument 
 (nfile		23	); File Table Overflow 
 (mfile		24	); Too Many Open Files 
 (notty		25	); Not A Typewriter 
 (txtbsy	26	); Text File Busy 
 (fbig		27	); File Too Large 
 (nospc		28	); No Space Left On Device 
 (spipe		29	); Illegal Seek 
 (rofs		30	); Read-Only File System 
 (mlink		31	); Too Many Links 
 (pipe		32	); Broken Pipe 
 (dom		33	); Math Argument Out Of Domain Of Func 
 (range		34	); Math Result Not Representable 
 (deadlk	35	); Resource Deadlock Would Occur 
 (nametoolong	36	); File Name Too Long 
 (nolck		37	); No Record Locks Available 
 (nosys		38	); Function Not Implemented 
 (notempty	39	); Directory Not Empty 
 (loop		40	); Too Many Symbolic Links Encountered 
 (wouldblock	11	); Operation Would Block 
 (nomsg		42	); No Message Of Desired Type 
 (idrm		43	); Identifier Removed 
 (chrng		44	); Channel Number Out Of Range 
 (l2nsync	45	); Level 2 Not Synchronized 
 (l3hlt		46	); Level 3 Halted 
 (l3rst		47	); Level 3 Reset 
 (lnrng		48	); Link Number Out Of Range 
 (unatch	49	); Protocol Driver Not Attached 
 (nocsi		50	); No Csi Structure Available 
 (l2hlt		51	); Level 2 Halted 
 (bade		52	); Invalid Exchange 
 (badr		53	); Invalid Request Descriptor 
 (xfull		54	); Exchange Full 
 (noano		55	); No Anode 
 (badrqc	56	); Invalid Request Code 
 (badslt	57	); Invalid Slot 
 (deadlock	58	); File Locking Deadlock Error 
 (bfont		59	); Bad Font File Format 
 (nostr		60	); Device Not A Stream 
 (nodata	61	); No Data Available 
 (time		62	); Timer Expired 
 (nosr		63	); Out Of Streams Resources 
 (nonet		64	); Machine Is Not On The Network 
 (nopkg		65	); Package Not Installed 
 (remote	66	); Object Is Remote 
 (nolink	67	); Link Has Been Severed 
 (adv		68	); Advertise Error 
 (srmnt		69	); Srmount Error 
 (comm		70	); Communication Error On Send 
 (proto		71	); Protocol Error 
 (multihop	72	); Multihop Attempted 
 (dotdot	73	); Rfs Specific Error 
 (badmsg	74	); Not A Data Message 
 (overflow	75	); Value Too Large For Defined Data Type 
 (notuniq	76	); Name Not Unique On Network 
 (badfd		77	); File Descriptor In Bad State 
 (remchg	78	); Remote Address Changed 
 (libacc	79	); Can Not Access A Needed Shared Library 
 (libbad	80	); Accessing A Corrupted Shared Library 
 (libscn	81	); .Lib Section In A.Out Corrupted 
 (libmax	82	); Attempting To Link In Too Many Shared Libraries 
 (libexec	83	); Cannot Exec A Shared Library Directly 
 (ilseq		84	); Illegal Byte Sequence 
 (restart	85	); Interrupted System Call Should Be Restarted 
 (strpipe	86	); Streams Pipe Error 
 (users		87	); Too Many Users 
 (notsock	88	); Socket Operation On Non-Socket 
 (destaddrreq	89	); Destination Address Required 
 (msgsize	90	); Message Too Long 
 (prototype	91	); Protocol Wrong Type For Socket 
 (noprotoopt	92	); Protocol Not Available 
 (protonosupport 93	); Protocol Not Supported 
 (socktnosupport 94	); Socket Type Not Supported 
 (opnotsupp	 95	); Operation Not Supported On Transport Endpoint 
 (pfnosupport	 96	); Protocol Family Not Supported 
 (afnosupport	 97	); Address Family Not Supported By Protocol 
 (addrinuse	 98	); Address Already In Use 
 (addrnotavail	 99	); Cannot Assign Requested Address 
 (netdown	100	); Network Is Down 
 (netunreach	101	); Network Is Unreachable 
 (netreset	102	); Network Dropped Connection Because Of Reset 
 (connaborted	103	); Software Caused Connection Abort 
 (connreset	104	); Connection Reset By Peer 
 (nobufs	105	); No Buffer Space Available 
 (isconn	106	); Transport Endpoint Is Already Connected 
 (notconn	107	); Transport Endpoint Is Not Connected 
 (shutdown	108	); Cannot Send After Transport Endpoint Shutdown 
 (toomanyrefs	109	); Too Many References: Cannot Splice 
 (timedout	110	); Connection Timed Out 
 (connrefused	111	); Connection Refused 
 (hostdown	112	); Host Is Down 
 (hostunreach	113	); No Route To Host 
 (already	114	); Operation Already In Progress 
 (inprogress	115	); Operation Now In Progress 
 (stale		116	); Stale Nfs File Handle 
 (uclean	117	); Structure Needs Cleaning 
 (notnam	118	); Not A Xenix Named Type File 
 (navail	119	); No Xenix Semaphores Available 
 (isnam		120	); Is A Named Type File 
 (remoteio	121	); Remote I/O Error 
 (dquot		122	); Quota Exceeded 
 
 ; Should Never Be Seen By User Programs 
 (restartsys	512)
 (restartnointr	513)
 (restartnohand	514)	; Restart If No Handler.. 
 (noioctlcmd	515))	; No Ioctl Command 
