/*
   Test window generation routines

   $Id: tFIwinXXX.c 1.4 1996/05/23 libtsp-v3r0 $
*/

#include <stdio.h>
#include <libtsp.h>

#define NMAX 100

int
main (argc, argv)

     int argc;
     char *argv[];

{
  int N, Nadv;
  float win[NMAX];
  char *w;
  double a, T1, T2, T3;
  char *h;

  w = argv[1];
  sscanf (argv[2], "%d", &N);

  if (w[0] == 'R') {
    sscanf (argv[3], "%d", &Nadv);
    FIwinRCos (win, N, Nadv);
    h = "tFIwinXXX, Raised Cosine window:";
  }
  else if (w[0] == 'H') {
    sscanf (argv[3], "%lg", &a);
    FIwinHamm (win, N, a);
    h = "tFIwinXXX, Hamming window:";
  }
  else if (w[0] == 'K') {
    sscanf (argv[3], "%lg", &a);
    FIwinKaiser (win, N, a);
    h = "tFIwinXXX, Kaiser window:";
  }
  else if (w[0] == 'G') {
    sscanf (argv[3], "%lg", &a);
    T2 = N * 200./240.;
    T1 = T2 - 0.5;
    T3 = N - 0.25;
    FIwinHCos (win, T1, T2, T3, a);
    h = "tFIwinXXX, Hamming/Cosine window:";
  }
  else
    UThalt ("tFIwinXXX: Invalid window code");

  VRfPrint (stdout, h, win, N);

  return 0;
}
