.TH canon 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
canon - canonical controllable form
.SH CALLING SEQUENCE
.nf
[Ac,Bc,U,ind]=canon(A,B)  
.fi
.SH PARAMETERS
.TP 10
Ac,Bc
: canonical form
.TP 
U
: current basis (square nonsingular matrix)
.TP
ind
: vector of integers, controllability indices
.SH DESCRIPTION
gives the canonical controllable form of the pair \fV(A,B)\fR.
.LP
\fVAc=inv(U)*A*U, Bc=inv(U)*B\fR
.LP
The vector \fVind\fR is made of the \fVepsilon_i\fR's indices
of the pencil \fV[sI - A ,  B]\fR (decreasing order).
For example with \fVind=[3,2]\fR, \fVAc\fR and \fVBc\fR are as follows:
.nf
      [*,*,*,*,*]           [*]
      [1,0,0,0,0]           [0]
Ac=   [0,1,0,0,0]        Bc=[0]
      [*,*,*,*,*]           [*]
      [0,0,0,1,0]           [0]
.fi
If \fV(A,B)\fR is controllable, by an appropriate choice 
of \fVF\fR the \fV*\fR entries of \fVAc+Bc*F\fR 
can be arbitrarily set to desired values (pole placement).
.SH EXAMPLE
.nf
A=[1,2,3,4,5;
   1,0,0,0,0;
   0,1,0,0,0;
   6,7,8,9,0;
   0,0,0,1,0];
B=[1,2;
   0,0;
   0,0;
   2,1;
   0,0];
X=rand(5,5);A=X*A*inv(X);B=X*B;    //Controllable pair 
[Ac,Bc,U,ind]=canon(A,B);  //Two indices --> ind=[3.2];
index=1;for k=1:size(ind,'*')-1,index=[index,1+sum(ind(1:k))];end
Acstar=Ac(index,:);Bcstar=Bc(index,:);
s=poly(0,'s');
p1=s^3+2*s^2-5*s+3;p2=(s-5)*(s-3);   
//p1 and p2 are desired closed-loop polynomials with degrees 3,2
c1=coeff(p1);c1=c1($-1:-1:1);c2=coeff(p2);c2=c2($-1:-1:1);
Acstardesired=[-c1,0,0;0,0,0,-c2];  
//Acstardesired(index,:) is companion matrix with char. pol=p1*p2
F=Bcstar\\(Acstardesired-Acstar);   //Feedbak gain
Ac+Bc*F         // Companion form 
spec(A+B*F/U)   // F/U is the gain matrix in original basis.
.fi
.SH SEE ALSO
obsv_mat, cont_mat, ctr_gram, contrss, ppol, contr, stabil
.SH AUTHOR
F.D.
