.TH cdffnc 1 "Dec 1997" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
cdffnc - cumulative distribution function non-central f-distribution 
.SH CALLING SEQUENCE
.nf
[P,Q]=cdffnc("PQ",F,Dfn,Dfd,Pnonc)
[F]=cdffnc("F",Dfn,Dfd,Pnonc,P,Q);
[Dfn]=cdffnc("Dfn",Dfd,Pnonc,P,Q,F);
[Dfd]=cdffnc("Dfd",Pnonc,P,Q,F,Dfn)
[Pnonc]=cdffnc("Pnonc",P,Q,F,Dfn,Dfd);
.fi 
.SH PARAMETERS
.TP 10
P,Q,F,Dfn,Dfd,Pnonc
: six real vectors of the same size.
.TP
P,Q (Q=1-P)
  The integral from 0 to F of the non-central f-density.
Input range: [0,1-1E-16).
.TP
F  
: Upper limit of integration of the non-central f-density.
Input range: [0, +infinity).
Search range: [0,1E300]
.TP
Dfn
: Degrees of freedom of the numerator sum of squares.
Input range: (0, +infinity).
Search range: [ 1E-300, 1E300]
.TP
Dfd
: Degrees of freedom of the denominator sum of squares.
Must be in range: (0, +infinity).
Input range: (0, +infinity).
Search range: [ 1E-300, 1E300]
.TP
Pnonc
: The non-centrality parameter
Input range: [0,infinity)
Search range: [0,1E4]
.SH DESCRIPTION
Calculates any one parameter of the Non-central F
distribution given values for the others.
.LP
Formula  26.6.20   of   Abramowitz   and   Stegun,  Handbook  of
Mathematical  Functions (1966) is used to compute the cumulative
distribution function.
.LP
Computation of other parameters involve a seach for a value that
produces  the desired  value  of P.   The search relies  on  the
monotinicity of P with the other parameter.
.LP
The computation time  required for this  routine is proportional
to the noncentrality  parameter  (PNONC).  Very large  values of
this parameter can consume immense  computer resources.  This is
why the search range is bounded by 10,000.
.LP
The  value  of the  cumulative  noncentral F distribution is not
necessarily monotone in either degrees  of freedom.  There  thus
may be two values that provide a given  CDF value.  This routine
assumes monotonicity  and will find  an arbitrary one of the two
values.
.LP
From DCDFLIB: Library of Fortran Routines for Cumulative Distribution
Functions, Inverses, and Other Parameters (February, 1994)
Barry W. Brown, James Lovato and Kathy Russell. The University of
Texas.
















