.TH eval3dp 2 "September 1994" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
eval3dp - computes facets of a 3D parametrized surface
.SH CALLING SEQUENCE
.nf
[x,y,z]=eval3dp(fun,p1,p2)
.fi
.SH PARAMETERS
.TP 10
fun
: a Scilab function. 
.TP
p1 
: a vector of size \fVn\fR
.TP
p2
: a vector of size \fVm\fR
.TP
x,y,z 
: return value.Four \fV4x(n-1*m-1)\fR matrices.

.SH DESCRIPTION
Computes a set of facets which describe a 3D surface. The facet number
\fVk\fR is a four sided polygon stored in \fVx(:,k),y(:,k),z(:,k)\fR.
The function \fVfun(p1,p2)\fR computes the \fV(x,y,z)\fR  coordinates 
of the corresponding point on the surface, But for efficiency the
function \fVfun\fR is supposed to work with two vector arguments. 
.SH EXAMPLE
.nf
  p1=linspace(0,2*%pi,10);
  p2=linspace(0,2*%pi,10);
  deff('[x,y,z]=scp(p1,p2)',['x=p1.*sin(p1).*cos(p2)';
                             'y=p1.*cos(p1).*cos(p2)';
                             'z=p1.*sin(p2)'])
  [x,y,z]=eval3dp(scp,p1,p2);
  plot3d(x,y,z)
.fi
.SH SEE ALSO
eval3d, plot3d, feval, genfac3d

