.TH fgrayplot 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
fgrayplot - 2D plot with gray levels
.SH CALLING SEQUENCE
.nf
fgrayplot(x,y,f,[strf,rect,nax])
.fi
.SH PARAMETERS
.TP 10
x,y
:  real vectors of size respectively (1,n1) and (1,n2).
.TP 
f
: an external (analytic expression of the surface)
.TP
strf,rect,nax
: optional arguments, ( see \fVplot2d\fR) 
.SH DESCRIPTION
2D plot of a surface using gray levels; \fVf\fR gives the analytic expression 
of the surface. \fVz=f(x,y)\fR is first computed on the grid specified by 
\fVxr.yr\fR then control is passed to the routine \fVgrayplot\fR. 

Enter the Scilab command \fVfgrayplot()\fR to see a demo.
.SH EXAMPLE 
.nf 
deff('[z]=surf(x,y)','z=x**2+y**2');
fgrayplot(-1:0.1:1,-1:0.1:1,surf,"111",[-2,-2,2,2]);
.fi 
.SH SEE ALSO
Sgrayplot,Sfgrayplot,grayplot
.SH AUTHOR
J.Ph.C..
