.TH param3d 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
param3d1 - set of points or parametric curves in 3-D
.SH CALLING SEQUENCE
.nf
param3d1(x,y,z,[theta,alpha,leg,flag,ebox]
param3d1(x,y,list(z,colors),[theta,alpha,leg,flag,ebox]
.fi
.SH PARAMETERS
.TP 15
x,y,z
: three matrices of the same size \fV[nl,nc]\fR. Each column of the 
matrix code one curve except when \fVnl=1\fR and \fVnc>0\fR in which case 
It is assumed that there's only one curve. If colors is specified, 
it must be a vector of size \fVnc\fR which gives for each curve 
its color ( if \fVcolor[i] >0 \fR ) or the mark which is to be used 
( if \fV color[i] <= 0 \fR ).
.TP
theta, alpha
: gives the coordinates in spherical angle of the observation point 
.TP
leg
: string describing the caption for each axis, the different fields
in the string are separated by the symbol @, for example : "X@Y@Z"
.TP
flag =[type,box] :
where  type and  box have the same meaning as in \fVplot3d\fR
.TP
ebox
: a vector of size (1,6) which gives the boundaries of the plot
\fV[xmin,xmax,ymin,ymax,zmin,zmax]\fR when the value of type is \fV1\fR
.SH DESCRIPTION 
\fVparam3d1\fR is used to obtain a graphic of a parametric curve in R3, 
and can also be used to see a set of points in R3

Enter the command \fVparam3d1()\fR to see a demo.
.SH EXAMPLE 
.nf
t=0:0.1:5*%pi; t=t';
param3d1([sin(t),sin(2*t)],[cos(t),cos(2*t)],...
	list([t/10,sin(t)],[3,2]),35,45,"X@Y@Z",[2,3])
.fi
.SH SEE ALSO
param3d
.SH AUTHOR
J.Ph.C.


