.TH inv G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
inv - matrix inverse
.SH CALLING SEQUENCE
.nf
inv(X)
.fi
.SH PARAMETERS
.TP
X 
: real or complex square matrix, polynomial matrix, rational
matrix in transfer or state-space representation.
.SH DESCRIPTION
\fVinv(X)\fR is the inverse of the square matrix \fVX\fR. A warning
message is printed if \fVX\fR is badly scaled or nearly singular.
.LP
For polynomial matrices or rational matrices in transfer representation,
\fVinv(X)\fR is equivalent to \fVinvr(X)\fR.
.LP
For linear systems in state-space representation (\fVsyslin\fR list),
\fVinvr(X)\fR is equivalent to \fVinvsyslin(X)\fR.
.SH EXAMPLE
.nf
A=rand(3,3);inv(A)*A
//
x=poly(0,'x');
A=[x,1,x;x^2,2,1+x;1,2,3];inv(A)*A
//
A=[1/x,2;2+x,2/(1+x)]
inv(A)*A
//
A=ssrand(2,2,3);
W=inv(A)*A
clean(ss2tf(W))
.fi
.SH SEE ALSO
slash, backslash, pinv, qr, lufact, lusolve, invr, coff, coffg


