.TH projspec 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
projspec - spectral operators 
.SH CALLING SEQUENCE
.nf
[S,P,D,i]=projspec(A)
.fi
.SH PARAMETERS
.TP 12
A
: square matrix
.TP
S, P, D
: square matrices
.TP
i
: integer (index of the zero eigenvalue of \fVA\fR).
.SH DESCRIPTION
Spectral characteristics of \fVA\fR at 0.
.LP
\fVS\fR = reduced resolvent at 0 (\fVS\fR = -Drazin_inverse(\fVA\fR)).
.LP
\fVP\fR = spectral projection at 0.
.LP
\fVD\fR = nilpotent operator at 0.
.LP
\fVindex\fR = index of the 0 eigenvalue.
.LP
One has \fV(s*eye-A)^(-1) = D^(i-1)/s^i +... + D/s^2 + P/s - S - s*S^2 -...\fR
around the singularity s=0.  
.SH EXAMPLE
.nf
deff('j=jdrn(n)','j=zeros(n,n);for k=1:n-1;j(k,k+1)=1;end')
A=sysdiag(jdrn(3),jdrn(2),rand(2,2));X=rand(7,7);
A=X*A*inv(X);
[S,P,D,index]=projspec(A);
index   //size of J-block
trace(P)  //sum of dimensions of J-blocks
A*S-(eye-P)
norm(D^index,1)
.fi
.SH SEE ALSO 
coff
.SH AUTHOR
F. D.


