.TH convex_hull 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
convex_hull - convex hull of a set of points in the plane
.SH CALLING SEQUENCE
.nf
[nhull,ind] = convex_hull(xy)
.fi
.SH PARAMETERS
.TP 3
xy
: 2 x n real matrix
.TP 6
nhull
: integer 
.TP 4
ind
: integer row vector 
.SH DESCRIPTION
\fVconvex_hull\fR finds the convex hull of a given set of n points in
the plane. \fVxy\fR is the 2 x n matrix of the (x,y) coordinates of
the given points. \fVconvex_hull\fR returns in \fVnhull\fR the number
of the points of the boundary of the convex hull and in \fVind\fR the
row vector (of size \fVnhull\fR) giving the indices in \fVxy\fR of the
points of the boundary. The order in \fVind\fR corresponds to
consecutive points on the boundary.
.SH EXAMPLE
.nf
ta=[27 27 3 12 11 12 27 26 26 25 25 24 23 23 21 22 21 20 19 18 18];
ta=[ta  16 15 15 14 12 9 10 6 9 17 8 17 10 20 11 23 23 12 18 28]; 
he=[ 1  2 2  4  5 11 13  1 25 22 24 22 22 19 13 13 14 16 16  9 16];
he=[he  10 10 11 12  2 6  5 5 7  8 7  9  6 11  4 18 13  3 28 17];
g=make_graph('foo',0,28,ta,he);
xx=[46 120 207 286 366 453 543 544 473 387 300 206 136 250 346 408];
g('node_x')=[xx 527 443 306 326 196 139 264  55  58  46 118 513];
yy=[36  34  37  40  38  40  35 102 102  98  93  96 167 172 101 179];
g('node_y')=[yy 198 252 183 148 172 256 259 258 167 109 104 253];
show_graph(g);
xy=[g('node_x');g('node_y')];
[nhull,ind] = convex_hull(xy)
show_nodes(ind);
.fi
