.TH graph_complement 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
graph_complement - complement of a graph 
.SH CALLING SEQUENCE
.nf
g1 = graph_complement(g,[gmax])
.fi
.SH PARAMETERS
.TP 2
g
: graph list
.TP 5
gmax
: graph list
.TP 3
g1
: graph list of the new graph 
.SH DESCRIPTION
\fVgraph_complement\fR returns the undirected graph \fVg1\fR which is the 
complement of the graph \fVg\fR with respect to the corresponding complete 
graph.
When \fVgmax\fR is given, the complement is made with respect to \fVgmax\fR.
\fVg\fR and \fVgmax\fR are supposed to be simple graphs (use \fVgraph_simp\fR 
before calling \fVgraph_complement\fR if necessary) and to have the same 
number of nodes.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 5 5 7 8 8 9 10 10 10 10 11 12 13 13 13 14 15 17 17 16 16];
he=[2 10 3 5 7 4 2 4 6 8 6 9 7 7 11 13 15 12 13 9 10 14 11 16 14 15 1 17];
g=make_graph('foo',1,17,ta,he);
g('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
g('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
g('edge_color')=modulo([1:(edge_number(g))],15)+1;
g('node_diam')=[1:(g('node_number'))]+20;
show_graph(g);
g1=graph_complement(g);
show_graph(g1,'new');
g=graph_complement(g1);
show_graph(g);
.fi
.SH SEE ALSO
graph_sum, graph_simp
