.TH graph_diameter 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
graph_diameter - diameter of a graph
.SH CALLING SEQUENCE
.nf
[d,p] = graph_diameter(g)
.fi
.SH PARAMETERS
.TP 2
g
: graph list 
.TP 2
d
: integer
.TP 2
p
: integer row vector
.SH DESCRIPTION
\fVgraph_diameter\fR computes the diameter of the graph \fVg\fR i.e. the 
largest shortest path between two nodes. The length of the arcs are
supposed to be integer (and the default value is 1). The output is the value 
\fVd\fR of the length of
the diameter and \fVp\fR is the corresponding path.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 5 5 7 8 8 9 10 10 10 10 11 12 13 13 14 15 16 16 17 17];
he=[2 10 3 5 7 4 2 4 6 8 6 9 7 7 11 13 15 12 13  9 14 11 16 1 17 14 15];
g=make_graph('foo',0,17,ta,he);
g('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
g('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
g('node_diam')=[1:(g('node_number'))]+20;
show_graph(g);
[d,p] = graph_diameter(g)
show_arcs(p);
.fi
.SH SEE ALSO
graph_center
