.TH graph_union 1 "September 1996" "Scilab Group" "Scilab function"
.so ../sci.an
.SH NAME
graph_union - union of two graphs
.SH CALLING SEQUENCE
.nf
g2 = graph_union(g,g1)
.fi
.SH PARAMETERS
.TP 2
g
: graph list
.TP 3
g1
: graph list
.TP 3
g2
: graph list of the new graph 
.SH DESCRIPTION
\fVgraph_union\fR creates a new graph \fVg2\fR. The node set of \fVg2\fR
is the union (in the usual sense) of the node sets of \fVg\fR and \fVg1\fR.
\fVg2\fR has an edge for each edge of \fVg\fR and an edge for each edge of 
\fVg1\fR.
The edges of \fVg\fR and \fVg1\fR having the same endpoints are kept 
and in this case \fVg2\fR has multiple edges.
.SH EXAMPLE
.nf
ta=[1 1 2 2 2 3 4 5 5 7 8 8 9 10 10 10 10 10 11 12 13 13 13 14 15 16 16 17 17];
he=[2 10 3 5 7 4 2 4 6 8 6 9 7 7 11 13 13 15 12 13 9 10 14 11 16 1 17 14 15];
g=make_graph('foo',1,17,ta,he);
g('node_x')=[283 163 63 57 164 164 273 271 339 384 504 513 439 623 631 757 642];
g('node_y')=[59 133 223 318 227 319 221 324 432 141 209 319 428 443 187 151 301];
g('edge_color')=modulo([1:(edge_number(g))],15)+1;
g('node_diam')=[1:(g('node_number'))]+20;
g('node_name')=['A' 'B' 'C' 'D' 'E' 'F' 'G' 'H' 'I' 'J' 'K' 'L' 'M' 'N' 'O' 'P' 'Q'];
show_graph(g);
l=netwindows(); nw=l(2);
v=[7 8 9 10 11 12 13];
show_nodes(v);
g1=subgraph(v,'nodes',g);
show_graph(g1,'new');
v=[1 2 5 6 7 8 9 10];
netwindow(nw);
show_nodes(v);
g2=subgraph(v,'nodes',g);
show_graph(g2,'new');
g=graph_union(g1,g2);
show_graph(g,'new');
.fi
.SH SEE ALSO
supernode, subgraph
