.TH pvm_barrier 1 "May 1998" "Scilab // Group" "Scilab function"
.so ../sci.an
.SH NAME
pvm_barrier - blocks the calling process until all processes
in a group have called it.
.SH CALLING SEQUENCE
.nf
[info] = pvm_barrier(group,count)
.fi
.SH PARAMETERS
.TP 5
type
: string,  name of an existing group. 
.TP 4
count
: integer, specifying the number of group members that must call
pvm_barrier before they are all released.
.TP 4
info
: integer, status code returned by the routine.
.SH DESCRIPTION
\fVpvm_barrier\fR blocks the calling process until
.I count
members of the
.I group
have called pvm_barrier.
The count argument is required because processes could be
joining the given group after other processes have called
pvm_barrier. Thus PVM doesn't know how many group members
to wait for at any given instant. Although count can be set less,
it is typically the total number of members of the group.
So the logical function of the pvm_barrier call
is to provide a group synchronization.
During any given barrier call all participating group members
must call barrier with the same count value.
Once a given barrier has been successfully passed,
pvm_barrier can be called again by the same group using the same
group name.
.PP
If pvm_barrier is successful,
.I info
will be 0. If some error occurs then
.I info
will be < 0.

.SH EXAMPLE
.nf
info = pvm_barrier( "worker", pvm_gsize("worker") )
.fi
.SH SEE ALSO
pvm_joingroup
