.TH curblock  "Janvier 1997" "Scilab Group" "Scicos function"
.so ../sci.an
.SH NAME
curblock - get current block index in a Scicos simulation function
.SH CALLING SEQUENCE
.nf
k=curblock()
.fi
.SH PARAMETERS
.TP 5
k
: integer, index of the block corresponding to the Scilab simulation
function where this function is called.
.SH DESCRIPTION
During simulation it may be interesting to get the index of the current
block to trace execution, to get its label, to animate the block icon
according to simulation...
.LP
For block with a computational function written in Scilab, Scilab
primitive function \fVcurblock()\fR  allows to get the index of the
current block in the compiled data structure.
.LP
To obtain path to the block in the Scicos main structure user may uses
the \fVcorinv\fR table (see scicos_cpr).
.LP 
For block with a computational function written in C user may uses the
C function  \fVk=C2F(getcurblock)()\fR. Where \fVC2F\fR is the C
compilation macro defined in \fV<SCIDIR>/routines/machine.h\fR
.LP
For block with a computational function written in Fortran user may uses the
integer  function  \fVk=getcurblock()\fR.
.SH SEE ALSO
getblocklabel, getscicosvars, setscicosvars, scicos_cpr, scicos_main

