#!/usr/bin/perl

require 5.000;

# use strict;

my(@vendors);
my($cnt) = 0;
my($vendortxt) = "vendorcodes.txt";
my($vendordat) = "vendorcodes.dat";

print "Converting $vendortxt to $vendordat\n";

# read the vendor source text file (expected format:  01:02:03 Vendor)
open(VENDOR, "$vendortxt") || die "$0: can't read $vendortxt: $!\n";
@vendors = <VENDOR>;
close(VENDOR);

# sort vendors by number
@vendors = sort bynumber @vendors;

# create a new vendor binary file
open(BVENDOR, ">$vendordat") || die "$0: can't write $vendordat: $!\n";
foreach (@vendors) {
   my($line, $byte1, $byte2, $byte3, $name);
   chomp;
   next if /^$/;
   ($byte1, $byte2, $byte3, $name) = split(/[: \t]/, $_, 4);
   $line = pack("CCCa50", hex($byte1), hex($byte2), hex($byte3), $name);
   print BVENDOR "$line";
   ++$cnt;
}
close(BVENDOR);

print "$cnt entries converted\n";

sub bynumber {
	($a) cmp ($b);
}
              
sub r_bynumber {
	($b) cmp ($a);
}

