/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		SDPParser.h

	Contains:	Parser for SDP files, it extracts all the interesting metadata

	$Log: SDPParser.h,v $
	Revision 1.2  1999/02/19 23:13:18  ds
	Created
	

*/

#ifndef __SDPPARSER_H__
#define __SDPPARSER_H__

#include "RTSPRequestInterface.h"
#include "RTPStream.h"
#include "StrPtrLen.h"

class SDPParser
{
	public:
	
		SDPParser() : fStreamArray(NULL), fNumStreams(0), fDeleteSDP(true) {}
		~SDPParser();
		
		//This function takes a (potentially reflectable) SDP file and builds an SDP
		//file that appears to be local. This function appends control URLs /trackID=1,
		///trackID=2 as it goes through the file,
		//and these track IDs are in the same order as the stream info queue.
		static char*	ConvertToLocalSDP(StrPtrLen* inCompleteSDPFile, UInt32* newSDPLen);

		//Parses the raw SDP file passed in here. Once you pass in some SDP, this
		//object owns the data, and will be responsible for destroying it.
		void	Parse(char* completeSDPFile, UInt32 completeSDPLen);
		
		//Returns true if this sdp file is for a reflected stream
		bool	IsReflectable();
		
		//Functions that retrieve metadata in the SDP file:
		
		struct StreamInfo
		{
			StreamInfo() : fIPAddr(0), fPort(0), fTimeToLive(0), fCodecType(0), fTrackID(0) {}
			~StreamInfo() {}
			
			UInt32 fIPAddr;
			UInt16 fPort;
			UInt16 fTimeToLive;
			UInt32 fCodecType;//corresponds to a RTPStream codec type
			UInt32 fTrackID;
			StrPtrLen fCodecName;//this is a pointer into the sdp data itself
		};
		
		StreamInfo*	GetStreamInfo(UInt32 inStreamIndex);
		UInt32		GetNumStreams() { return fNumStreams; }
		StrPtrLen*	GetSDPData()	{ return &fSDPData; }
		
		//If you need to free up the sdp data yourself, call this method
		void		DontDeleteSDP()	{ fDeleteSDP = false; }
	
	private:
		
		//utility function used by IsReflectable
		bool IsReflectableIPAddr(UInt32 inIPAddr);

		enum
		{
			kDefaultTTL = 15	//UInt16
		};
		static StrPtrLen	sCLine;
		static StrPtrLen	sVideoStr;
		static StrPtrLen	sAudioStr;
		static StrPtrLen	sRtpMapStr;
		static StrPtrLen	sControlStr;
		
		StreamInfo*	fStreamArray;
		UInt32		fNumStreams;
		StrPtrLen	fSDPData;
		bool		fDeleteSDP;

};
#endif // __SDPPARSER_H__

