/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPSchemaElement;

public class LDAPObjectClassSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = -1732784695071118656L;
    public static final int STRUCTURAL = 0;
    public static final int ABSTRACT = 1;
    public static final int AUXILIARY = 2;
    private Vector must = new Vector();
    private Vector may = new Vector();
    private int type = 0;
    static final String[] NOVALS = new String[]{"ABSTRACT", "STRUCTURAL", "AUXILIARY", "OBSOLETE"};
    static final String[] IGNOREVALS;
    static final String TYPE = "TYPE";

    public LDAPObjectClassSchema(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2) {
        this(string, string2, string3, string4, stringArray, stringArray2, null);
    }

    public LDAPObjectClassSchema(String string, String string2, String[] stringArray, String string3, String[] stringArray2, String[] stringArray3, int n, String[] stringArray4) {
        this(string, string2, stringArray != null && stringArray.length > 0 ? stringArray[0] : null, string3, stringArray2, stringArray3, stringArray4);
        if (stringArray != null && stringArray.length > 1) {
            this.setQualifier("SUP", stringArray);
        }
        this.setQualifier(TYPE, this.typeToString(n));
    }

    protected LDAPObjectClassSchema(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        super(string, string2, string4, stringArray3);
        int n;
        this.attrName = "objectclasses";
        this.setQualifier("SUP", string3);
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                this.must.addElement(stringArray[n]);
                ++n;
            }
        }
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                this.may.addElement(stringArray2[n]);
                ++n;
            }
        }
    }

    public LDAPObjectClassSchema(String string) {
        this.attrName = "objectclasses";
        this.parseValue(string);
        this.setQualifier(TYPE, this.typeToString(this.getType()));
        Object v = this.properties.get("MAY");
        if (v != null) {
            if (v instanceof Vector) {
                this.may = (Vector)v;
            } else {
                this.may.addElement(v);
            }
        }
        if ((v = this.properties.get("MUST")) != null) {
            if (v instanceof Vector) {
                this.must = (Vector)v;
                return;
            }
            this.must.addElement(v);
        }
    }

    public String getSuperior() {
        String[] stringArray = this.getSuperiors();
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public String[] getSuperiors() {
        return this.getQualifier("SUP");
    }

    public Enumeration getRequiredAttributes() {
        return this.must.elements();
    }

    public Enumeration getOptionalAttributes() {
        return this.may.elements();
    }

    public int getType() {
        int n = 0;
        if (this.properties.containsKey("AUXILIARY")) {
            n = 2;
        } else if (this.properties.containsKey("ABSTRACT")) {
            n = 1;
        }
        return n;
    }

    String getValue(boolean bl) {
        String[] stringArray;
        String string = this.getValuePrefix();
        String string2 = this.getValue("SUP", bl);
        if (string2 != null && string2.length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        if ((stringArray = this.getQualifier(TYPE)) != null && stringArray.length > 0) {
            string = String.valueOf(string) + stringArray[0] + ' ';
        }
        if ((string2 = this.getOptionalValues(NOVALS)).length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        if (this.must.size() > 0) {
            string = String.valueOf(string) + "MUST " + this.vectorToList(this.must);
            string = String.valueOf(string) + ' ';
        }
        if (this.may.size() > 0) {
            string = String.valueOf(string) + "MAY " + this.vectorToList(this.may);
            string = String.valueOf(string) + ' ';
        }
        if ((string2 = this.getCustomValues()).length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        string = String.valueOf(string) + ')';
        return string;
    }

    public String toString() {
        int n;
        String string = "Name: " + this.name + "; OID: " + this.oid + "; Superior: ";
        String[] stringArray = this.getSuperiors();
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                string = String.valueOf(string) + stringArray[n];
                if (n < stringArray.length - 1) {
                    string = String.valueOf(string) + ", ";
                }
                ++n;
            }
        }
        string = String.valueOf(string) + "; Description: " + this.description + "; Required: ";
        n = 0;
        Enumeration enumeration = this.getRequiredAttributes();
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
            string = String.valueOf(string) + (String)enumeration.nextElement();
        }
        string = String.valueOf(string) + "; Optional: ";
        enumeration = this.getOptionalAttributes();
        n = 0;
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
            string = String.valueOf(string) + (String)enumeration.nextElement();
        }
        String[] stringArray2 = this.getQualifier(TYPE);
        if (stringArray2 != null && stringArray2.length > 0) {
            string = String.valueOf(string) + "; " + stringArray2[0];
        }
        if (this.isObsolete()) {
            string = String.valueOf(string) + "; OBSOLETE";
        }
        string = String.valueOf(string) + this.getQualifierString(IGNOREVALS);
        string = String.valueOf(string) + this.getAliasString();
        return string;
    }

    protected String vectorToList(Vector vector) {
        String string = "( ";
        int n = 0;
        while (n < vector.size()) {
            string = String.valueOf(string) + (String)vector.elementAt(n) + ' ';
            if (n < vector.size() - 1) {
                string = String.valueOf(string) + "$ ";
            }
            ++n;
        }
        string = String.valueOf(string) + ')';
        return string;
    }

    protected String typeToString(int n) {
        switch (n) {
            case 0: {
                return "STRUCTURAL";
            }
            case 1: {
                return "ABSTRACT";
            }
            case 2: {
                return "AUXILIARY";
            }
        }
        return null;
    }

    static {
        int n = 0;
        while (n < NOVALS.length) {
            LDAPSchemaElement.novalsTable.put(NOVALS[n], NOVALS[n]);
            ++n;
        }
        IGNOREVALS = new String[]{"ABSTRACT", "STRUCTURAL", "AUXILIARY", "MUST", "MAY", "SUP", "OBSOLETE"};
    }
}

