/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.ExternalCoder;
import netscape.util.InconsistencyException;

class PrimitiveCoder
implements ExternalCoder {
    byte type;

    PrimitiveCoder(byte by) {
        this.type = by;
    }

    public Object newInstance(String string) throws CodingException {
        return null;
    }

    static String classNameForType(byte by) {
        switch (by) {
            case 0: {
                return "java.lang.Boolean";
            }
            case 1: {
                return "[Z";
            }
            case 2: {
                return "java.lang.Character";
            }
            case 3: {
                return "[C";
            }
            case 4: {
                return "java.lang.Byte";
            }
            case 5: {
                return "[B";
            }
            case 6: {
                return "java.lang.Short";
            }
            case 7: {
                return "[S";
            }
            case 8: {
                return "java.lang.Integer";
            }
            case 9: {
                return "[I";
            }
            case 10: {
                return "java.lang.Long";
            }
            case 11: {
                return "[J";
            }
            case 12: {
                return "java.lang.Float";
            }
            case 13: {
                return "[F";
            }
            case 14: {
                return "java.lang.Double";
            }
            case 15: {
                return "[D";
            }
            case 16: {
                return "java.lang.String";
            }
            case 17: {
                return "[Ljava.lang.String;";
            }
        }
        throw new InconsistencyException("Non-primitive type!");
    }

    String className() {
        return PrimitiveCoder.classNameForType(this.type);
    }

    public void describeClassInfo(Object object, ClassInfo classInfo) {
        classInfo.addClass(PrimitiveCoder.classNameForType(this.type), 1);
        classInfo.addField("value", this.type);
    }

    public void encode(Object object, Encoder encoder) throws CodingException {
        switch (this.type) {
            case 0: {
                encoder.encodeBoolean("value", ((Boolean)object).booleanValue());
                return;
            }
            case 1: {
                encoder.encodeBooleanArray("value", (boolean[])object, 0, ((boolean[])object).length);
                return;
            }
            case 2: {
                encoder.encodeChar("value", ((Character)object).charValue());
                return;
            }
            case 3: {
                encoder.encodeCharArray("value", (char[])object, 0, ((char[])object).length);
                return;
            }
            case 4: {
                throw new CodingException("java.lang.Byte not supported");
            }
            case 5: {
                encoder.encodeByteArray("value", (byte[])object, 0, ((byte[])object).length);
                return;
            }
            case 6: {
                throw new CodingException("java.lang.Short not supported");
            }
            case 7: {
                encoder.encodeShortArray("value", (short[])object, 0, ((short[])object).length);
                return;
            }
            case 8: {
                encoder.encodeInt("value", ((Integer)object).intValue());
                return;
            }
            case 9: {
                encoder.encodeIntArray("value", (int[])object, 0, ((int[])object).length);
                return;
            }
            case 10: {
                encoder.encodeLong("value", ((Long)object).longValue());
                return;
            }
            case 11: {
                encoder.encodeLongArray("value", (long[])object, 0, ((long[])object).length);
                return;
            }
            case 12: {
                encoder.encodeFloat("value", ((Float)object).floatValue());
                return;
            }
            case 13: {
                encoder.encodeFloatArray("value", (float[])object, 0, ((float[])object).length);
                return;
            }
            case 14: {
                encoder.encodeDouble("value", ((Double)object).doubleValue());
                return;
            }
            case 15: {
                encoder.encodeDoubleArray("value", (double[])object, 0, ((double[])object).length);
                return;
            }
            case 16: {
                encoder.encodeString("value", (String)object);
                return;
            }
            case 17: {
                encoder.encodeStringArray("value", (String[])object, 0, ((String[])object).length);
                return;
            }
        }
        throw new CodingException("Non-primitive type!");
    }

    public void decode(Object object, Decoder decoder) throws CodingException {
        Object object2;
        switch (this.type) {
            case 0: {
                if (decoder.decodeBoolean("value")) {
                    object2 = Boolean.TRUE;
                    break;
                }
                object2 = Boolean.FALSE;
                break;
            }
            case 1: {
                object2 = decoder.decodeBooleanArray("value");
                break;
            }
            case 2: {
                object2 = new Character(decoder.decodeChar("value"));
                break;
            }
            case 3: {
                object2 = decoder.decodeCharArray("value");
                break;
            }
            case 4: {
                throw new CodingException("java.lang.Byte not supported");
            }
            case 5: {
                object2 = decoder.decodeByteArray("value");
                break;
            }
            case 6: {
                throw new CodingException("java.lang.Short not supported");
            }
            case 7: {
                object2 = decoder.decodeShortArray("value");
                break;
            }
            case 8: {
                object2 = new Integer(decoder.decodeInt("value"));
                break;
            }
            case 9: {
                object2 = decoder.decodeIntArray("value");
                break;
            }
            case 10: {
                object2 = new Long(decoder.decodeLong("value"));
                break;
            }
            case 11: {
                object2 = decoder.decodeLongArray("value");
                break;
            }
            case 12: {
                object2 = new Float(decoder.decodeFloat("value"));
                break;
            }
            case 13: {
                object2 = decoder.decodeFloatArray("value");
                break;
            }
            case 14: {
                object2 = new Double(decoder.decodeDouble("value"));
                break;
            }
            case 15: {
                object2 = decoder.decodeDoubleArray("value");
                break;
            }
            case 16: {
                object2 = decoder.decodeString("value");
                break;
            }
            case 17: {
                object2 = decoder.decodeStringArray("value");
                break;
            }
            default: {
                throw new CodingException("Non-primitive type!");
            }
        }
        decoder.replaceObject(object2);
    }

    public void finishDecoding(Object object) throws CodingException {
    }
}

