#!/bin/sh
# NetscapeΥ˥塼δʰץեץ
#      $ setfont.sh 12 
# Ȥ褦Ѥ롣

IN_FILE=Netscape.ad.in
OUT_FILE=Netscape.ad

JA_LANGS="ja_JP.ujis ja_JP.EUC ja_JP.euc ja_JP.eucJP Japanese japanese ja"

#
# Usage
#
usage () {
    echo usage: `basename $0`   xfontsize
    echo ""
    echo This script allows you to modifiy the Netscape\'s toolkit fonts
    echo such as menus, toolbar, etc...
    echo "xfontsize" is \"tiny\", \"small\", \"medium\", \"large\" or number.
    echo ""
    exit 0
}

#
# Search default file path
#

for L in $JA_LANGS ;do
    OUT=`echo $OUT_FILE |sed -e "s/%L/$L/g"  -e "s/%N/Netscape/g"`
    [ -f  $OUT ] && break;
done

for L in $JA_LANGS ;do
    IN=`echo $IN_FILE |sed -e "s/%L/$L/g" -e "s/%N/Netscape/g"`
    NSLANG=$L
    [ -f  $IN ] && break;
done

set -- `getopt hf:o: $*`

while [ $# != 0 ]; do
    case "$1" in
        --) ;;
        -h) usage ;;
        -o) shift > /dev/null 2> /dev/null 
	    OUT=$1
	    [ $OUT = "-" ] && OUT=/dev/stdout
	    ;;
        -f) shift > /dev/null 2> /dev/null 
	    IN=$1
	    [ $IN = "-" ] && IN=/dev/stdin
	    ;;
         *) XFONTSIZE=$1;;
    esac
    shift > /dev/null 2> /dev/null 
done

#
# Set variable needed
#

case "$XFONTSIZE" in
  16|h*|H*)       XFONTSIZE=16;DOCFONTSIZE=16;;
  14|l*|L*)       XFONTSIZE=14;DOCFONTSIZE=14;;
  12|m*|M*|n*|N*) XFONTSIZE=12;DOCFONTSIZE=14;;
  10|s*|S*)       XFONTSIZE=10;DOCFONTSIZE=12;;
esac

[ -z "$XFONTSIZE" ] && usage

echo ""
echo "createing new $OUT..."

#
# Make backup
#
[ -f $OUT.bak ] && rm -f $OUT.bak
[ -f $OUT     ] && mv -f $OUT $OUT.bak

#
# Create new resource  file.
#
sed \
 -e "s/-dt-interface system-medium-\*-\*-S\*-\*-\*-\*-\*-\*-\*-\*-\*/-adobe-helvetica-medium-r-*--$XFONTSIZE-*-*-*-*-*-*-*;-misc-*-medium-r-*--$XFONTSIZE-*-*-*-*-*-*-*/g" \
 -e "s/@LANG@/$NSLANG/g" \
 -e "s/@XFONTSIZE@/$XFONTSIZE/g" \
 -e "s/@DOCFONTSIZE@/$DOCFONTSIZE/g" \
< $IN> $OUT
echo "done"
