#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>

#include "interface.h"

#include "treedata.h"

static tsave sf=NULL;
static file_type format;
static tpmsg savemsg;
static tpchoice file_type_menu;
static tpitem file_type_items[NoFileType];
static char savename[256];

int pick_file_type(m, i)
tpchoice m;
tpitem i;
{
	file_type f;
	static char buf[80];
	static char oldbuf[80];
	static char curname[80];

	f=(file_type)titem_get_data(i);
	typed_shortname(globals->filename, format, oldbuf);
	tsave_get_filename(sf, curname);
	if(strcmp(curname, oldbuf)==0)
	{
		typed_shortname(globals->filename, f, buf);
		/*xx*/if(strlen(buf)>=80)fprintf(stderr,"pick_file_type overran buf\n");
		tsave_change_filename(sf, buf);
	}
	format=f;
}

int savefile_exists(s)
char *s;
{
    struct stat buf;

    if(stat(s, buf)==0)
		return(1);
    else
		return(0);
}

int attempt_save(s, e)
char *s;
tevent e;
{
    int a;
    int do_save;
    char buf[80];

	if(s==NULL)
		return(1);

    do_save=0;

	seteventloc(e);
    if(savefile_exists(s))
    {
		if(strcmp(s, globals->filename)==0)
			do_save=1;
		else
		{
			sprintf(buf, "The file '%s' already exists.",
				shortname(s));
				/*xx*/if(strlen(buf)>=80)fprintf(stderr,"attempt_save overran buf\n");
			a=tnotice_2line_2answer(globals->ewin, globals->ex, globals->ey,
				buf, "Do you wish to replace it?",
				"Yes", "No");
			if(a==2)
				do_save=0;
			else if(a==1)
				do_save=1;
		}
    }
    else
		do_save=1;

    if(do_save)
		do_command(Save, s, NULL, 0.0, 0.0,
			format, 0, 0, 0, 0);

    return(1);
}

create_save_dialog(p)
tframe p;
{
    char buf[1026];
	tpanel sp;
	titem below;

    getcwd(buf, 1024);
    sf=(tsave)tsave_new(p, 100, 100, globals->listfont, attempt_save,
		globals->args,
		"Save File", buf, "Untitled");
	tsave_get_panel(sf, &sp, &below);
	savemsg=(tpmsg)tpmsg_new(sp, 10, 0, 0, 0, NULL, below,
		"Format: ");
	tpmsg_set_bold(savemsg);
	file_type_menu=(tpchoice)tpchoice_new(sp, 0, 0, 0, 0, savemsg, below,
		"Type", 1);
	file_type_items[Treetool]=(tpitem)tpitem_new("Treetool",
		pick_file_type);
	tpchoice_add(file_type_menu, file_type_items[Treetool], NULL);
	file_type_items[Newick]=(tpitem)tpitem_new("Newick",
		pick_file_type);
	tpchoice_add(file_type_menu, file_type_items[Newick], NULL);
	file_type_items[Prolog]=(tpitem)tpitem_new("Prolog",
		pick_file_type);
	tpchoice_add(file_type_menu, file_type_items[Prolog], NULL);
	file_type_items[PostScript]=(tpitem)tpitem_new("PostScript",
		pick_file_type);
	tpchoice_add(file_type_menu, file_type_items[PostScript], NULL);
	file_type_items[PICT]=(tpitem)tpitem_new("PICT",
		pick_file_type);
	tpchoice_add(file_type_menu, file_type_items[PICT], NULL);
	file_type_items[List]=(tpitem)tpitem_new("Species List",
		pick_file_type);
	tpchoice_add(file_type_menu, file_type_items[List], NULL);
	tpchoice_set_default_item(file_type_menu, 0);
	tpchoice_select_item(file_type_menu, file_type_items[Treetool]);

	titem_set_data(file_type_items[Treetool], Treetool);
	titem_set_data(file_type_items[Newick], Newick);
	titem_set_data(file_type_items[Prolog], Prolog);
	titem_set_data(file_type_items[PostScript], PostScript);
	titem_set_data(file_type_items[PICT], PICT);
	titem_set_data(file_type_items[List], List);
	
	tsave_refit_panel(sf);
}
 
show_save_dialog()
{
	tsave_move(sf, globals->ewin, globals->ex, globals->ey);
	if(number_of_trees()==0)
	{
		tnotice_no_choice(globals->ewin, globals->ex, globals->ey,
			"No Trees to save");
		return;
	}
    tsave_show(sf);
}

hide_save_dialog()
{
	tsave_pull_pin(sf);
    tsave_hide(sf);
}

void save_change_filename(s, f)
char *s;
file_type f;
{
	static char *buf[80];

	if(sf==NULL)
		return;

	if(s==NULL)
		return;
	if(f!=NoFileType)
	{
		format=f;
		tpchoice_select_item(file_type_menu, file_type_items[f]);
	}
	typed_shortname(s, f, buf);
	/*xx*/if(strlen(buf)>=80)fprintf(stderr,"save_change_filename overran buf\n");
	strcpy(savename, buf);
	tsave_change_filename(sf, buf);

}

save_busy()
{
	if(sf!=NULL)
		tsave_set_busy(sf);
}

save_notbusy()
{
	if(sf!=NULL)
		tsave_set_notbusy(sf);
}
