------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             E X P _ D B U G                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.4 $                              --
--                                                                          --
--            Copyright (C) 1996 Free Software Foundation, Inc.             --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

with Atree;    use Atree;
with Einfo;    use Einfo;
with Exp_Util; use Exp_Util;
with Namet;    use Namet;
with Nlists;   use Nlists;
with Nmake;    use Nmake;
with Sinfo;    use Sinfo;
with Tbuild;   use Tbuild;
with Uintp;    use Uintp;
with Urealp;   use Urealp;

package body Exp_Dbug is

   ----------------------
   -- Local Procedures --
   ----------------------

   procedure Add_String_To_Buffer (S : String);
   --  Add given string to Name_Buffer, updating Name_Len

   procedure Add_Integer_To_Buffer (U : Uint);
   --  Add image of universal integer to Name_Buffer, updating Name_Len

   procedure Add_Real_To_Buffer (U : Ureal);
   --  Add nnn_ddd to Name_Buffer, where nnn and ddd are integer values of
   --  the normalized numerator and denominator of the given real value.

   ---------------------------
   -- Add_Integer_To_Buffer --
   ---------------------------

   procedure Add_Integer_To_Buffer (U : Uint) is
   begin
      UI_Image (U, Decimal);
      Name_Buffer (Name_Len + 1 .. Name_Len + UI_Image_Length) :=
        UI_Image_Buffer (1 .. UI_Image_Length);
      Name_Len := Name_Len + UI_Image_Length;
   end Add_Integer_To_Buffer;

   ------------------------
   -- Add_Real_To_Buffer --
   ------------------------

   procedure Add_Real_To_Buffer (U : Ureal) is
   begin
      Add_Integer_To_Buffer (Norm_Num (U));
      Add_String_To_Buffer ("_");
      Add_Integer_To_Buffer (Norm_Den (U));
   end Add_Real_To_Buffer;

   --------------------------
   -- Add_String_To_Buffer --
   --------------------------

   procedure Add_String_To_Buffer (S : String) is
   begin
      Name_Buffer (Name_Len + 1 .. Name_Len + S'Length) := S;
      Name_Len := Name_Len + S'Length;
   end Add_String_To_Buffer;

   ---------------------------
   -- Get_Encoded_Type_Name --
   ---------------------------

   function Get_Encoded_Type_Name (E : Entity_Id) return Name_Id is
   begin
      --  For the fixed-point case, the encoded name is one of

      --    name_DELTA_nn_dd
      --    name_DELTA_nn_dd_SMALL_nn_dd

      --  The second form is used if the SMALL is different from the DELTA.
      --  In either case nn/dd is the numerator/denominator as a decimal
      --  integer (with a possible unsigned exponent)

      if Is_Fixed_Point_Type (E) then

         Get_Name_String (Chars (E));
         Add_String_To_Buffer ("_DELTA_");
         Add_Real_To_Buffer (Delta_Value (E));

         if Small_Value (E) /= Delta_Value (E) then
            Add_String_To_Buffer ("_SMALL_");
            Add_Real_To_Buffer (Small_Value (E));
         end if;

         return Name_Enter;

      --  For all other cases, the encoded name is the normal type name

      else
         return Chars (E);
      end if;
   end Get_Encoded_Type_Name;

end Exp_Dbug;
