.TH gk_topicWindow n "25 August 1995" "GroupKit"
.SH NAME
gk_topicWindow \- Display information about an application
.SH SYNOPSIS
.TP 
\fBgk_topicWindow\fI pathname \fR?\fIoptions\fR?

.SH "STANDARD OPTIONS"
.nf
.ta 4c 8c 12c
.VS
\fBbackground	highlightColor	padY	spacing3
\fBborderWidth	highlightThickness	relief	state
\fBcursor	insertBackground	selectBackground	tabs
\fBexportSelection	insertBorderWidth	selectBorderWidth	takeFocus
\fBfont	insertOffTime	selectForeground xScrollCommand
\fBforeground	insertOnTime	setGrid	yScrollCommand
\fBheight	insertWidth	spacing1	width
\fBhighlightBackground	padX	spacing2	wrap
\fR

.VE
.fi

See the ``options'' manual entry for details on the standard options.
.br
Also see the ``text'' manual entry for more details on the text options.

.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.nf
Name:	\fBlarge\fR
Class:	\fBLarge\fR
Command-Line Switch:	\fB\-large\fR
.fi
.IP
Specifies the large font used for display.
.LP

.ta 4c
.nf
Name:	\fBlargeBold\fR
Class:	\fBLargeBold\fR
Command-Line Switch:	\fB\-largebold\fR
.fi
.IP
Specifies the large bold font used for display.
.LP

.ta 4c
.nf
Name:	\fBlargeBoldItalic\fR
Class:	\fBLargeBoldItalic\fR
Command-Line Switch:	\fB\-largebolditalic\fR
.fi
.IP
Specifies the large bold italic font used for display.
.LP

.ta 4c
.nf
Name:	\fBlargeItalic\fR
Class:	\fBLargeItalic\fR
Command-Line Switch:	\fB\-largeitalic\fR
.fi
.IP
Specifies the large italic font used for display.
.LP

.ta 4c
.nf
Name:	\fBnormal\fR
Class:	\fBNormal\fR
Command-Line Switch:	\fB\-normal\fR
.fi
.IP
Specifies the normal font used for display.
.LP

.ta 4c
.nf
Name:	\fBnormalBold\fR
Class:	\fBNormalBold\fR
Command-Line Switch:	\fB\-normalbold\fR
.fi
.IP
Specifies the normal bold font used for display.
.LP

.ta 4c
.nf
Name:	\fBnormalBoldItalic\fR
Class:	\fBNormalBoldItalic\fR
Command-Line Switch:	\fB\-normalbolditalic\fR
.fi
.IP
Specifies the normal bold italic font used for display.
.LP

.ta 4c
.nf
Name:	\fBnormalItalic\fR
Class:	\fBNormalItalic\fR
Command-Line Switch:	\fB\-normalitalic\fR
.fi
.IP
Specifies the normal italic font used for display.
.LP

.ta 4c
.nf
Name:	\fBtext\fR
Class:	\fBText\fR
Command-Line Switch:	\fB\-text\fR
.fi
.IP
Specifies the text to be displayed in the scrollable portion of the
text window.  The text should be of the format:

{ {fonttype} {text} {fonttype} {text} ...}

Fonttype can be one of: large, largebold, largebolditalic, largeitalic,
normal, normalbold, normalbolditalic, or normalitalic.
.LP

.ta 4c
.nf
Name:	\fBtitle\fR
Class:	\fBTitle\fR
Command-Line Switch:	\fB\-title\fR
.fi
.IP
Specifies the title to be displayed at the top of the window and its frame.
.LP

.SH DESCRIPTION
This widget can be used to display help messages, consisting of text
in a variety of different fonts, in a window.

.SH "WIDGET COMMAND"
The \fBgk_topicWindow\fR command creates a new Tcl command whose name is
\fIpathName\fR.  This command may be used to invoke various operations
on the widget.  It has the following general form:
.IP
\fIpathName option \fR?\fIarg arg ...\fR?
.LP
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.  The following commands are possible for gk_topicWindow widgets:
.TP
\fIpathName \fBbutton\fR
Return the path name of the button at the bottom of the widget.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBgk_topicWindow\fR
command.
.TP
\fIpathName \fBcget \fIoption\fR
Returns  the  current value of the configuration option
given by option.  Option may have  any  of  the  values
accepted by the text command.
.TP
\fIpathName \fBscrollbar\fR
Return the path name of the widget's scrollbar.
.TP
\fIpathName \fBtext\fR
Return the path name of the widget's text widget.
.TP
\fIpathName \fBtitle\fR
Return the path name of the widget's title label.
.TP
\fIpathName \fBwindow\fR
Return the path name of the widget's toplevel window.

.SH "DEFAULT BINDINGS"
The dismiss button destroys the window when pressed.

.SH NOTE
This widget is built using the GroupKit class builder; see the
GroupKit User Manual for more information.

.SH AUTHOR
Shannon Jaeger (jaeger@cpsc.ucalgary.ca)
