/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */

#include <stdio.h>
#include "_scm.h"

#ifdef __STDC__
#include <stdarg.h>
#define var_start(x, y) va_start(x, y)
#else
#include <varargs.h>
#define var_start(x, y) va_start(x)
#endif




/* {Pairs}
 */

PROC (s_cons, "cons", 2, 0, 0, scm_cons);
#ifdef __STDC__
SCM 
scm_cons (SCM x, SCM y)
#else
SCM 
scm_cons (x, y)
     SCM x;
     SCM y;
#endif
{
  register SCM z;
  NEWCELL (z);
  CAR (z) = x;
  CDR (z) = y;
  return z;
}

#ifdef __STDC__
SCM 
scm_cons2 (SCM w, SCM x, SCM y)
#else
SCM 
scm_cons2 (w, x, y)
     SCM w;
     SCM x
     SCM y;
#endif
{
  register SCM z;
  NEWCELL (z);
  CAR (z) = x;
  CDR (z) = y;
  x = z;
  NEWCELL (z);
  CAR (z) = w;
  CDR (z) = x;
  return z;
}

#ifdef __STDC__
SCM
scm_listify (SCM elt, ...)
#else
SCM
scm_listify (elt, va_alist)
     SCM elt;
     va_dcl

#endif
{
  va_list foo;
  SCM answer;
  SCM *pos;

  var_start (foo, elt);
  answer = EOL;
  pos = &answer;
  while (elt != SCM_UNDEFINED)
    {
      *pos = scm_cons (elt, EOL);
      pos = &CDR (*pos);
      elt = va_arg (foo, SCM);
    }
  return answer;
}

PROC (s_acons, "acons", 3, 0, 0, scm_acons);
#ifdef __STDC__
SCM 
scm_acons (SCM w, SCM x, SCM y)
#else
SCM 
scm_acons (w, x, y)
     SCM w;
     SCM x
     SCM y;
#endif
{
  register SCM z;
  NEWCELL (z);
  CAR (z) = w;
  CDR (z) = x;
  x = z;
  NEWCELL (z);
  CAR (z) = x;
  CDR (z) = y;
  return z;
}




PROC (s_pair_p, "pair?", 1, 0, 0, scm_pair_p);
#ifdef __STDC__
SCM
scm_pair_p(SCM x)
#else
SCM
scm_pair_p(x)
     SCM x;
#endif
{
	if IMP(x) return BOOL_F;
	return CONSP(x) ? BOOL_T : BOOL_F;
}

PROC (s_set_car_x, "set-car!", 2, 0, 0, scm_set_car_x);
#ifdef __STDC__
SCM
scm_set_car_x(SCM pair, SCM value)
#else
SCM
scm_set_car_x(pair, value)
     SCM pair;
     SCM value;
#endif
{
	ASSERT(NIMP(pair) && CONSP(pair), pair, ARG1, s_set_car_x);
	CAR(pair) = value;
#ifdef GUILE
	return value;
#else
	return UNSPECIFIED;
#endif
}

PROC (s_set_cdr_x, "set-cdr!", 2, 0, 0, scm_set_cdr_x);
#ifdef __STDC__
SCM
scm_set_cdr_x(SCM pair, SCM value)
#else
SCM
scm_set_cdr_x(pair, value)
     SCM pair
     SCM value;
#endif
{
	ASSERT(NIMP(pair) && CONSP(pair), pair, ARG1, s_set_cdr_x);
	CDR(pair) = value;
#ifdef GUILE
	return value;
#else
	return UNSPECIFIED;
#endif
}


PROC (s_null_p, "null?", 1, 0, 0, scm_null_p);
#ifdef __STDC__
SCM
scm_null_p(SCM x)
#else
SCM
scm_null_p(x)
     SCM x;
#endif
{
	return NULLP(x) ? BOOL_T : BOOL_F;
}

#ifdef __STDC__
long
scm_ilength(SCM sx)
#else
long
scm_ilength(sx)
     SCM sx;
#endif
{
	register long i = 0;
	register SCM x = sx;
	do {
		if IMP(x) return NULLP(x) ? i : -1;
		if NCONSP(x) return -1;
		x = CDR(x);
		i++;
		if IMP(x) return NULLP(x) ? i : -1;
		if NCONSP(x) return -1;
		x = CDR(x);
		i++;
		sx = CDR(sx);
	}
	while (x != sx);
	return -1;
}

PROC (s_list_p, "list?", 1, 0, 0, scm_list_p);
#ifdef __STDC__
SCM
scm_list_p(SCM x)
#else
SCM
scm_list_p(x)
     SCM x;
#endif
{
	if (scm_ilength(x)<0) return BOOL_F;
	else return BOOL_T;
}

PROC (s_list, "list", 0, 0, 1, scm_list);
#ifdef __STDC__
SCM
scm_list(SCM objs)
#else
SCM
scm_list(objs)
     SCM objs;
#endif
{
  return objs;
}

PROC (s_list_length, "list-length", 1, 0, 0, scm_list_length);
#ifdef __STDC__
SCM
scm_list_length(SCM x)
#else
SCM
scm_list_length(x)
     SCM x;
#endif
{
  int i;
  i = scm_ilength(x);
  ASSERT(i >= 0, x, ARG1, s_list_length);
  return MAKINUM (i);
}


#ifdef __STDC__
int
scm_obj_length (SCM obj)
#else
int
scm_obj_length (obj)
     SCM obj;
#endif
{
  int i;
  i = scm_ilength(obj);
  if (i >= 0)
    return i;
  else if (NIMP (obj))
    {
      if (ROSTRINGP (obj))
	return LENGTH (obj);
      else if (VECTORP (obj))
	return LENGTH (obj);
      else
	return -1;
    }
  else
    return -1;
}


PROC (s_length, "length", 1, 0, 0, scm_length);
#ifdef __STDC__
SCM
scm_length(SCM x)
#else
SCM
scm_length(x)
     SCM x;
#endif
{
  int i;
  i = scm_obj_length(x);
  if (i >= 0)
    return MAKINUM (i);
  else
    {
      ASSERT(0, x, ARG1, s_length);
      return BOOL_F;
    }
}


PROC (s_append, "append", 0, 0, 1, scm_append);
#ifdef __STDC__
SCM
scm_append(SCM args)
#else
SCM
scm_append(args)
     SCM args;
#endif
{
	SCM res = EOL;
	SCM *lloc = &res, arg;
	if IMP(args) {
		ASSERT(NULLP(args), args, ARGn, s_append);
		return res;
		}
	ASSERT(CONSP(args), args, ARGn, s_append);
	while (1) {
		arg = CAR(args);
		args = CDR(args);
		if IMP(args) {
			*lloc = arg;
			ASSERT(NULLP(args), args, ARGn, s_append);
			return res;
		}
		ASSERT(CONSP(args), args, ARGn, s_append);
		for(;NIMP(arg);arg = CDR(arg)) {
			ASSERT(CONSP(arg), arg, ARGn, s_append);
			*lloc = scm_cons(CAR(arg), EOL);
			lloc = &CDR(*lloc);
		}
		ASSERT(NULLP(arg), arg, ARGn, s_append);
	}
}

PROC (s_reverse, "reverse", 1, 0, 0, scm_reverse);
#ifdef __STDC__
SCM
scm_reverse(SCM lst)
#else
SCM
scm_reverse(lst)
     SCM lst;
#endif
{
	SCM res = EOL;
	SCM p = lst;
	for(;NIMP(p);p = CDR(p)) {
		ASSERT(CONSP(p), lst, ARG1, s_reverse);
		res = scm_cons(CAR(p), res);
	}
	ASSERT(NULLP(p), lst, ARG1, s_reverse);
	return res;
}


PROC (s_list_ref, "list-ref", 2, 0, 0, scm_list_ref);
#ifdef __STDC__
SCM
scm_list_ref(SCM lst, SCM k)
#else
SCM
scm_list_ref(lst, k)
     SCM lst;
     SCM k;
#endif
{
	register long i;
	ASSERT(INUMP(k), k, ARG2, s_list_ref);
	i = INUM(k);
	ASSERT(i >= 0, k, ARG2, s_list_ref);
	while (i-- > 0) {
		ASRTGO(NIMP(lst) && CONSP(lst), erout);
		lst = CDR(lst);
	}
erout:	ASSERT(NIMP(lst) && CONSP(lst),
	       NULLP(lst)?k:lst, NULLP(lst)?OUTOFRANGE:ARG1, s_list_ref);
	return CAR(lst);
}

PROC (s_list_set_x, "list-set!", 3, 0, 0, scm_list_set_x);
#ifdef __STDC__
SCM
scm_list_set_x(SCM lst, SCM k, SCM val)
#else
SCM
scm_list_set_x(lst, k, val)
     SCM lst;
     SCM k;
     SCM val;
#endif
{
	register long i;
	ASSERT(INUMP(k), k, ARG2, s_list_set_x);
	i = INUM(k);
	ASSERT(i >= 0, k, ARG2, s_list_set_x);
	while (i-- > 0) {
		ASRTGO(NIMP(lst) && CONSP(lst), erout);
		lst = CDR(lst);
	}
erout:	ASSERT(NIMP(lst) && CONSP(lst),
	       NULLP(lst)?k:lst, NULLP(lst)?OUTOFRANGE:ARG1, s_list_set_x);
	CAR (lst) = val;
	return val;
}



PROC (s_list_cdr_ref, "list-cdr-ref", 2, 0, 0, scm_list_cdr_ref);
#ifdef __STDC__
SCM
scm_list_cdr_ref(SCM lst, SCM k)
#else
SCM
scm_list_cdr_ref(lst, k)
     SCM lst;
     SCM k;
#endif
{
	register long i;
	ASSERT(INUMP(k), k, ARG2, s_list_cdr_ref);
	i = INUM(k);
	ASSERT(i >= 0, k, ARG2, s_list_cdr_ref);
	while (i-- > 0) {
		ASRTGO(NIMP(lst) && CONSP(lst), erout);
		lst = CDR(lst);
	}
erout:	ASSERT(NIMP(lst) && CONSP(lst),
	       NULLP(lst)?k:lst, NULLP(lst)?OUTOFRANGE:ARG1, s_list_cdr_ref);
	return lst;
}


PROC (s_list_cdr_set_x, "list-cdr-set!", 3, 0, 0, scm_list_cdr_set_x);
#ifdef __STDC__
SCM
scm_list_cdr_set_x(SCM lst, SCM k, SCM val)
#else
SCM
scm_list_cdr_set_x(lst, k, val)
     SCM lst;
     SCM k;
     SCM val;
#endif
{
	register long i;
	ASSERT(INUMP(k), k, ARG2, s_list_cdr_set_x);
	i = INUM(k);
	ASSERT(i >= 0, k, ARG2, s_list_cdr_set_x);
	while (i-- > 0) {
		ASRTGO(NIMP(lst) && CONSP(lst), erout);
		lst = CDR(lst);
	}
erout:	ASSERT(NIMP(lst) && CONSP(lst),
	       NULLP(lst)?k:lst, NULLP(lst)?OUTOFRANGE:ARG1, s_list_cdr_set_x);
	SETCDR (lst, val);
	return val;
}


PROC (s_memq, "memq", 2, 0, 0, scm_memq);
#ifdef __STDC__
SCM
scm_memq(SCM x, SCM lst)
#else
SCM
scm_memq(x, lst)
     SCM x;
     SCM lst;
#endif
{
	for(;NIMP(lst);lst = CDR(lst)) {
		ASSERT(CONSP(lst), lst, ARG2, s_memq);
		if (CAR(lst)==x) return lst;
	}
	ASSERT(NULLP(lst), lst, ARG2, s_memq);
	return BOOL_F;
}

PROC (s_member, "member", 2, 0, 0, scm_member);
#ifdef __STDC__
SCM
scm_member(SCM x, SCM lst)
#else
SCM
scm_member(x, lst)
     SCM x;
     SCM lst;
#endif
{
	for(;NIMP(lst);lst = CDR(lst)) {
		ASSERT(CONSP(lst), lst, ARG2, s_member);
		if NFALSEP(scm_equal_p(CAR(lst), x)) return lst;
	}
	ASSERT(NULLP(lst), lst, ARG2, s_member);
	return BOOL_F;
}

PROC (s_assq, "assq", 2, 0, 0, scm_assq);
#ifdef __STDC__
SCM
scm_assq(SCM x, SCM alist)
#else
SCM
scm_assq(x, alist)
     SCM x;
     SCM alist;
#endif
{
	SCM tmp;
	for(;NIMP(alist);alist = CDR(alist)) {
		ASSERT(CONSP(alist), alist, ARG2, s_assq);
		tmp = CAR(alist);
		ASSERT(NIMP(tmp) && CONSP(tmp), alist, ARG2, s_assq);
		if (CAR(tmp)==x) return tmp;
	}
	ASSERT(NULLP(alist), alist, ARG2, s_assq);
	return BOOL_F;
}


PROC (s_assoc, "assoc", 2, 0, 0, scm_assoc);
#ifdef __STDC__
SCM
scm_assoc(SCM x, SCM alist)
#else
SCM
scm_assoc(x, alist)
     SCM x;
     SCM alist;
#endif
{
	SCM tmp;
	for(;NIMP(alist);alist = CDR(alist)) {
		ASSERT(CONSP(alist), alist, ARG2, s_assoc);
		tmp = CAR(alist);
		ASSERT(NIMP(tmp) && CONSP(tmp), alist, ARG2, s_assoc);
		if NFALSEP(scm_equal_p(CAR(tmp), x)) return tmp;
	}
	ASSERT(NULLP(alist), alist, ARG2, s_assoc);
	return BOOL_F;
}


PROC (s_delq_x, "delq!", 2, 0, 0, scm_delq_x);
#ifdef __STDC__
SCM
scm_delq_x (SCM item, SCM lst)
#else
SCM
scm_delq_x (item, lst)
     SCM item;
     SCM lst;
#endif
{
  SCM start;
  if (lst == EOL)
    return EOL;

  start = lst;
  ASSERT (CONSP (lst), lst, ARG2, s_delq_x);
  if (CAR (lst) == item)
    return CDR (lst);

  while (CDR(lst) != EOL)
    {
      ASSERT (CONSP (CDR(lst)), lst, ARG2, s_delq_x);
      if (CAR (CDR (lst)) == item)
	{
	  SETCDR (lst, CDR (CDR (lst)));
	  return start;
	}
      lst = CDR (lst);
    }
  return start;
}


PROC (s_last_pair, "last-pair", 1, 0, 0, scm_last_pair);
#ifdef __STDC__
SCM
scm_last_pair(SCM sx)
#else
SCM
scm_last_pair(sx)
     SCM sx;
#endif
{
  register SCM res = sx;
  register SCM x;
  ASSERT(NIMP(res) && CONSP(res), res, ARG1, s_last_pair);
  while (!0) {
    x = CDR(res);
    if (IMP(x) || NCONSP(x)) return res;
    res = x;
    x = CDR(res);
    if (IMP(x) || NCONSP(x)) return res;
    res = x;
    sx = CDR(sx);
    ASSERT(x != sx, sx, ARG1, s_last_pair);
  }
}

PROC (s_append_x, "append!", 0, 0, 1, scm_append_x);
#ifdef __STDC__
SCM
scm_append_x(SCM args)
#else
SCM
scm_append_x(args)
     SCM args;
#endif
{
  SCM arg;
 tail:
  if NULLP(args) return EOL;
  arg = CAR(args);
  ASSERT(NULLP(arg) || (NIMP(arg) && CONSP(arg)), arg, ARG1, s_append_x);
  args = CDR(args);
  if NULLP(args) return arg;
  if NULLP(arg) goto tail;
  CDR(scm_last_pair(arg)) = scm_append_x(args);
  return arg;
}


/* m.borza  12.2.91 */
PROC (s_memv, "memv", 2, 0, 0, scm_memv);
#ifdef __STDC__
SCM
scm_memv (SCM x, SCM lst)
#else
SCM
scm_memv (x, lst)
     SCM x;
     SCM lst;
#endif
{
  for(;NIMP(lst);lst = CDR(lst)) {
    ASRTGO(CONSP(lst), badlst);
    if NFALSEP(scm_eqv_p(CAR(lst), x)) return lst;
  }
# ifndef RECKLESS
  if (!(NULLP(lst)))
    badlst: scm_wta(lst, (char *)ARG2, s_memv);
# endif
  return BOOL_F;
}


/* m.borza  12.2.91 */
PROC (s_assv, "assv", 2, 0, 0, scm_assv);
#ifdef __STDC__
SCM
scm_assv(SCM x, SCM alist)
#else
SCM
scm_assv(x, alist)
     SCM x;
     SCM alist;
#endif
{
  SCM tmp;
  for(;NIMP(alist);alist = CDR(alist)) {
    ASRTGO(CONSP(alist), badlst);
    tmp = CAR(alist);
    ASRTGO(NIMP(tmp) && CONSP(tmp), badlst);
    if NFALSEP(scm_eqv_p(CAR(tmp), x)) return tmp;
  }
# ifndef RECKLESS
  if (!(NULLP(alist)))
    badlst: scm_wta(alist, (char *)ARG2, s_assv);
# endif
  return BOOL_F;
}


PROC (s_list_tail, "list-tail", 2, 0, 0, scm_list_tail);
#ifdef __STDC__
SCM
scm_list_tail(SCM lst, SCM k)
#else
SCM
scm_list_tail(lst, k)
     SCM lst;
     SCM k;
#endif
{
  register long i;
  ASSERT(INUMP(k), k, ARG2, s_list_tail);
  i = INUM(k);
  while (i-- > 0) {
    ASSERT(NIMP(lst) && CONSP(lst), lst, ARG1, s_list_tail);
    lst = CDR(lst);
  }
  return lst;
}

static scm_iproc cxrs[] = 
{
  {"car", 0},
  {"cdr", 0},
  {"caar", 0},
  {"cadr", 0},
  {"cdar", 0},
  {"cddr", 0},
  {"caaar", 0},
  {"caadr", 0},
  {"cadar", 0},
  {"caddr", 0},
  {"cdaar", 0},
  {"cdadr", 0},
  {"cddar", 0},
  {"cdddr", 0},
  {"caaaar", 0},
  {"caaadr", 0},
  {"caadar", 0},
  {"caaddr", 0},
  {"cadaar", 0},
  {"cadadr", 0},
  {"caddar", 0},
  {"cadddr", 0},
  {"cdaaar", 0},
  {"cdaadr", 0},
  {"cdadar", 0},
  {"cdaddr", 0},
  {"cddaar", 0},
  {"cddadr", 0},
  {"cdddar", 0},
  {"cddddr", 0},
  {0, 0}
};

#ifdef __STDC__
void
scm_init_pairs (void)
#else
void
scm_init_pairs ()
#endif
{
  scm_init_iprocs(cxrs, tc7_cxr);
#include "pairs.x"
}

