/* A crude brute force adaptation of the command line clnt.c program
   into a *very* elementry windows version (adapted from Petzold 
   "Programming Windows 3.1" */

#include <windows.h>

#include <stdio.h>
#include <winio.h>

#include <stdlib.h>
#include <string.h>

#include "resource.h"

#ifdef WIN16
#include "t1hdr.h"
#include "t2hdr.h"
#include "t3hdr.h" 
#else
#include "Test1.h"
#include "Test2.h"
#include "Test3.h" 
#endif

/* holds handle of our main window */
HWND g_h_hwnd;

char* g_pc_windowchars = NULL;

int dotest() /* used to basically be main() in clnt.c */
{
  Test1_O1	handle;
  Test1_O2	o2;
  Test1_O3	o3;
  float	f;
  ILU_C_ENVIRONMENT	s;
  Test1_U	u;
  Test1_CSS	css;
  Test1_ScS	scs[ 3 ];
  Test1_RO	ro;
  Test1_R	r;

  char c_line[512];
  RECT        rect ;
   
  /* blank our window chars */
  g_pc_windowchars[0] = '\0';

  Test1__Initialize( );
  Test3__Initialize( );
  if ((handle = ILU_C_LookupObject ("Test1-Server", "Test1_Initial_Object", Test1_O1__MSType)) == NULL) {
    MessageBox(g_h_hwnd, "ILU_C_LookupObject (\"Test1_Initial_Object@Test1-Server\" failed", 
	       "Error", MB_OK | MB_ICONEXCLAMATION);
    return (-1);
  }    
    
  u._d = Test1_U__boolean;
  u._u.boolean = 1;
  scs[0] = (Test1_ScS) "hello world";
  scs[1] = (Test1_ScS) "hello mars";
  css = Test1_CSS_Create( 2, scs );
  u = Test1_O1_U_CSS_to_U( handle, &u, &css, &s );
#ifdef WIN16        
  sprintf(c_line,  "u._d=%d, u._u.boolean = %lu, u._u.O1 = 0x%lx\n", u._d, u._u.boolean, (unsigned long) u._u.O1 );
#else
  sprintf(c_line,  "u._d=%d, u._u.boolean = %u, u._u.O1 = 0x%lx\n", u._d, u._u.boolean, (unsigned long) u._u.O1 );
#endif    
  strcat(g_pc_windowchars, c_line);
  ro = Test1_O1_f_CSS_to_RO( handle, &css, &s );
  sprintf(c_line,  "ro->i=%ld\n", ro->i );
  strcat(g_pc_windowchars, c_line);

  f = Test1_O1_R_ScS_to_F( handle, ro, scs[0], &s );
  sprintf(c_line,  "f=%f\n", f );
  strcat(g_pc_windowchars, c_line);

  Test1_O1_a_RO( handle, ro, &s );

  o2 = Test1_O1_get_O2 ( handle, &s );
  if (ILU_C_SUCCESSFUL(&s))
    {
      Test1_A0 a;
      ilu_byte *ap;
      Test1_A1 a1;
      Test1_I i;
      Test1_CSS css2;

      sprintf(c_line, "got O2, sbh = %s\n", ILU_C_SBHOfObject(o2));
      strcat(g_pc_windowchars, c_line);

      css2 = Test1_O2_OO_A0_to_CSS ( o2, handle, a, &s );
      if (ILU_C_SUCCESSFUL(&s))
	{
	}
      else
	{
	  sprintf(c_line, "exception on Test1_O2_OO_A0_to_CSS, exception is \"%s\"\n", s.returnCode);
	  strcat(g_pc_windowchars, c_line);
	}

      r.css._length = 0;
      r.css._buffer = NULL;
      r.css._maximum = 0;
      r.i = 12;
      r.a[0] = (Test1_ScS) "this is";
      r.a[1] = (Test1_ScS) "data";
      r.a[2] = (Test1_ScS) "initialization";
      a1[0] = (Test1_ScS) "but this";
      a1[1] = (Test1_ScS) "is";
      a1[2] = (Test1_ScS) "fun";
      ap = Test1_O2_R_I_A1_to_I_A0 (o2, &r, &i, a1, &s );
    }
  else
    {
      sprintf(c_line, "couldn't get an instance of O2.  Exception is \"%s\".\n", s.returnCode);
      strcat(g_pc_windowchars, c_line);
    }

  o3 = Test1_O1_get_O3 ( handle, ilu_FALSE, &s );
  if (ILU_C_SUCCESSFUL(&s))
    {
      Test1_RS rs = Test1_RS_Create (0, NULL);
      Test1_IS i2;

      sprintf(c_line, "got O3, sbh = %s, type = %s\n", ILU_C_SBHOfObject(o3), ILU_C_ClassName(o3));
      strcat(g_pc_windowchars, c_line);

      if (ILU_C_ClassRecordOfInstance(o3) != ILU_C_FindILUClassByTypeName("Test1.O3"))
	{
	  sprintf(c_line, "instance of class %s received!\n", ILU_C_ClassName(o3));
	  strcat(g_pc_windowchars, c_line);
	}
      else
	{
	  i2 = Test1_O3_RS_R_to_R_IS (o3, &rs, &r, &s);
	  Test1_O3_O1_U_to_U (o3, handle, &u, &s);
#ifdef WIN16	    
	  sprintf(c_line,  "u._d=%d, u._u.boolean = %lu, u._u.O1 = 0x%lx\n", u._d, u._u.boolean, (unsigned long) u._u.O1 );
#else
	  sprintf(c_line,  "u._d=%d, u._u.boolean = %u, u._u.O1 = 0x%lx\n", u._d, u._u.boolean, (unsigned long) u._u.O1 );
#endif	    
	  strcat(g_pc_windowchars, c_line);
	}
    }
  else
    {
      sprintf(c_line, "couldn't get an instance of O3.  Exception is \"%s\".\n", s.returnCode);
      strcat(g_pc_windowchars, c_line);
    }

  /* this next call should return an instance of Test3.O */
  o3 = Test1_O1_get_O3 ( handle, ilu_TRUE, &s);
  if (ILU_C_SUCCESSFUL(&s))
    {
      Test1_RS rs = Test1_RS_Create (0, NULL);
      Test1_IS i2;

      sprintf(c_line, "got O3, sbh = %s, type = %s\n", ILU_C_SBHOfObject(o3), ILU_C_ClassName(o3));
      strcat(g_pc_windowchars, c_line);

      i2 = Test1_O3_RS_R_to_R_IS (o3, &rs, &r, &s);
      Test1_O3_O1_U_to_U (o3, handle, &u, &s);
#ifdef WIN16	
      sprintf(c_line,  "u._d=%d, u._u.boolean = %lu, u._u.O1 = 0x%lx\n", u._d, u._u.boolean, (unsigned long) u._u.O1 );
#else
      sprintf(c_line,  "u._d=%d, u._u.boolean = %u, u._u.O1 = 0x%lx\n", u._d, u._u.boolean, (unsigned long) u._u.O1 );
#endif	
      strcat(g_pc_windowchars, c_line);

      if (ILU_C_ClassRecordOfInstance(o3) == ILU_C_FindILUClassByTypeName("Test3.O"))
	{
	  Test1_U u2;

	  u2 = Test3_O_I_to_Test1U (o3, 397, &s);
	  if (! ILU_C_SUCCESSFUL(&s))
	    {
	      sprintf(c_line, "exception on Test1_O2_OO_A0_to_CSS, exception is \"%s\"\n", s.returnCode);
	      strcat(g_pc_windowchars, c_line);
	    }
	  else
#ifdef WIN16	    
	    sprintf(c_line,  "Test3_O_I_to_Test1U:  u2._d=%d, u2._u.boolean = %lu, u2._u.O1 = 0x%lx\n",
		    u2._d, u2._u.boolean, (unsigned long) u2._u.O1 );
#else
	  sprintf(c_line,  "Test3_O_I_to_Test1U:  u2._d=%d, u2._u.boolean = %u, u2._u.O1 = 0x%lx\n",
		  u2._d, u2._u.boolean, (unsigned long) u2._u.O1 );
#endif		     
	  strcat(g_pc_windowchars, c_line);
	}
    }
  else
    {
      sprintf(c_line, "couldn't get an instance of O3.  Exception is \"%s\".\n", s.returnCode);
      strcat(g_pc_windowchars, c_line);
    }

  /* this next call should return an instance of Test1.O4 */
  o3 = Test1_O1_get_O3 ( handle, ilu_FALSE, &s );
  if (ILU_C_SUCCESSFUL(&s))
    {
      sprintf(c_line, "got O3, sbh = %s, type = %s\n", ILU_C_SBHOfObject(o3), ILU_C_ClassName(o3));
      strcat(g_pc_windowchars, c_line);

      if (ILU_C_ClassRecordOfInstance(o3) == ILU_C_FindILUClassByTypeName("Test1.O4"))
	{
	  ilu_real r1, r2;

	  r2 = Test1_O4_R_to_R (o3, r1 = 12345.6789, &s);
	  if (! ILU_C_SUCCESSFUL(&s))
	    {
	      sprintf(c_line, "exception on Test1_O2_OO_A0_to_CSS, exception is \"%s\"\n", s.returnCode);
	      strcat(g_pc_windowchars, c_line);
	    }
	  else
	    sprintf(c_line,  "doubles:  r1 is %.10f, r2 is %.10f\n", r1, r2);
          strcat(g_pc_windowchars, c_line);
	}
    }
  else
    {
      sprintf(c_line, "couldn't get an instance of O3.  Exception is \"%s\".\n", s.returnCode);
      strcat(g_pc_windowchars, c_line);
    }

  /* force an entire window repaint */
  GetClientRect (g_h_hwnd, &rect);
  InvalidateRect(g_h_hwnd, &rect, TRUE);
  SendMessage(g_h_hwnd, WM_PAINT, 0, 0);
  return(0);
}

long CALLBACK WndProc (HWND hwnd, UINT message, UINT wParam, LONG lParam)
     {
     HDC         hdc ;
     PAINTSTRUCT ps ;
     RECT        rect ;
     static int i_doingtest = 0;
     
     switch (message)
          {
          case WM_PAINT :
               hdc = BeginPaint (hwnd, &ps) ;
               GetClientRect (hwnd, &rect) ;
               DrawText (hdc, g_pc_windowchars, -1, &rect, DT_LEFT) ;
               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY :
               PostQuitMessage (0) ;
               return 0 ;

		  case WM_COMMAND :
		  	switch (LOWORD(wParam)) {
				case ID_ACTION_RUN	:
					/* on win16, something processes messages for us while we're blocked in 
					a select(), which means we can enter here even though we're already in 
					the middle of a test, so prevent re entering. */
					if (i_doingtest == 0) {
						i_doingtest = 1;
						if (dotest() != 0) 
							MessageBox(hwnd, "dotest unsuccessful", "Error", MB_OK | MB_ICONEXCLAMATION);
						i_doingtest = 0;
					}
					break;
				case ID_ACTION_EXIT :
					PostQuitMessage (0) ;
					break;

			}
          }

     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }


int CALLBACK WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdParam, int nCmdShow)
     {                     
     static char szAppName[] = "iluTest1WindowsClient" ;
     HWND        hwnd ;
     MSG         msg ;
     WNDCLASS    wndclass ; 

     if (!hPrevInstance)
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = LoadIcon (hInstance, "clntw_icon") ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = MAKEINTRESOURCE(IDR_MENU1) ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }                                

     hwnd = CreateWindow (szAppName,       // window class name
                    "iluTest1WindowsClient",   // window caption
                    WS_OVERLAPPEDWINDOW,   // window style
                    CW_USEDEFAULT,         // initial x position
                    CW_USEDEFAULT,         // initial y position
                    CW_USEDEFAULT,         // initial x size
                    CW_USEDEFAULT,         // initial y size
                    NULL,                  // parent window handle
                    NULL,                  // window menu handle
                    hInstance,             // program instance handle
                    NULL) ;                // creation parameters

	 /* save our window handle in the global */
	 g_h_hwnd = hwnd;
     
     g_pc_windowchars = (char*) malloc(8192);
     if (g_pc_windowchars == NULL) {
     	MessageBox(NULL, "Couldn't malloc(8192) for g_pc_windowchars", "Error", 
     				MB_ICONSTOP | MB_OK);
     	return msg.wParam;
     }
     g_pc_windowchars[0] = '\0';

#ifdef WIN16     
     /* initialize winsock when under WIN16 */
     ilu_StartupWinsock ();
#endif
     
	 /* create our console for stdio output (e.g. from the ilu runtime) */
	 winio_console(hInstance, hPrevInstance,
            nCmdShow, 0, "clientw Console");

     ShowWindow (hwnd, nCmdShow) ;
     UpdateWindow (hwnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
         
     return msg.wParam ;
     }

