/**
 *
 * $Id: Protocols.c,v 1.15 1996/04/22 22:55:24 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: Protocols.c,v 1.15 1996/04/22 22:55:24 miers Exp $";

#include <LTconfig.h>
#include <Xm/ProtocolsP.h>
#include <Xm/DebugUtil.h>
#include <Xm/VendorSEP.h>

static void class_initialize();
static void class_part_initialize(WidgetClass class);
static void initialize(Widget request, Widget new, ArgList args, Cardinal *num_args);
static void destroy(Widget w);
static Boolean set_values(Widget current, Widget request, Widget new, ArgList args, Cardinal *num_args);

/*
 * resources 
 */
#define Offset(field) XtOffsetOf(XmProtocolRec, protocol.field)
static XtResource resources[] = {
    {
	XmNextensionType, XmCExtensionType, XmRExtensionType,
	sizeof(unsigned char), XtOffsetOf(XmProtocolRec, ext.extensionType),
	XmRImmediate, (XtPointer)XmPROTOCOL_EXTENSION
    },
    {
        XmNprotocolCallback, XmCProtocolCallback, XmRCallback,
        sizeof(XtCallbackList), Offset(callbacks),
        XmRImmediate, (XtPointer)NULL
    }
};

XmProtocolClassRec xmProtocolClassRec = {
    /* Object class part */
    {
	/* superclass            */ (WidgetClass) &xmExtClassRec,
        /* class_name            */ "XmProtocolClass",
	/* widget_size           */ sizeof(XmProtocolRec),
	/* class_initialize      */ class_initialize,
	/* class_part_initialize */ class_part_initialize,
	/* class_inited          */ FALSE,
	/* initialize            */ initialize,
	/* initialize_hook       */ NULL,
	/* realize               */ NULL,
	/* actions               */ NULL,
	/* num_actions           */ 0,
	/* resources             */ resources,
	/* num_resources         */ XtNumber(resources),
	/* xrm_class             */ NULLQUARK,
	/* compress_motion       */ 0,
	/* compress_exposure     */ 0,
	/* compress_enterleave   */ 0,
	/* visible_interest      */ 0,
	/* destroy               */ destroy,
	/* resize                */ NULL,
	/* expose                */ NULL,
	/* set_values            */ set_values,
	/* set_values_hook       */ NULL,
	/* set_values_almost     */ NULL,
	/* get_values_hook       */ _XmExtGetValuesHook,
	/* accept_focus          */ NULL,
	/* version               */ XtVersion,
	/* callback offsets      */ NULL,
	/* tm_table              */ NULL,
	/* query_geometry        */ NULL,
        /* display_accelerator   */ NULL,
	/* extension             */ NULL
    },
    /* XmExtObject part */
    {
        /* syn_resources      */ NULL,
        /* num_syn_resources  */ 0,
        /* extension          */ NULL
    },
    /* Protocol Class part */
    {
        /* extension             */ NULL
    }
};

WidgetClass xmProtocolClass = (WidgetClass)&xmProtocolClassRec;

static void
class_initialize()
{
    XdbDebug(__FILE__, NULL, "Protocol ClassInitialize\n");
}

static void
class_part_initialize(WidgetClass widget_class)
{
    XdbDebug(__FILE__, NULL, "Protocol ClassPartInitialize\n");
}

static void
initialize(Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XdbDebug(__FILE__, new, "Protocol Initialize\n");
}

static void
destroy(Widget w)
{
    XdbDebug(__FILE__, w, "Protocol Destroy\n");
}

static Boolean
set_values(Widget current,
	   Widget request,
	   Widget new,
	   ArgList args,
	   Cardinal *num_args)
{
    XdbDebug(__FILE__, new, "Protocol SetValues\n");

    return True; /* FIX ME */
}

void
_XmInstallProtocols(Widget w)
{
}

#ifndef PROTOCOL_IS_OBJECT

static void
_XmProtocolsDebug(Widget w, char *func, Atom a, Atom *p, int count)
{
    Display *dpy = XtDisplay(w);

    if (XdbInDebug(__FILE__, w)) {
	char	*s;
	int	i;

	s = XGetAtomName(dpy, a);
	XdbDebug(__FILE__, w, "%s(%s, [", func, s);
	XFree(s);
	for (i=0; i<count; i++) {
	    s = XGetAtomName(dpy, p[i]);
	    XdbDebug0(__FILE__, w, "%s", s);
	    XFree(s);
	    if (i < count-1)
		XdbDebug0(__FILE__, w, ", ");
	}
	XdbDebug0(__FILE__, w, "])\n");
    }
}

static void
XmProtocolHandler(Widget w, XEvent *evp, String *params, Cardinal *nparams)
{
    Atom property, protocol;
    int	i;
    XmVendorShellExtObject v;

    if (evp->type != ClientMessage) {
	XdbDebug(__FILE__, w, "XmProtocolHandler(not a client message)\n");
	return;
    }

    property = evp->xclient.message_type;
    protocol = evp->xclient.data.l[0];

    if (XdbInDebug(__FILE__, w)) {
	char *a, *b;

	a = XGetAtomName(XtDisplay(w), property);
	b = XGetAtomName(XtDisplay(w), protocol);
	XdbDebug(__FILE__, w, "XmProtocolHandler(%s,%s)\n", a, b);
	XFree(a);
	XFree(b);
    }

    /* Find Shell Widget */
    if ((v = (XmVendorShellExtObject)_LtFindVendorExt(w)) == 0)
	return;
    if (v->vendor.protocols == NULL)
	return;
    /* Find the right combination */
    for (i=0; v->vendor.protocols[i].protocol != 0; i++) {
	if (v->vendor.protocols[i].protocol == protocol
	    && v->vendor.protocols[i].property == property) {
	    int j;

	    XdbDebug(__FILE__, w, "Found %d callbacks\n",
		     v->vendor.protocols[i].num_callbacks);
	    for (j=0; j<v->vendor.protocols[i].num_callbacks; j++) {
		    (*v->vendor.protocols[i].cbl[j].callback)(w,
				v->vendor.protocols[i].cbl[j].closure, NULL);
	    }
#if 0
	    for (j=0; j<v->vendor.protocols[i].num_callbacks; j++)
		    (*v->vendor.protocols[i].cbl[j].callback)(w, evp, params, nparams);
#endif
	}
    }
}

static XtActionsRec	actions[] = {
    { "XmProtocolHandler", XmProtocolHandler },
};

void
XmActivateProtocol(Widget shell,
		   Atom property,
		   Atom protocol)
{
    char		*tbl, *a;
    XtTranslations	ctbl;

    _XmProtocolsDebug(shell, "XmActivateProtocol", property, &protocol, 1);

    XtAppAddActions(XtWidgetToApplicationContext(shell), actions, XtNumber(actions));

    a = XGetAtomName(XtDisplay(shell), property);

    tbl = (char *)XtMalloc(32 + strlen(a));

    strcpy(tbl, "<Message>");		/* len 9 */
    strcat(tbl, a);
    XFree(a);
    strcat(tbl, ": XmProtocolHandler()\n");	/* len 21 */

    ctbl = XtParseTranslationTable(tbl);
    XtFree(tbl);
    XtAugmentTranslations(shell, ctbl);

    if (property == XmInternAtom(XtDisplay(shell), "WM_PROTOCOLS", False)) {
	if (XtIsRealized(shell))
	    XSetWMProtocols(XtDisplay(shell), XtWindow(shell), &protocol, 1);
	else
	    XdbDebug(__FILE__, shell, "XmActivateProtocol: shell widget is not realized yet\n");
    }
}

#ifdef	XmActivateWMProtocol
#undef	XmActivateWMProtocol
#endif
void
XmActivateWMProtocol(Widget shell,
		     Atom protocol)
{
    XmActivateProtocol(shell,
		       XM_WM_PROTOCOL_ATOM(shell),
		       protocol);
}

static void
_XmAddCallback(_XmVendorProtocols *vp, XtCallbackProc cb, XtPointer closure)
{
	int	n;

	if (vp == NULL) {
		n = 2;
		vp->cbl = (XtCallbackList)XtCalloc(sizeof(XtCallbackRec), n);
	} else {
		n = vp->num_callbacks + 2;
		vp->cbl = (XtCallbackList)XtRealloc((XtPointer)vp->cbl,
			sizeof(XtCallbackRec) * n);
	}
	vp->num_callbacks = --n;

	vp->cbl[n-1].callback = cb;
	vp->cbl[n-1].closure = closure;
	vp->cbl[n].callback = NULL;
	vp->cbl[n].closure = NULL;
}

void
XmAddProtocolCallback(Widget shell,
		      Atom property,
		      Atom protocol,
		      XtCallbackProc callback,
		      XtPointer closure)
{
	XmVendorShellExtObject	ve;
	int			np, tp;

	if (XdbInDebug(__FILE__, shell)) {
		char	*a = XGetAtomName(XtDisplay(shell), property),
			*b = XGetAtomName(XtDisplay(shell), protocol);

		XdbDebug(__FILE__, shell, "XmAddProtocolCallback(%s, %s)\n", a, b);
		XFree(a);
		XFree(b);
	}

        ve = (XmVendorShellExtObject)_LtFindVendorExt(shell);
	if (ve == NULL) {
		XdbDebug(__FILE__, NULL, "Problem %s %d\n", __FILE__, __LINE__);
		return;
	}
/* Cannot print debugging info in this case : XdbDebug relies on this same pointer */

/* Find current number of protocols */
	tp = -1; np = 0;
	if (ve->vendor.protocols)
		for (np=0; ve->vendor.protocols[np].protocol != 0; np++)
			if (ve->vendor.protocols[np].protocol == protocol
			 && ve->vendor.protocols[np].property == property) {
				tp = np;
			}
	if (tp < 0) {
		XmAddProtocols(shell, property, &protocol, 1);
		tp = np;
	}

/* Add Callback */
	_XmAddCallback(&ve->vendor.protocols[tp], callback, closure);
}

void
XmAddProtocols(Widget shell,
	       Atom property,
	       Atom *protocol,
	       Cardinal num_protocols)
{
	XmVendorShellExtObject	ve;
	int			np, i, j;

/* Debugging info */
	_XmProtocolsDebug(shell, "XmAddProtocols", property, protocol, num_protocols);

        ve = (XmVendorShellExtObject)_LtFindVendorExt(shell);
	if (ve == NULL) {
		XdbDebug(__FILE__, NULL, "Problem %s %d\n", __FILE__, __LINE__);
		return;
	}
/* Cannot print debugging info in this case : XdbDebug relies on this same pointer */

/* Find current number of protocols, and allocate space */
	np = 0;
	if (ve->vendor.protocols) {
		for (np=0; ve->vendor.protocols[np].protocol != 0; np++) ;

		ve->vendor.protocols = (_XmVendorProtocols *)XtRealloc(
				(XtPointer)ve->vendor.protocols,
				sizeof(_XmVendorProtocols) * (np + 1 + num_protocols));
	} else
		ve->vendor.protocols = (_XmVendorProtocols *)XtMalloc(sizeof(_XmVendorProtocols) *
			(num_protocols + 1));

/* Add them */
	for (i=0; i<num_protocols; i++) {
		Boolean	found = False;

		for (j=0; j<np; j++)
		    if (property == ve->vendor.protocols[j].property
		     && protocol[i] == ve->vendor.protocols[j].protocol) {
			found = True;
			break;
		    }
		if (found)
			continue;
		ve->vendor.protocols[np].property = property;
		ve->vendor.protocols[np].protocol = protocol[i];
		ve->vendor.protocols[np].cbl = NULL;
		ve->vendor.protocols[np].num_callbacks = 0;
		ve->vendor.protocols[np].active = False;
		np++;
		ve->vendor.protocols[np].property = 0;
		ve->vendor.protocols[np].protocol = 0;
		ve->vendor.protocols[np].cbl = NULL;
		ve->vendor.protocols[np].num_callbacks = 0;
		ve->vendor.protocols[np].active = False;
	}

/* Automatically Activate */
	for (i=0; i<num_protocols; i++)
		XmActivateProtocol(shell, property, protocol[i]);
}

#ifdef	XmAddWMProtocols
#undef	XmAddWMProtocols
#endif

void
XmAddWMProtocols(Widget shell,
		 Atom *protocols,
		 Cardinal num_protocols)
{
    XmAddProtocols(shell,
		   XM_WM_PROTOCOL_ATOM(shell),
		   protocols,
		   num_protocols);
}

#ifdef	XmAddWMProtocolCallback
#undef	XmAddWMProtocolCallback
#endif

void 
XmAddWMProtocolCallback(Widget shell,
			Atom protocol,
			XtCallbackProc callback,
			XtPointer closure)
{
    XmAddProtocolCallback(shell, 
			  XM_WM_PROTOCOL_ATOM(shell),
			  protocol,
			  callback,
			  closure);
}

void
XmRemoveProtocolCallback(Widget shell,
			 Atom property,
			 Atom protocol,
			 XtCallbackProc callback,
			 XtPointer closure)
{
}

void
XmRemoveProtocols(Widget shell,
		  Atom property,
		  Atom *protocols,
		  Cardinal num_protocols)
{
	XdbDebug(__FILE__, shell, "XmRemoveProtocols is not implemented\n");
}

#ifdef	XmRemoveWMProtocolCallback
#undef	XmRemoveWMProtocolCallback
#endif

void
XmRemoveWMProtocolCallback(Widget shell,
			   Atom protocol,
			   XtCallbackProc callback,
			   XtPointer closure)
{
    XmRemoveProtocolCallback(shell,
			     XM_WM_PROTOCOL_ATOM(shell),
			     protocol,
			     callback,
			     closure);
}

#ifdef	XmRemoveWMProtocols
#undef	XmRemoveWMProtocols
#endif

void
XmRemoveWMProtocols(Widget shell,
		    Atom *protocols,
		    Cardinal num_protocols)
{
    XmRemoveProtocols(shell,
		      XM_WM_PROTOCOL_ATOM(shell),
		      protocols,
		      num_protocols);
}

void
XmSetProtocolHooks(Widget shell,
	Atom		property,
	Atom		protocol,
	XtCallbackProc	prehook,
	XtPointer	pre_closure,
	XtCallbackProc	posthook,
	XtPointer	post_closure)
{
	XdbDebug(__FILE__, shell, "XmSetProtocolHooks is not implemented\n");
}

#ifdef	XmSetWMProtocolHooks
#undef	XmSetWMProtocolHooks
#endif
void
XmSetWMProtocolHooks(Widget shell,
	Atom	protocol,
	XtCallbackProc	prehook,
	XtPointer	pre_closure,
	XtCallbackProc	posthook,
	XtPointer	post_closure)
{
	XmSetProtocolHooks(shell, XM_WM_PROTOCOL_ATOM(shell), protocol,
		prehook, pre_closure, posthook, post_closure);
}

#endif	/* PROTOCOL_IS_OBJECT */
