/* sync.c   the Netwide Disassembler synchronisation processing module
 *
 * The Netwide Assembler is copyright (C) 1996 Simon Tatham and
 * Julian Hall. All rights reserved. The software is
 * redistributable under the licence given in the file "Licence"
 * distributed in the NASM archive.
 */

#include <stdio.h>
#include <limits.h>

#include "sync.h"

#define SYNC_MAX 8192		       /* max # of sync points */

static unsigned long synx[SYNC_MAX];
static int nsynx;

void init_sync(void) {
    nsynx = 0;
}

void add_sync(unsigned long position) {
    int i;

    if (nsynx == SYNC_MAX)
	return;			       /* can't do anything - overflow */

    synx[++nsynx] = position;

    for (i = nsynx; i > 1; i /= 2) {
	if (synx[i/2] > synx[i]) {
	    long t = synx[i/2];
	    synx[i/2] = synx[i];
	    synx[i] = t;
	}
    }
}

unsigned long next_sync(unsigned long position) {
    while (nsynx > 0 && synx[1] <= position) {
	int i, j, t = synx[nsynx];
	synx[nsynx] = synx[1];
	synx[1] = t;

	nsynx--;

        i = 1;
	while (i*2 <= nsynx) {
	    j = i*2;
	    if (synx[j] < synx[i] && (j+1 > nsynx || synx[j+1] > synx[j])) {
		t = synx[j];
		synx[j] = synx[i];
		synx[i] = t;
		i = j;
	    } else if (j+1 <= nsynx && synx[j+1] < synx[i]) {
		t = synx[j+1];
		synx[j+1] = synx[i];
		synx[i] = t;
		i = j+1;
	    } else
		break;
	}
    }

    if (nsynx > 0)
	return synx[1];
    else
	return ULONG_MAX;
}
