#ifndef SAM_CODE
void	error(char *, ...);
#endif
void fatal(char*,...);

/* builtins.c */
Bool	builtin			(View *, char *, char*);

/* click.c */
Range	text_doubleclick	(Text *, ulong);
Range	text_expand		(Text *, Range, char *);
Bool		text_findline		(Text *, Range *, ulong);
Range	text_lastline		(Text *);
ulong	text_nl			(Text *, ulong pos, int delta);
ulong	text_startofword	(Text *, ulong);

/* col.c */
void		col_del		(Tile*);

/* dir.c */
char **	dirnames 		();
void		dirnames_free(char**names);

/* data.c */
Text*	data_body	(Data*);
Text*	data_tag		(Data*);
char**	data_names	(Data*d);
Bool		data_isdirty	(Data *d);
void		data_path	(Data*d, char*s);
void		data_context	(Data*d, char*s);
int		data_putall	(void);
int		data_backupall (void);
int		data_put		(Data *d, char *path);
View *	data_find		(char *);
int		data_del		(Data*);
void		data_setlabel	(Data*d, char *);
int		data_backup	(Data *d);

/* env.c */
void		env_init		(char **);
void		pathcontract	(char*dest, char *orig);

/* event.c */
void		dofd				(ulong, Event *);

/* exec.c */
void		reap				(void);
int		ex_run			(View*v, char *cmd);
void		ex_kill			(View *v, char *s);

/* external.c */
void		ex_init			(void);

/* file.c */
View *	data_open	(char*, Bool create);
int		data_get		(Data *d, char *path);

/* key.c */

/* keyboard.c */
void		dokeyboard		(View *, Rune);
void		view_pagedown	(View *, Bool );
void		view_linesdown	(View *v, int n, Bool down);

/* mouse.c */
void		domouse			(View*, Mouse*);
void		run				(View *, char *, char *);
Range	mouse_expand	(Range r, View *v, char *s);

/* msg.c */
void		msg_process		(Msg*, int );
Bool		data_sendreplace	(Data *,Range r, Rstring );
Bool		data_sendgoto		(Data *,Range r, char *);
Bool		data_sendexec		(Data *,char*, char *);
void		data_fdstop		(int );

/* path.c */
Bool		language_specific_expand(View **v, Range *r);
void		envexpand		(char*dest, char*orig);

/* place.c */
Tile*		findcol(char*path);
void		placedcol(char*, Tile*);

/* point.c */
Point	buttonpos(Tile*tile);

/* sam.c */
Bool		text_regexp	(Text *, Rstring , Range*, Bool );
Bool		text_utfregexp(Text *, char*, Range*, Bool );

/* sambuf.c */
int 		Tbgetcload		(Text *t, ulong p);
long		Tchars			(Text *, Rune *, ulong, ulong);
int		Tgetcload			(Text *t, ulong);
int		Tgetcset			(Text *t, ulong);
int		Tbgetcset			(Text *t, ulong);

/* scroll.c */
void		scroll_update	(Scroll *);
void		scroll_init	(void);
Scroll *	scroll_alloc	(Bitmap *, Rectangle);
void		scroll_setrects	(Scroll*, Bitmap *, Rectangle);
void		scroll_set		(Scroll *, ulong , ulong , ulong );

/* select.c */
Range		vselect		(View *, Mouse *);

/* tag.c */
void		tag_set(Text*t, char*s);
void		tag_rmtool(Text *, char *);
void		tag_addtool(Text *, char *);
void		tag_modified(Text *, ulong);
void		tag_reset(Text *);
void		tag_setlabel(Text *, char *);

/* tagmatch.c */
void		tag_init(char *filename);
char*	tag_match(char*label);

/* text.c */
int		text_read			(Text *, int fd, int len);
int		text_write_range	(Text*, Range, int);
void		text_copy		(Text *, Range, Rune *);
Text*	text_alloc			(Data *, Bool);
Range	text_replace		(Text *, Range, Rstring);
void		text_free			(Text *);
int		text_linenumber	(Text *t, ulong );

/* text2.c */
Range	text_all			(Text*t);
Data*	text_data			(Text*);
View*	text_view		(Text*t);
ulong	text_length		(Text*);
View*	text_body 		(Text*);
int		text_write		(Text *, char *fname);
Bool		text_look			(Text*t, Range *r, Range dot);
Bool		text_search	(Text *, Range *, char *, Range);
Bool		text_needsbackup	(Text*);
int		text_fd			(Text*, Range);
Rstring	text_autoindent	(Text *t, ulong p);
void		text_addview		(Text*, View*);
int		text_rmview		(Text*, View*);
void		text_setneedsbackup(Text*t, Bool b);
Bool		text_badrange		(Text *t, Range r);
void		text_fillbutton(Text*t, Fcode f);
ulong	text_ncopy		(Text *, Rune*, ulong , ulong );
Rstring 	utf2rstring		(char*utf);
Bool		text_findliteral	(Text *, Range*, Rstring);
Bool		text_findword		(Text *, Range*, Rstring);
Range	text_replaceutf	(Text*, Range, char*);
Bool		text_findliteralutf	(Text*, Range*, char*);
Bool		text_findwordutf	(Text*t, Range*, char*);
char*	text_duputf		(Text*, Range);
int		text_copyutf		(Text *, Range, char *);
Bool		text_refreshdir	(Text*t);
void		text_formatdir		(Text *t, char**);

/* tile.c */
Bool		tile_hidden		(Tile*tile);
Bool		tile_isdirty		(Tile*tile);
void		col_new			(View*v, char *arg);
void		ereshaped		(Rectangle);
View*	tile_body			(Tile*);
Tile*		tile_col			(Tile*);
void		tile_del			(Tile *);
void		tile_grow			(Tile *, int );
void		tile_move		(Tile *, Point);
void		tile_setfont		(Tile*, char*);
void		tile_show		(Tile *);
View*	tile_tag			(Tile*);
void		wily_init			(int ncolumns);

/* undo.c */
void		undo_record	(Text *, Range, Rstring);
Range	undo_undo	(Text*);
Range	undo_redo	(Text*);
void		undo_free	(Text*);
void		undo_reset	(Text*);
void		undo_start	(Text*);
void		undo_break	(Text*);
void		undo_mark	(Text*);
Bool		undo_atmark	(Text*);
Range	undo_undoall	(Text*);
Range	undo_redoall	(Text*);

/* util.c */
int		add_height	(Text *t, ulong, Font *, int, int);
Bool		isdir			(char*path);
int		backup_name	(char *orig, char *back);
char *	columnate	(int, int, Font *, char **);
void		noutput		(char *context, char *base, int n);
void		add_slash		(char*);
int		distance		(Point , Point );
Bool		frame_isfull	(Frame*);
void		frgetmouse	(void);
char*	mybasename	(char*f);
Range	paste		(Text *, Range);
void		pathexpand	(char *, View *, char *);
Rstring	rstring		(Rune*r0, Rune*r1);
char*	select_get	(void);
void		select_put	(char*);
void		snarf		(Text *, Range);
int		stripnulls		(char *buf, int len);
ulong	texttoutf		(char *, Rune *, Rune *);
ulong	utftotext		(Rune *, char *, char *);
int 		diag			(char*,char*, ...);
void		cleanup_and_abort	(int);
void		cleanup_and_die	(int);

/* vsearch.c */
void		b3(View *v, Range r);
void		view_look(View*, char*);
Bool		view_goto(View**vp, Range *r, char *s);

/* vgeom.c */
void		view_fillbutton(View*v, Fcode f);
void 	fill(View*);
int		snapheight(View*v, int h);
void		view_reshaped(View*, Rectangle);
int		view_lastlinepos(View*v);
int		view_stripwhitespace(View*v);

/* vshow.c */
void		view_show(View*, Range);
void		view_scroll	(View *, Mouse *);
void		view_hscroll(View*v, Bool left);

/* view.c */
View*	view_new(Font *, Bool, Text *, Tile *);
int		view_delete(View *v);
Bool		view_invariants(View*v);

Data*	view_data(View*);
View*	view_body(View*);
Tile*		view_win(View*);
Tile*		view_tile(View*);
Text*	view_text(View*);
Range	view_getsel(View*v);
int		view_height(View*v);

void		view_cut(View*v, Range r);
void		view_append(View *, Bool *, char *, int);
void		view_setfont(View *v, char*arg);
void		view_setlastselection(View *v);
void		view_select(View*v, Range);
void		view_warp (View *v, Range);
void		viewlist_refresh(View*);
void		viewlist_replace(View*v, Range r, Rstring s);

/* wily.c */
void		addrunning(char *cmd);
void		rmrunning(char *cmd);

/* win.c */
int		win_del			(Tile *w);
Tile*		tile_win			(Tile*);
void 	win_clone		(Tile*);
void		win_new			(char*, Text*tag, Text*body);
void		win_anchor		(Tile*w, char *arg);

#define RECTOK(r) (Dx(r)>=0 && Dy(r) >= 0)
#define cls(r) bitblt(&screen, (r).min, &screen, (r), Zero)
#define SETSIZE(buf, n, desired) {if(n<desired){ n=(desired)*1.5; buf = srealloc(buf, n);}}
#define STRSAME !strcmp
