#include "wily.h"
#include "text.h"

/****************************************************
	Wrappers to make a Text look like a Sam buffer
****************************************************/
#define TEXT_ISTAG(t) (	!(t)->isbody	)
#define TEXT_ISWINTAG(t) ((t)->v && (t)->v->win && TEXT_ISTAG(t))

#define	Tgetc(t)  ( ((t)->pos<(t)->gap.p0) ? ((t)->text[(t)->pos++] ) : (((t)->pos < (t)->length) ? (t)->text[(t)->pos++ + RLEN((t)->gap)] : -1))

#define Tbgetc(t) ( ((t)->pos > (t)->gap.p0) ? ((t)->text[--(t)->pos + RLEN((t)->gap)]) : ( (t)->pos ? (t)->text[--(t)->pos] ? -1) )

#define Tbgetcset(t,p) ( (t)->pos = (p))
#define Tgetcset(t,p) ((t)->pos = (p))

long
Tchars(Text *t, Rune *buf, ulong p0, ulong p1)
{
	Range	r;
	
	r = range( p0, MIN(p1, t->length));
	text_copy(t, r, buf);
	return RLEN(r);
}
