/* Wharf.c. by Bo Yang. 
 * Modifications: Copyright 1995 by Bo Yang.
 *
 * modifications made by Frank Fejes for AfterStep 
 * Copyright 1996
 *
 * based on GoodStuff.c by Robert Nation 
 * The GoodStuff module, and the entire GoodStuff program, and the concept for
 * interfacing that module to the Window Manager, are all original work
 * by Robert Nation
 *
 * Copyright 1993, Robert Nation. 
 * No guarantees or warantees or anything
 * are provided or implied in any way whatsoever. Use this program at your
 * own risk. Permission to use this program for any purpose is given,
 * as long as the copyright is kept intact.  */

#define TRUE 1
#define FALSE 
#define DOUBLECLICKTIME 1

#include "../../configure.h"

#ifdef ISC
#include <sys/bsdtypes.h> /* Saul */
#endif

#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/time.h>
#if defined ___AIX || defined _AIX || defined __QNX__ || defined ___AIXV3 || defined AIXV3 || defined _SEQUENT_
#include <sys/select.h>
#endif
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include "../../src/module.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>

#include "Wharf.h"
#include "../../version.h"
#define AFTER_ICONS 1
#include "../../src/afterstep.h"

char *MyName;

Display *dpy;
int x_fd,fd_width;

Window Root;
int screen;
long d_depth;

Bool Pushed = 0;
Bool Pushable = 1;
Pixel back_pix, fore_pix, light_grey;
GC  NormalGC, HiReliefGC, HiInnerGC;
Window main_win;
int Width, Height,win_x,win_y;

#define MW_EVENTS   (ExposureMask | ButtonReleaseMask |\
		     ButtonPressMask)

int num_buttons = 0;
int num_rows = 0;
int num_columns = 0;
int max_icon_width = 30,max_icon_height = 0;
int ButtonWidth,ButtonHeight;
int x= -100000,y= -100000,w= -1,h= -1,gravity = NorthWestGravity;
int new_desk = 0;
int pageing_enabled = 1;
int ready = 0;

int CurrentButton = -1;
int fd[2];

struct button_info Buttons[BUTTON_ARRAY_LN];
char *iconPath = NULL;
char *pixmapPath = NULL;

static Atom wm_del_win;
Atom _XA_WM_PROTOCOLS;
Atom _XA_WM_NAME;

/***********************************************************************
 *
 *  Procedure:
 *	main - start of afterstep
 *
 ***********************************************************************
 */
void main(int argc, char **argv)
{
  char *display_name = NULL;
  int i,j;
  Window root;
  int x,y,border_width,button;
  long depth;
  char *temp, *s;
  char set_mask_mesg[50];
  temp = argv[0];

  s=strrchr(argv[0], '/');
  if (s != NULL)
    temp = s + 1;


  MyName = safemalloc(strlen(temp)+1);
  strcpy(MyName, temp);

  for(i=0;i<BUTTON_ARRAY_LN;i++)
    {
      Buttons[i].title = NULL;
      Buttons[i].action = NULL;
      Buttons[i].icon_file = NULL;
      Buttons[i].icon_w = 0;
      Buttons[i].icon_h = 0;
      Buttons[i].IconWin = None;
      Buttons[i].icon_maskPixmap = None;	/* pixmap for the icon mask */
      Buttons[i].iconPixmap = None;
      Buttons[i].icon_depth = 0;
      Buttons[i].up = 1;                        /* Buttons start up */
      Buttons[i].hangon = NULL;                 /* don't wait on anything yet*/
    }
  signal (SIGPIPE, DeadPipe);  
  
  if((argc != 6)&&(argc != 7))
    {
      fprintf(stderr,"%s Version %s should only be executed by AfterStep!\n",
		MyName, VERSION);
      exit(1);
    }

  fd[0] = atoi(argv[1]);
  fd[1] = atoi(argv[2]);
  
  if (!(dpy = XOpenDisplay(display_name))) 
    {
      fprintf(stderr,"%s: can't open display %s", MyName,
	      XDisplayName(display_name));
      exit (1);
    }
  x_fd = XConnectionNumber(dpy);

  fd_width = GetFdWidth();

  screen= DefaultScreen(dpy);
  Root = RootWindow(dpy, screen);
  if(Root == None) 
    {
      fprintf(stderr,"%s: Screen %d is not valid ", MyName, screen);
      exit(1);
    }
  d_depth = DefaultDepth(dpy, screen);

  sprintf(set_mask_mesg,"SET_MASK %lu\n",
	  (unsigned long)(M_TOGGLE_PAGING| 
			  M_NEW_DESK |
			  M_END_WINDOWLIST| 
			  M_MAP|
			  M_RES_NAME|
			  M_RES_CLASS|
			  M_WINDOW_NAME));

  SendText(fd,set_mask_mesg,0);


  ParseOptions(argv[3]);
  if(num_buttons == 0)
    {
      fprintf(stderr,"%s: No Buttons defined. Quitting\n", MyName);
      exit(0);
    }

  GetXPMData( BACK_BUTTON, button_xpm);
  for(i=0;i<num_buttons;i++)
    {
      LoadIconFile(i);
    }

  CreateWindow();
  for(i=0;i<num_buttons;i++)
    {
      CreateIconWindow(i);
    }
  
  XGetGeometry(dpy,main_win,&root,&x,&y,
	       (unsigned int *)&Width,(unsigned int *)&Height,
	       (unsigned int *)&border_width,(unsigned long *)&depth);

  for(i=0;i<num_rows;i++)
    for(j=0;j<num_columns; j++)
      {
	button = i*num_columns + j;
	ConfigureIconWindow(button,i,j);
      }
  XMapSubwindows(dpy,main_win);
  XMapWindow(dpy,main_win);

  /* request a window list, since this triggers a response which
   * will tell us the current desktop and paging status, needed to
   * indent buttons correctly */
  SendText(fd,"Send_WindowList",0);

  Loop();

}

/***********************************************************************
 *
 *  Procedure:
 *	Loop - wait for data to process
 *
 ***********************************************************************/
void Loop(void)
{
  Window root;
  int x,y,w,h,xoff,yoff,border_width,CurrentRow,CurrentColumn;
  long depth;
  XEvent Event;
  int NewButton,i,j,button,tw,th,i2, bl=-1;
  char *temp;
  time_t t, tl = (time_t) 0;

  while(1)
    {
      if(My_XNextEvent(dpy,&Event))
	{
	  switch(Event.type)
	    {
	    case Expose:
              if (Pushed)
                break;
	      if((Event.xexpose.count == 0)&&
		(Event.xany.window == main_win))
		{
		  if(ready < 1)
		    ready ++;
		  RedrawWindow(-1);
		}
	      break;
	      
	    case ButtonPress:
              if (Event.xbutton.button != Button1)
                  break;
	      CurrentRow = (Event.xbutton.y/ButtonHeight);
	      CurrentColumn = (Event.xbutton.x/ButtonWidth);
	      CurrentButton = CurrentColumn + CurrentRow*num_columns;

	      for(i=0;i<=CurrentRow;i++)
		for(j=0;j<= CurrentColumn; j++)
		  if(Buttons[i*num_columns+j].title!= NULL)
		    {
		      if(((CurrentRow - i)< 1)&&
			 (CurrentColumn-j)< 1)
			{
			  CurrentButton = i*num_columns+j;
			}
		    }

              if (Buttons[CurrentButton].swallow)
                  break;
              if (Pushable)
              {
                Pushed = 1;

                XMoveResizeWindow(dpy, Buttons[CurrentButton].IconWin,
                (((ICON_WIN_WIDTH-Buttons[CurrentButton].icon_w)/2))+9
                +(j-1)*ButtonWidth ,(i-1)*ButtonHeight+((((ICON_WIN_HEIGHT
                -Buttons[CurrentButton].icon_h)/2))+9),ButtonWidth,
                ButtonHeight);  

                RedrawWindow(CurrentButton);
                /* Top Hilite */

                XDrawLine( dpy, main_win, NormalGC, j*ButtonWidth-ButtonWidth,
                i*ButtonHeight-ButtonHeight, j*ButtonWidth,i*ButtonHeight
                -ButtonHeight);                                                          

                XDrawLine( dpy, main_win, NormalGC, j*ButtonWidth-ButtonWidth,
                i*ButtonHeight-ButtonHeight+1, j*ButtonWidth,i*ButtonHeight
                -ButtonHeight+1);                                                          
                /* Left Hilite */

                XDrawLine( dpy, main_win, NormalGC, j*ButtonWidth-ButtonWidth,
                i*ButtonHeight-ButtonHeight+1, j*ButtonWidth-ButtonWidth,
                i*ButtonHeight-1);

                XDrawLine( dpy, main_win, NormalGC, j*ButtonWidth-ButtonWidth
                +1, i*ButtonHeight-ButtonHeight+2, j*ButtonWidth-ButtonWidth+1,
                i*ButtonHeight-1);

                /* Right Hilite */

                XDrawLine( dpy, main_win, HiReliefGC, j*ButtonWidth
                -ButtonWidth+ButtonWidth-2, i*ButtonHeight-ButtonHeight+2,
                j*ButtonWidth-ButtonWidth+ButtonWidth-2 ,i*ButtonHeight-1);

                XDrawLine( dpy, main_win, HiReliefGC, j*ButtonWidth
                -ButtonWidth+ButtonWidth-1, i*ButtonHeight-ButtonHeight+1,
                j*ButtonWidth-ButtonWidth+ButtonWidth-1 ,i*ButtonHeight-1);

                /* Bottom Hilite */

                XDrawLine( dpy, main_win, HiReliefGC, j*ButtonWidth
                -ButtonWidth+1, i*ButtonHeight-1, j*ButtonWidth-ButtonWidth
                +ButtonWidth-2,i*ButtonHeight-1);

                XDrawLine( dpy, main_win, HiReliefGC, j*ButtonWidth
                -ButtonWidth+1, i*ButtonHeight-2, j*ButtonWidth-ButtonWidth
                +ButtonWidth-2,i*ButtonHeight-2);
              }
              break;

            case ButtonRelease:
	      if ((Event.xbutton.button != Button1) ||
                 (Buttons[CurrentButton].swallow)) 
                break;

              CurrentRow = (Event.xbutton.y/ButtonHeight);
              CurrentColumn = (Event.xbutton.x/ButtonWidth);

              if (Pushable) 
              {
                XMoveResizeWindow(dpy, Buttons[CurrentButton].IconWin,
                (((ICON_WIN_WIDTH-Buttons[CurrentButton].icon_w)/2))
                +8+((j-1)*ButtonWidth) ,(i-1)*ButtonHeight+
                ((((ICON_WIN_HEIGHT-Buttons[CurrentButton].icon_h)/2))
                +8),ButtonWidth,ButtonHeight);

                RedrawWindow(CurrentButton);
                Pushed=0;
/* top */
                XDrawLine( dpy, main_win, HiInnerGC, 
                j*ButtonWidth-ButtonWidth, i*ButtonHeight-ButtonHeight, 
                j*ButtonWidth,i*ButtonHeight-ButtonHeight);

                XDrawLine( dpy, main_win, HiInnerGC, j*ButtonWidth-ButtonWidth,
                i*ButtonHeight-ButtonHeight+1, j*ButtonWidth,
                i*ButtonHeight-ButtonHeight+1); 

/* left */
                XDrawLine( dpy, main_win, HiInnerGC, j*ButtonWidth-ButtonWidth,
                i*ButtonHeight-ButtonHeight+1, j*ButtonWidth-ButtonWidth,
                i*ButtonHeight-1);

                XDrawLine( dpy, main_win, HiInnerGC, j*ButtonWidth
                -ButtonWidth+1, i*ButtonHeight-ButtonHeight+2, 
                j*ButtonWidth-ButtonWidth+1 ,i*ButtonHeight-1);

/* right */
                XDrawLine( dpy, main_win, NormalGC, j*ButtonWidth-ButtonWidth
                +ButtonWidth-2, i*ButtonHeight-ButtonHeight+2, j*ButtonWidth
                -ButtonWidth+ButtonWidth-2 ,i*ButtonHeight-1);

                XDrawLine( dpy, main_win, NormalGC, j*ButtonWidth-ButtonWidth
                +ButtonWidth-1, i*ButtonHeight-ButtonHeight+1, 
                j*ButtonWidth-ButtonWidth+ButtonWidth-1 ,i*ButtonHeight-1);

/* bottom */
                XDrawLine( dpy, main_win, NormalGC, j*ButtonWidth
                -ButtonWidth+1, i*ButtonHeight-1, j*ButtonWidth-ButtonWidth
                +ButtonWidth-2,i*ButtonHeight-1);

                XDrawLine( dpy, main_win, NormalGC, j*ButtonWidth-ButtonWidth
                +1, i*ButtonHeight-2, j*ButtonWidth-ButtonWidth+ButtonWidth-2,
                i*ButtonHeight-2);
              }

              NewButton = CurrentColumn + CurrentRow*num_columns;
              for(i=0;i<=CurrentRow;i++)
                for(j=0;j<= CurrentColumn; j++)
                  if(Buttons[i*num_columns+j].title!= NULL)
                    {
                      if(((CurrentRow - i)< 1)&&
                         (CurrentColumn-j)< 1)
                        {
                          NewButton = i*num_columns+j;
                        }
                    }
              if(NewButton == CurrentButton)
                {
                     t = time( 0);
                     bl = -1;
                     tl = -1;

                     SendInfo(fd,Buttons[CurrentButton].action,0);

                     if((Buttons[CurrentButton].action)&&
                 (mystrncasecmp(Buttons[CurrentButton].action,"exec",4)== 0))
                     {  
                        i=4;
                        while((Buttons[CurrentButton].action[i] != 0)&&
                          (Buttons[CurrentButton].action[i] != '"'))
                         i++;
                         i2=i+1;
                         while((Buttons[CurrentButton].action[i2] != 0)&&
                         (Buttons[CurrentButton].action[i2] != '"'))
                         i2++;
                         if(i2 - i >1)
                         {
                          Buttons[CurrentButton].hangon = safemalloc(i2-i);
                          strncpy(Buttons[CurrentButton].hangon,
                          &Buttons[CurrentButton].action[i+1],i2-i-1);
                          Buttons[CurrentButton].hangon[i2-i-1] = 0;
                          Buttons[CurrentButton].up = 0;
                          Buttons[CurrentButton].swallow = 0;
                         }

                      }
                }
              break;

	    /*
	    case ClientMessage:
	     if ((Event.xclient.format==32) && 
		  (Event.xclient.data.l[0]==wm_del_win))
		{
		  DeadPipe(1);
		}
	      break;
	    case PropertyNotify:
              if (Pushed)
                break;
	      for(i=0;i<num_rows;i++)
		for(j=0;j<num_columns; j++)
		  {
		    button = i*num_columns + j;
		    if((Buttons[button].swallow == 3)&&
		       (Event.xany.window == Buttons[button].IconWin)&&
		       (Event.xproperty.atom == XA_WM_NAME))
		      {
			XFetchName(dpy, Buttons[button].IconWin, &temp);
			if(strcmp(Buttons[button].title,"-")!=0)
			  CopyString(&Buttons[button].title, temp);
			XFree(temp);
			XClearArea(dpy,main_win,j*ButtonWidth,
				   i*ButtonHeight, ButtonWidth,ButtonHeight,0);
			RedrawWindow(button);
		      }
		  }
	      break;
*/
	    default:
	      break;
	    }
	}
    }
  return;
}

/************************************************************************
 *
 * Draw the window 
 *
 ***********************************************************************/
void RedrawWindow(int newbutton)
{
  int i,j,w,button, b;
  XEvent dummy;
  int val1,val2;

  if(ready < 1)
    return;

  while (XCheckTypedWindowEvent (dpy, main_win, Expose, &dummy));

  for(i=0;i<num_rows;i++)
    for(j=0;j<num_columns; j++)
      {
	button = i*num_columns + j;
	if((newbutton == -1)||(newbutton == button))
	  {
	    if((Buttons[button].swallow == 3)&&
	       (Buttons[button].IconWin != None))
              XSetWindowBorderWidth(dpy,Buttons[button].IconWin,0);

	    if(Buttons[button].title != NULL)
	      {
		b = BACK_BUTTON;
                if( Buttons[b].icon_depth == d_depth)
{
if (Pushed)
                  XCopyArea( dpy, Buttons[b].iconPixmap, main_win,
                        NormalGC, 2, 2, Buttons[b].icon_w-2,
                        Buttons[b].icon_h-2, j*ButtonWidth+2, i*ButtonHeight+2);
else
                  XCopyArea( dpy, Buttons[b].iconPixmap, main_win,
                        NormalGC, 0, 0, Buttons[b].icon_w,
                        Buttons[b].icon_h, j*ButtonWidth, i*ButtonHeight);

}
                else
                  XCopyPlane( dpy, Buttons[b].iconPixmap, main_win, NormalGC,
                        0, 0, Buttons[b].icon_w, Buttons[b].icon_h,
                        j*ButtonWidth, i*ButtonHeight, 1);
	      }
	  }
      }
}


/************************************************************************
 *
 * Sizes and creates the window 
 *
 ***********************************************************************/
XSizeHints mysizehints;
void CreateWindow(void)
{
  XGCValues gcv;
  unsigned long gcm;
  int first_avail_button,i,j,k;

  wm_del_win = XInternAtom(dpy,"WM_DELETE_WINDOW",False);
  _XA_WM_PROTOCOLS = XInternAtom (dpy, "WM_PROTOCOLS", False);

  /* Allow for multi-width/height buttons */
  first_avail_button = num_buttons;
  
  if(num_buttons > MAX_BUTTONS)
    {
      fprintf(stderr,"%s: Out of Buttons!\n",MyName);
      exit(0);
    }
      
  /* size and create the window */
  if((num_rows == 0)&&(num_columns == 0))
    num_columns = 1;
  if(num_columns == 0)
    {
      num_columns = num_buttons/num_rows;
      while(num_rows * num_columns < num_buttons)
	num_columns++;
    }
  if(num_rows == 0)
    {
      num_rows = num_buttons/num_columns;
      while(num_rows * num_columns < num_buttons)
	num_rows++;
    }

  while(num_rows * num_columns < num_buttons)
    num_columns++;

  mysizehints.flags = PWinGravity| PResizeInc | PBaseSize;
  /* subtract one for the right/bottom border */
  mysizehints.width = ButtonWidth*num_columns;
  mysizehints.height= ButtonHeight*num_rows;
  mysizehints.width_inc = num_columns;
  mysizehints.height_inc = num_rows;
  mysizehints.base_height = num_rows - 1;
  mysizehints.base_width = num_columns - 1;

  if(x > -100000)
    {
      if (x< 0)
	{
	  mysizehints.x = DisplayWidth(dpy,screen) + x - mysizehints.width - 2;
	  gravity = NorthEastGravity;
	}
      else 
	mysizehints.x = x;
      if ( y<0)
	{
	  mysizehints.y = DisplayHeight(dpy,screen) + y - mysizehints.height-2;
	  gravity = SouthWestGravity;
	}
      else 
	mysizehints.y = y;

      if((x < 0) && (y < 0))
	gravity = SouthEastGravity;	
      mysizehints.flags |= USPosition;
    }

  mysizehints.win_gravity = gravity;
  if(d_depth < 2)
    {
      back_pix = GetColor("white");
      fore_pix = GetColor("black");
    }
  else
    {
      back_pix = GetColor("grey50");
      fore_pix = GetColor("grey17");
      light_grey = GetColor("grey72");
    }

  main_win = XCreateSimpleWindow(dpy,Root,mysizehints.x,mysizehints.y,
				 mysizehints.width,mysizehints.height,
				 1,fore_pix,back_pix);
  XSetWMProtocols(dpy,main_win,&wm_del_win,1);

  XSetWMNormalHints(dpy,main_win,&mysizehints);
  XSelectInput(dpy,main_win,MW_EVENTS);
  change_window_name(MyName);

  gcm = GCForeground|GCBackground;
  gcv.foreground = fore_pix;
  gcv.background = back_pix;
  NormalGC = XCreateGC(dpy, Root, gcm, &gcv);  

  gcv.foreground = back_pix;
  gcv.background = fore_pix;
  HiReliefGC = XCreateGC(dpy, Root, gcm, &gcv);

  gcv.foreground = light_grey;
  gcv.background = fore_pix;
  HiInnerGC = XCreateGC(dpy, Root, gcm, &gcv);

}


void nocolor(char *a, char *b)
{
 fprintf(stderr,"%s: can't %s %s\n", MyName, a,b);
}

/****************************************************************************
 * 
 * Loads a single color
 *
 ****************************************************************************/ 
Pixel GetColor(char *name)
{
  XColor color;
  XWindowAttributes attributes;

  XGetWindowAttributes(dpy,Root,&attributes);
  color.pixel = 0;
   if (!XParseColor (dpy, attributes.colormap, name, &color)) 
     {
       nocolor("parse",name);
     }
   else if(!XAllocColor (dpy, attributes.colormap, &color)) 
     {
       nocolor("alloc",name);
     }
  return color.pixel;
}


/************************************************************************
 *
 * Dead pipe handler
 *
 ***********************************************************************/
void DeadPipe(int nonsense)
{
  int i,j,button;

  for(i=0;i<num_rows;i++)
    for(j=0;j<num_columns; j++)
      {
	button = i*num_columns + j;
        /* delete swallowed windows, but not modules (fvwm handles those) */
	if((Buttons[button].swallow == 3)&&(Buttons[button].module == 0))
	  {
	    send_clientmessage(Buttons[button].IconWin,wm_del_win,CurrentTime);
	    XSync(dpy,0);
	  }
      }
  XSync(dpy,0);
  exit(0);
}

/*****************************************************************************
 * 
 * This routine is responsible for reading and parsing the config file
 *
 ****************************************************************************/
void ParseOptions(char *filename)
{
  FILE *fd = (FILE *)0;
  char line[256];
  char *tline,*orig_tline,*tmp;
  int Clength, len;

  fd = fopen(filename,"r");
  if(fd == (FILE *)0)
    {
      fprintf(stderr,"%s: can't open config file %s",MyName,filename);
      exit(1);
    }

  tline = fgets(line,(sizeof line)-1,fd);
  orig_tline = tline;
  Clength = strlen(MyName);
  while(tline != (char *)0)
    {
      int g_x, g_y, flags;
      unsigned width,height;

      while(isspace(*tline))tline++;

      if((strlen(&tline[0])>1)&&
	 (mystrncasecmp(tline,CatString3("*", MyName, "Geometry"),Clength+9)==0))
	{
	  tmp = &tline[Clength+9];
	  while(((isspace(*tmp))&&(*tmp != '\n'))&&(*tmp != 0))
	    {
	      tmp++;
	    }
	  tmp[strlen(tmp)-1] = 0;

	  flags = XParseGeometry(tmp,&g_x,&g_y,&width,&height);
	  if (flags & WidthValue) 
	    w = width;
	  if (flags & HeightValue) 
	    h = height;
	  if (flags & XValue) 
	    x = g_x;
	  if (flags & YValue) 
	    y = g_y;
	}
      else if((strlen(&tline[0])>1)&&
	      (mystrncasecmp(tline,CatString3("*",MyName,"Rows"),Clength+5)==0))
	{
	  len=sscanf(&tline[Clength+5],"%d",&num_rows);
	  if(len < 1)
	    num_rows = 0;
	}
      else if((strlen(&tline[0])>1)&&
	      (mystrncasecmp(tline,CatString3("*",MyName,"Columns"),Clength+8)==0))
	{
	  len=sscanf(&tline[Clength+8],"%d",&num_columns);
	  if(len < 1)
	    num_columns = 0;
	}
      else if((strlen(&tline[0])>1)&&
              (mystrncasecmp(tline,CatString3("*",MyName,"NoPush"),Clength+5)==0))
        {
            Pushable = 0;
        }

      else if((strlen(&tline[0])>1)&&
	      (mystrncasecmp(tline,CatString3("*", MyName, ""),Clength+1)==0)&&
	      (num_buttons < MAX_BUTTONS))
	{
	  match_string(&tline[Clength+1]);
	}
      else if((strlen(&tline[0])>1)&&(mystrncasecmp(tline,"IconPath",8)==0))
	{
	  CopyString(&iconPath,&tline[8]);
	}
      else if((strlen(&tline[0])>1)&&(mystrncasecmp(tline,"PixmapPath",10)==0))
	{
	  CopyString(&pixmapPath,&tline[10]);
	}
      tline = fgets(line,(sizeof line)-1,fd);
      orig_tline = tline;
    }
  
  return;
}


/**************************************************************************
 *
 * Parses a button command line from the config file 
 *
 *************************************************************************/
void match_string(char *tline)
{
  int len,i,i2,n;
  char *ptr,*start,*end,*tmp;

  /* skip spaces */
  while(isspace(*tline)&&(*tline != '\n')&&(*tline != 0))
    tline++;

  /* read next word. Its the button label. Users can specify "" 
   * NoIcon, or whatever to skip the label */
  /* read to next space */
  start = tline;
  end = tline;
  while((!isspace(*end))&&(*end!='\n')&&(*end!=0))
    end++;
  len = end - start;
  ptr = safemalloc(len+1);
  strncpy(ptr,start,len);
  ptr[len] = 0;
  Buttons[num_buttons].title = ptr;      

  /* read next word. Its the icon bitmap/pixmap label. Users can specify "" 
   * NoIcon, or whatever to skip the label */
  /* read to next space */
  start = end;
  /* skip spaces */
  while(isspace(*start)&&(*start != '\n')&&(*start != 0))
    start++;
  end = start;
  while((!isspace(*end))&&(*end!='\n')&&(*end!=0))
    end++;
  len = end - start;
  ptr = safemalloc(len+1);
  strncpy(ptr,start,len);
  ptr[len] = 0;
  Buttons[num_buttons].icon_file = ptr;      

  tline = end;
  /* skip spaces */
  while(isspace(*tline)&&(*tline != '\n')&&(*tline != 0))
    tline++;

  if(mystrncasecmp(tline,"swallow",7)==0 || mystrncasecmp(tline,"maxswallow",10)==0)
    {
      /* Look for swallow "identifier", in which
       * case GoodStuff spawns and gobbles up window */
      i=7;
      while((tline[i] != 0)&&
	    (tline[i] != '"'))
	i++;
      i2=i+1;
      while((tline[i2] != 0)&&
	    (tline[i2] != '"'))
	i2++;
      Buttons[num_buttons].maxsize =
                 mystrncasecmp(tline,"maxswallow",10) == 0 ? 1 : 0;
      if(i2 - i >1)
	{
	  Buttons[num_buttons].hangon = safemalloc(i2-i);
	  strncpy(Buttons[num_buttons].hangon,&tline[i+1],i2-i-1);
	  Buttons[num_buttons].hangon[i2-i-1] = 0;
	  Buttons[num_buttons].swallow = 1;
	}
      n = 7;
      while((isspace(tline[n]))&&(tline[n]!=0))
	n++;
      len = strlen(&tline[n]);
      tmp = tline + n + len -1;
      while(((isspace(*tmp))||(*tmp == '\n'))&&(tmp >=(tline + n)))
	{
	  tmp--;
	  len--;
	}
      ptr = safemalloc(len+6);
      if(mystrncasecmp(&tline[n],"Module",6)==0)
	{
	  ptr[0] = 0;
          Buttons[num_buttons].module = 1;
	}	  
      else
	strcpy(ptr,"Exec ");
      i2 = strlen(ptr);
      strncat(ptr,&tline[n],len);
      ptr[i2+len]=0;
      SendText(fd,ptr,0);     
      free(ptr);
      Buttons[num_buttons++].action = NULL;
    }
  else
    {
      len = strlen(tline);
      tmp = tline + len -1;
      while(((isspace(*tmp))||(*tmp == '\n'))&&(tmp >=tline))
	{
	  tmp--;
	  len--;
	}
      ptr = safemalloc(len+1);
      strncpy(ptr,tline,len);
      ptr[len]=0;
      Buttons[num_buttons++].action = ptr;
    }
  return;
}

/**************************************************************************
 *  Change the window name displayed in the title bar.
 **************************************************************************/
void change_window_name(char *str)
{
  XTextProperty name;
  
  if (XStringListToTextProperty(&str,1,&name) == 0) 
    {
      fprintf(stderr,"%s: cannot allocate window name",MyName);
      return;
    }
  XSetWMName(dpy,main_win,&name);
  XSetWMIconName(dpy,main_win,&name);
  XFree(name.value);
}



/***************************************************************************
 *
 * Waits for next X event, or for an auto-raise timeout.
 *
 ****************************************************************************/
int My_XNextEvent(Display *dpy, XEvent *event)
{
  fd_set in_fdset;
  unsigned long header[3];
  int body_length;
  int count,count2 = 0;
  static int miss_counter = 0;
  unsigned long *body;
  int total;
  char *cbody;

  if(XPending(dpy))
    {
      XNextEvent(dpy,event);
      return 1;
    }

  FD_ZERO(&in_fdset);
  FD_SET(x_fd,&in_fdset);
  FD_SET(fd[1],&in_fdset);

#ifdef __hpux
  select(fd_width,(int *)&in_fdset, 0, 0, NULL);
#else
  select(fd_width,&in_fdset, 0, 0, NULL);
#endif


  if(FD_ISSET(x_fd, &in_fdset))
    {
      if(XPending(dpy))
	{
	  XNextEvent(dpy,event);
	  miss_counter = 0;
	  return 1;
	}
      else
	miss_counter++;
      if(miss_counter > 100)
	DeadPipe(0);
    }
  
  if(FD_ISSET(fd[1], &in_fdset))
    {
      if(count = ReadFvwmPacket(fd[1], header, &body) > 0)
	{
	  process_message(header[1],body);
	  free(body);
	}
    }
  return 0;
}

void CheckForHangon(unsigned long *body)
{
  int button,i,j;
  char *cbody;

  cbody = (char *)&body[3];
  for(i=0;i<num_rows;i++)
    for(j=0;j<num_columns; j++)
      {
	button = i*num_columns + j;      
	if(Buttons[button].hangon != NULL)
	  {
	    if(strcmp(cbody,Buttons[button].hangon)==0)
	      {
		if(Buttons[button].swallow ==  1)
		  {
		    Buttons[button].swallow = 2;
		    if(Buttons[button].IconWin != None)
		      {
			XDestroyWindow(dpy,Buttons[button].IconWin);
		      }
		    Buttons[button].IconWin = (Window)body[0];
		    free(Buttons[button].hangon);
		    Buttons[button].hangon = NULL;
		  }
		else
		  {
		    Buttons[button].up = 1;
		    free(Buttons[button].hangon);
		    Buttons[button].hangon = NULL;
		    RedrawWindow(button);
		  }
	      }
	  }
      }
}

/**************************************************************************
 *
 * Process window list messages 
 *
 *************************************************************************/
void process_message(unsigned long type,unsigned long *body)
{
  switch(type)
    {
    case M_TOGGLE_PAGING:
      pageing_enabled = body[0];
      RedrawWindow(-1);
      break;
    case M_NEW_DESK:
      new_desk = body[0];
      RedrawWindow(-1);
      break;
    case M_END_WINDOWLIST:
      RedrawWindow(-1);
    case M_MAP:
      swallow(body);
    case M_RES_NAME:
    case M_RES_CLASS:
    case M_WINDOW_NAME:
      CheckForHangon(body);
      break;
    default:
      break;
    }
}





/***************************************************************************
 *
 * ICCCM Client Messages - Section 4.2.8 of the ICCCM dictates that all
 * client messages will have the following form:
 *
 *     event type	ClientMessage
 *     message type	_XA_WM_PROTOCOLS
 *     window		tmp->w
 *     format		32
 *     data[0]		message atom
 *     data[1]		time stamp
 *
 ****************************************************************************/
void send_clientmessage (Window w, Atom a, Time timestamp)
{
  XClientMessageEvent ev;
  
  ev.type = ClientMessage;
  ev.window = w;
  ev.message_type = _XA_WM_PROTOCOLS;
  ev.format = 32;
  ev.data.l[0] = a;
  ev.data.l[1] = timestamp;
  XSendEvent (dpy, w, False, 0L, (XEvent *) &ev);
}


void swallow(unsigned long *body)
{
  char *temp;
  int button,i,j;
  long supplied;
  
  for(i=0;i<num_rows;i++)
    for(j=0;j<num_columns; j++)
      {
	button = i*num_columns + j;      
	if((Buttons[button].IconWin == (Window)body[0])&&
	  (Buttons[button].swallow == 2))
	  {
	    Buttons[button].swallow = 3;
	    /* "Swallow" the window! */
	    XReparentWindow(dpy,Buttons[button].IconWin, main_win, 
			    j*ButtonWidth+4, i*ButtonHeight+4);
	    XMapWindow(dpy,Buttons[button].IconWin);
	    XSelectInput(dpy,(Window)body[0],
			 PropertyChangeMask);
	    if (Buttons[button].maxsize) {
	        Buttons[button].icon_w = 55;
	        Buttons[button].icon_h = 57;
	        }
	    else {
	        Buttons[button].icon_w = ICON_WIN_WIDTH;
	        Buttons[button].icon_h = ICON_WIN_HEIGHT;
	        }
	    if (!XGetWMNormalHints (dpy, Buttons[button].IconWin,
				    &Buttons[button].hints, 
				    &supplied))
	      Buttons[button].hints.flags = 0;
 							    
	    XResizeWindow(dpy,(Window)body[0], Buttons[button].icon_w,
			  Buttons[button].icon_h);
	    XMoveWindow(dpy,Buttons[button].IconWin,
			j*ButtonWidth +
			(ButtonWidth - Buttons[button].icon_w)/2,
			i*ButtonHeight + 
			(ButtonHeight - Buttons[button].icon_h)/2);

	    XFetchName(dpy, Buttons[button].IconWin, &temp);
	    XClearArea(dpy,main_win,j*ButtonWidth, i*ButtonHeight,
		       ButtonWidth,ButtonHeight,0);
	    if(strcmp(Buttons[button].title,"-")!=0)
	      CopyString(&Buttons[button].title, temp);
	    RedrawWindow(-1);
	    XFree(temp);
	  }
      }
}



/***********************************************************************
 *
 *  Procedure:
 *      ConstrainSize - adjust the given width and height to account for the
 *              constraints imposed by size hints
 *
 *      The general algorithm, especially the aspect ratio stuff, is
 *      borrowed from uwm's CheckConsistency routine.
 * 
 ***********************************************************************/
void ConstrainSize (XSizeHints *hints, int *widthp, int *heightp)
{
#define makemult(a,b) ((b==1) ? (a) : (((int)((a)/(b))) * (b)) )
#define _min(a,b) (((a) < (b)) ? (a) : (b))

  
  int minWidth, minHeight, maxWidth, maxHeight, xinc, yinc, delta;
  int baseWidth, baseHeight;
  int dwidth = *widthp, dheight = *heightp;

  if(hints->flags & PMinSize)
    {
      minWidth = hints->min_width;
      minHeight = hints->min_height;
      if(hints->flags & PBaseSize)
	{
	  baseWidth = hints->base_width;
	  baseHeight = hints->base_height;
	}
      else
	{
	  baseWidth = hints->min_width;
	  baseHeight = hints->min_height;
	}
    }
  else if(hints->flags & PBaseSize)
    {
      minWidth = hints->base_width;
      minHeight = hints->base_height;
      baseWidth = hints->base_width;
      baseHeight = hints->base_height;
    }
  else
    {
      minWidth = 1;
      minHeight = 1;
      baseWidth = 1;
      baseHeight = 1;
    }
  
  if(hints->flags & PMaxSize)
    {
      maxWidth = hints->max_width;
      maxHeight = hints->max_height;
    }
  else
    {
      maxWidth = 10000;
      maxHeight = 10000;
    }
  if(hints->flags & PResizeInc)
    {
      xinc = hints->width_inc;
      yinc = hints->height_inc;
    }
  else
    {
      xinc = 1;
      yinc = 1;
    }
  
  /*
   * First, clamp to min and max values
   */
  if (dwidth < minWidth) dwidth = minWidth;
  if (dheight < minHeight) dheight = minHeight;
  
  if (dwidth > maxWidth) dwidth = maxWidth;
  if (dheight > maxHeight) dheight = maxHeight;
  
  
  /*
   * Second, fit to base + N * inc
   */
  dwidth = ((dwidth - baseWidth) / xinc * xinc) + baseWidth;
  dheight = ((dheight - baseHeight) / yinc * yinc) + baseHeight;
  
  
  /*
   * Third, adjust for aspect ratio
   */
#define maxAspectX hints->max_aspect.x
#define maxAspectY hints->max_aspect.y
#define minAspectX hints->min_aspect.x
#define minAspectY hints->min_aspect.y
  /*
   * The math looks like this:
   *
   * minAspectX    dwidth     maxAspectX
   * ---------- <= ------- <= ----------
   * minAspectY    dheight    maxAspectY
   *
   * If that is multiplied out, then the width and height are
   * invalid in the following situations:
   *
   * minAspectX * dheight > minAspectY * dwidth
   * maxAspectX * dheight < maxAspectY * dwidth
   * 
   */
  
  if (hints->flags & PAspect)
    {
      if (minAspectX * dheight > minAspectY * dwidth)
	{
	  delta = makemult(minAspectX * dheight / minAspectY - dwidth,
			   xinc);
	  if (dwidth + delta <= maxWidth) 
	    dwidth += delta;
	  else
	    {
	      delta = makemult(dheight - dwidth*minAspectY/minAspectX,
			       yinc);
	      if (dheight - delta >= minHeight) dheight -= delta;
	    }
	}
      
      if (maxAspectX * dheight < maxAspectY * dwidth)
	{
	  delta = makemult(dwidth * maxAspectY / maxAspectX - dheight,
			   yinc);
	  if (dheight + delta <= maxHeight)
	    dheight += delta;
	  else
	    { 
	      delta = makemult(dwidth - maxAspectX*dheight/maxAspectY,
			       xinc);
	      if (dwidth - delta >= minWidth) dwidth -= delta;
	    }
	}
    }
  
  *widthp = dwidth;
  *heightp = dheight;
  return;
}


