# Top level makefile to build Win32 version of ILU
# Microsoft Visual C++
#
# Assumes your PATH has the appropriate bin directory in it (e.g. msvc\bin)
# Assumes your INCLUDE environment variable includes the appropriate directories (e.g. msvc\include) 
# Assumes your LIB environment variable includes the appropriate directories (e.g. msvc\lib) 

!IF "$(CFG)" == ""
CFG=Win32 Release
!MESSAGE No configuration specified.  Defaulting to Win32 Release.
!MESSAGE Possible choices for configuration are: "Win32 Release" "Win32 Debug"
!ENDIF 


################################################################################

SUBDIRECTORIES= runtime.dir stubbers.dir etc.dir
CLEANSUBS= runtime.clean stubbers.clean etc.clean

################################################################################

ALL : $(ILUHOME) $(ILUHOME)\bin $(ILUHOME)\lib $(SUBDIRECTORIES)

$(ILUHOME) : 
    if not exist $(ILUHOME)\nul mkdir $(ILUHOME)

$(ILUHOME)\lib : 
    if not exist $(ILUHOME)\lib\nul mkdir $(ILUHOME)\lib

$(ILUHOME)\bin : 
    if not exist $(ILUHOME)\bin\nul mkdir $(ILUHOME)\bin

$(SUBDIRECTORIES) :
	cd $*
	nmake -f iluwin32.mak CFG="$(CFG)"
	cd ..

clean : $(CLEANSUBS)

$(CLEANSUBS) :
	cd $*
	nmake -f iluwin32.mak CFG="$(CFG)" clean
	cd ..


install : $(ILUHOME)\interfaces $(ILUHOME)\include $(ILUHOME)\examples $(ILUHOME)\pythonfiles $(ILUHOME)\javafiles  CLEANOUT 


$(ILUHOME)\interfaces : 
    if not exist $(ILUHOME)\interfaces\nul mkdir $(ILUHOME)\interfaces
	copy $(ILUSRC)\stubbers\parser\ilu.isl $(ILUHOME)\interfaces
	copy $(ILUSRC)\stubbers\parser\iluhttp.isl $(ILUHOME)\interfaces


$(ILUHOME)\include : 
    if not exist $(ILUHOME)\include\nul mkdir $(ILUHOME)\include
	copy $(ILUSRC)\runtime\cpp\ilu.hh $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\ilubasic.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\c\iluchdrs.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\c\ilucstub.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\iludebug.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\iluerror.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\iluerrs.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\iluhash.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\iluntrnl.h $(ILUHOME)\include
	copy $(ILUSRC)\stubbers\parser\iluptype.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\iluxport.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\ilusock.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\iluwin.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\ilutypes.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\protocol.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\transprt.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\kernel\ilutpcod.h $(ILUHOME)\include
	copy $(ILUSRC)\runtime\cpp2\ilu.hpp $(ILUHOME)\include
	copy $(ILUSRC)\runtime\cpp2\corba.hpp $(ILUHOME)\include
	copy $(ILUSRC)\runtime\cpp2\corba-templates.hpp $(ILUHOME)\include
	copy $(ILUSRC)\stubbers\cpp2\cppportability.hpp $(ILUHOME)\include
	copy $(ILUSRC)\stubbers\cpp2\optionaltemplates.hpp $(ILUHOME)\include

$(ILUHOME)\examples : 
    if not exist $(ILUHOME)\examples\nul mkdir $(ILUHOME)\examples
    xcopy $(ILUSRC)\examples $(ILUHOME)\examples /s 

$(ILUHOME)\pythonfiles :	$(ILUHOME)\lib
	copy $(ILUSRC)\runtime\python\*.py $(ILUHOME)\lib


$(ILUHOME)\javafiles :	$(ILUHOME)\lib
    if not exist $(ILUHOME)\lib\javaclasses\nul mkdir $(ILUHOME)\lib\javaclasses
    if exist $(ILUSRC)\runtime\java\javaclasses xcopy $(ILUSRC)\runtime\java\javaclasses $(ILUHOME)\lib\javaclasses /s 


CLEANOUT : 
    if exist $(ILUHOME)\bin del /q $(ILUHOME)\bin\*.ilk
    if exist $(ILUHOME)\bin del /q $(ILUHOME)\bin\*.exp
    if exist $(ILUHOME)\bin del /q $(ILUHOME)\bin\*.map
    if exist $(ILUHOME)\lib del /q $(ILUHOME)\lib\*.ilk
    if exist $(ILUHOME)\lib del /q $(ILUHOME)\lib\*.exp
    if exist $(ILUHOME)\lib del /q $(ILUHOME)\lib\*.map

 
# End 
################################################################################
