/* IluGCClient.java */
/* Chris Jacobi, October 23, 1997 5:41 pm PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluGCClient.java,v 1.19 1997/10/24 00:41:14 jacobi Exp $ */
 
/* 
 * Private internal package.
 * Native code in IluJava_GCClient.c
 */

package xerox.ilu;
import xerox.ilu.IluClassRep;
import xerox.ilu.IluRT0;
import xerox.ilu.IluOInt;
import xerox.ilu.IluRuntimeException;
import xerox.ilu.IluServer;

/** 
 * Special class used by ilu java runtime itself to implement 
 * collectable objects.  Nothing is client accessible.
 */
class IluGCClient implements IluDataSupport {

    private IluGCClient() {
    }
    
    private static boolean isInit = false;
    private static IluServer server;
    private static IluClassRep classRep;
    private static IluGCClient gcObj;
    
    private final static synchronized boolean initialized(){
        if (isInit) return true;
        isInit = true;
        return false;
    }
    
    private static java.lang.Object anchor = null;
    
    public void setIluData(java.lang.Object internal) {
        if (anchor == null) anchor = internal;
    }
    
    public java.lang.Object getIluData() {
        return anchor;
    }
    
    /*friendly*/ final static void init() throws IluSystemException {
        if (isInit) return;
        if (initialized()) return;
        if (! IluInit.doInit()) return;
        if (nativeIsGcClientSet()) return;
        try {
            server = IluServer.createServer(null)
                .setDeamonFlag(true)
                .finishInitialization();
            classRep = IluClassRep.setupClass(
                "xerox.ilu.IluGCClient" , //bogus
            	"special_gc_class" , //bogus, 
            	null, //uuid
        	0 //method_count
        	);
            finishSpecialGCClass(classRep);
            gcObj = new IluGCClient();
            IluRT0.registerTrueObject("special_gc_inst", 
                gcObj, server, classRep,
                IluLifetimeArgs.iluLifetimeRemember
                );
            gcObj.setupSpecialGCObj(IluOInt.peek(gcObj));
        } catch (java.lang.Exception e) {
            IluDebug.clientPreError("! ** xerox.ilu.IluGCClient failure: " + e);
            throw new IluSomeSystemException(
                "failed initializing xerox.ilu.IluGCClient" + e
                );
        }
    }
    
    private static native boolean 
    nativeIsGcClientSet();
    
    private static native void 
    finishSpecialGCClass(IluClassRep classRep);
    
    private static native void 
    setupSpecialGCObj(IluOInt jjoi);
    
} // IluGCClient
