/* IluIdentity.java */
/* Chris Jacobi, September 2, 1997 11:54 am PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* 
 * $Id: IluIdentity.java,v 1.2 1997/09/02 19:12:19 jacobi Exp $ 
 */


/* 
 * Representation for ilu_IdentityInfo <p>
 * See IluJava_IluPort.c
 */


package xerox.ilu;

/**
 * Client visible.<p>
 *
 * In theory we would like an immutable IluIdentity class which is 
 * subclassed for different IluIdentityType's. However since we need 
 * to allocate the real data on the native side after we present a 
 * container, this becomes more tricky and somewhat harder to use.<p>
 *
 * Creation of IluIdentity is limited to "friends".  IluIdentityType
 * deals with allowing or not allowing creation of IluIdentity.
 *
 * @see IluIdentityType
 * @see IluPassport
 */
public final class IluIdentity extends IluWPBase {
    /*friendly*/ long yIluIdentity = 0;
    /*friendly*/ IluIdentityType it = null;
    private java.lang.String asString = null;
    
    /**
     * Creation of IluIdentity is for friends only; Applications rather
     * use IluIdentityType.createIluIdentity to create IluIdentity's
     */
    /*friendly*/ IluIdentity(IluIdentityType it) {
        this.it = it;
    } //constructor


    /**
     * Primitive useful for IluIdentityType
     */
    /*friendly*/ native java.lang.String nId2String();
    
    private native void nFinalizeIdentity();
    
    protected final void finalize () throws java.lang.Throwable {
        nFinalizeIdentity();	//return native memory
        super.finalize();	//IluWPBase requirement 
    } //finalize

    /**
     * Returns representation of IluIdentity as a string
     */
    public java.lang.String toString() {
       if (this.asString == null) {
           java.lang.String s = this.it.identityToStringPart(this);
           if (this.asString == null) {this.asString = s;}
       }
       return this.asString;
    } //toString
    
} //IluIdentity
