/* IluObjectBase.java */
/* Chris Jacobi, August 20, 1997 4:08 pm PDT */

/*
 * Copyright (c) 1996, 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluObjectBase.java,v 1.9 1997/08/20 23:10:04 jacobi Exp $ */
 

package xerox.ilu;

/**
 * Base super class used for surrogate object implementation.<p>
 * Class is client visible.
 * This might as well be used as base class for true objects, at the
 * discretion of the programmer (of the true object's class).
 *
 * @see org.omg.CORBA.ObjectImpl
 */
public abstract class IluObjectBase implements IluObject, IluDataSupport {
    
    protected IluOInt oint = null; 
    
    protected IluObjectBase() {
    }
    
    /** This is logically "friendly" but public to 
     * export the IluDataSupport interface
     */
    public void setIluData(Object internal) {
        //Ilu calls this only once
        if (oint==null) oint = (IluOInt) internal;
    }
    
    public java.lang.Object getIluData() {
        return oint;
    }
    
    /* Not public but for surrogate stubs 
     * Surrogates DO have IluDataSupport, others may crash...
     */
    public IluClassRep getIluClass() {
        return oint.jjClassRep;
    }
    
    
    
    /** used only if extending org.omg.CORBA.Object */
    public boolean _is_a(java.lang.String identifier) {
        throw new IluSystemException("not impl"); 
    }
    
    /** used only if extending org.omg.CORBA.Object */
    public boolean _is_equivalent(org.omg.CORBA.Object that) {
        return (that == this);
    }
    
    /** used only if extending org.omg.CORBA.Object */
    public boolean _non_existent() {
        try {
            IluRT0.ping(this);
            return false;
        } catch (xerox.ilu.IluSystemExceptionBase se) {
            return true;
        }
    }
    
    /** used only if extending org.omg.CORBA.Object */
    public int _hash(int maximum) {
        throw new IluSystemException("not impl"); 
    }
    
    /** used only if extending org.omg.CORBA.Object */
    public org.omg.CORBA.Object _duplicate() {
        if (this instanceof org.omg.CORBA.Object) {
            return (org.omg.CORBA.Object) this;
        }  
        throw new xerox.ilu.IluSomeSystemException("ilu object isn't corba::object");
    }
    
    /** used only if extending org.omg.CORBA.Object */
    public void _release() {
    }

    
} //IluObjectBase
