/* IluRootObjectHelper.java */
/* Chris Jacobi, August 20, 1997 4:17 pm PDT */

/*
 * Copyright (c) 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluRootObjectHelper.java,v 1.1 1997/08/28 21:11:40 jacobi Exp $ */

package xerox.ilu;

public class IluRootObjectHelper implements xerox.ilu.IluIOFunctions  {
    private final static java.lang.String uid = "ilu:root-object-type";
    private static IluTypeCode tc = null;

    /*friendly*/ static final void init () {
        if (tc==null) {
            tc = IluTypeCode.newTypeCode(uid, 
                new IluRootObjectHelper(), 
                org.omg.CORBA.TCKind.tk_objref);
        }
    } //init


    public final static java.lang.String id() {
        return uid;
    } //id 

    public final static IluTypeCode type() {
        return tc;
    } //type 

    public static xerox.ilu.IluAny insert(xerox.ilu.IluObject _x) 
            throws xerox.ilu.IluSystemException {
        xerox.ilu.IluAny _any = new xerox.ilu.IluAny();
        xerox.ilu.IluPickle _pickle = to_pickle(_x);
        _any.setPickle(_pickle);
        return _any;
    } //insert 

    public static xerox.ilu.IluObject extract(org.omg.CORBA.Any _any) 
            throws xerox.ilu.IluSystemException {
        xerox.ilu.IluPickle _pickle = ((xerox.ilu.IluAny)_any).getPickle();
        return from_pickle(_pickle);
    } //extract 

    public static xerox.ilu.IluPickle to_pickle(xerox.ilu.IluObject _x) 
            throws xerox.ilu.IluSystemException {
        int _sz = 0;
        xerox.ilu.IluCall _call = null;
        xerox.ilu.IluPickle _pickle = new xerox.ilu.IluPickle();
        try {
            _call = _pickle.startToPickle();
            _sz = _call.szObject(_x, false, IluClassRep.rootClass());
            _pickle.midToPickle(_call, _sz, id());
            _call.outObject(_x, false, IluClassRep.rootClass());
        } finally {
            _pickle.endToPickle(_call);
        }
        return _pickle;
    } //to_pickle 

    public static xerox.ilu.IluObject from_pickle(xerox.ilu.IluPickle _pickle) 
            throws xerox.ilu.IluSystemException {
        xerox.ilu.IluObject _x = null;
        xerox.ilu.IluCall _call = null;
        try {
            _call = _pickle.startFromPickle(id());
            _x = (xerox.ilu.IluObject) _call.inObject(
                false, IluClassRep.rootClass());
        } finally {
            _pickle.endFromPickle(_call);
        }
        return _x;
    } //from_pickle 

    /** Not public; implements xerox.ilu.IluIOFunctions */
    public int szFunc(
            xerox.ilu.IluCall _call, 
            java.lang.Object _x, 
            IluTypeCode tc) 
            throws xerox.ilu.IluSystemException {
        xerox.ilu.IluObject _xx = (xerox.ilu.IluObject)_x;
        return _call.szObject(_xx, false, IluClassRep.rootClass());
    } //szFunc 

    /** Not public; implements xerox.ilu.IluIOFunctions */
    public void outFunc(
            xerox.ilu.IluCall _call, 
            java.lang.Object _x, 
            IluTypeCode tc) 
            throws xerox.ilu.IluSystemException {
        xerox.ilu.IluObject _xx = (xerox.ilu.IluObject)_x;
        _call.outObject(_xx, false, IluClassRep.rootClass());
    } //outFunc 

    /** Not public; implements xerox.ilu.IluIOFunctions */
    public java.lang.Object inFunc(
            xerox.ilu.IluCall _call, 
            IluTypeCode tc) 
            throws xerox.ilu.IluSystemException {
        return (xerox.ilu.IluObject) _call.inObject(
            false, IluClassRep.rootClass());
    } //inFunc 

    public boolean isAFunc(java.lang.Object _x, IluTypeCode tc) {
        if (_x == null) return false;
        return (_x instanceof xerox.ilu.IluObject);
    } //isAFunc 

}//IluRootObjectHelper

