/* IluSimpleErrors.java */
/* Chris Jacobi, August 29, 1997 2:19 pm PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluSimpleErrors.java,v 1.5 1997/09/02 19:12:19 jacobi Exp $ */

package xerox.ilu;

/**
 * IluSimpleErrors is a way to raise various exceptions
 * including exceptions with non string arguments from Ilu's 
 * runtime side.
 */
public
class IluSimpleErrors {
    
    /*prevent bogus instances */
    private IluSimpleErrors() {
    }
    
    /**called from native code */
    /*friendly*/ void raiseError(int xcode, java.lang.String xstring) 
    			throws xerox.ilu.IluSystemException {
        switch (xcode) {
            case 1:
                throw new xerox.ilu.IluSomeSystemException(
                    "Ilu error " + xstring
                    );
            default:
                throw new xerox.ilu.IluSomeSystemException(
                    "Unknown ilu error " + xstring
                    );
        };
    } //raiseError 
    
    /*
     * We need an instance on the native side
     * to be able to invoke methods.
     */
    private static native void reportInstance();
    private static IluSimpleErrors theInstance = null;
    static {
       IluInit.init();
       init();
    }
    
    
    /**
     * Can be called to assert initialization.
     * Internally called; ilu clients do not have to.
     */
    public static void init() {
        theInstance = new IluSimpleErrors();
        theInstance.reportInstance();
    }
    
} //IluSimpleErrors
