/* IluTransportInfo.java */
/* Chris Jacobi, August 14, 1997 4:08 pm PDT */

/*
 * Copyright (c) 1996, 1997 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluTransportInfo.java,v 1.9 1997/08/15 06:23:04 jacobi Exp $ */
 
/* 
 * Native side together with IluPort 
 * See IluJava_IluPort.c
 *
 */


package xerox.ilu;

/**
 * Transport information is used to describe servers. <p>
 * @see IluServer
 * @see IluPort
 */
final public class IluTransportInfo {
    private long yIluTransportInfo = 0; 
    /*friendly*/ java.lang.String[] info = null;
    private static java.lang.String[] defaultInfo = null;
    
    /* Accessors for the ilu-default */
    private static native int nativeCountDefaultComponents();
    /*friendly*/ static native  
        java.lang.String nativeGetDefaultComponent(int n);

    /* Build corresponding native resources */
    private native void nativeInitTransportInfo(java.lang.String[] info);

    /* Reclaim native resources */
    private native void nativeFinalizeTransportInfo();
    
    /** 
     * Create a transport info.
     * Use null info array for default. 
     */
    public IluTransportInfo(java.lang.String[] info) {
        if (IluDebug.traceDefs() > 0) {
            IluDebug.log.println("! IluTransportInfo: created");
        }
        if (info == null) info = buildDefault();
        this.info = info;
        this.nativeInitTransportInfo(info);
    } 
    
    /* friendly */ static java.lang.String[] buildDefault() {
        if (defaultInfo != null) return defaultInfo;
        int n = nativeCountDefaultComponents();
        java.lang.String[] def = new java.lang.String[n];
        for (int i = 0; i < n; i++) {
            def[i] = nativeGetDefaultComponent(i);
        }
        defaultInfo = def;
        return def;
    } //buildDefault
    
    /** Accessors function */
    public java.lang.String[] getTransports() {
        java.lang.String[] cpy = new java.lang.String[info.length];
        for (int i = 0; i < cpy.length; i++) {
            cpy[i] = info[i];
        }
        return cpy;
    } //getTransports
    
    /* Need to reclaim native resources */
    protected final void finalize() throws java.lang.Throwable {
        nativeFinalizeTransportInfo();
    } //finalize
    
} //IluTransportInfo
