/*
Copyright (c) 1996-1997 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: cppgen.cpp,v 1.38 1997/09/21 23:50:37 srjohnso Exp $
*/

#ifdef __GNUC__
#pragma implementation "cppgen.hpp"
#endif  // __GNUC__

extern "C" {
#include <stdlib.h>
    #include <string.h>
    #include <time.h>
    #include <version.h>	// MED - from runtime/kernel

    #ifndef WIN32
        #include <sys/types.h>
        #include <sys/stat.h>
        #include <unistd.h>
        #include <pwd.h>
    #else
        #include <sys/types.h>
        #include <sys/stat.h>
    #endif
}  // extern "C"

#include "cppgen.hpp"
#include "cppparse.hpp"


CppGen(InterfaceScopingMode) CppGen(Namespace)::mode = CppGen(underscores);
const char * CppGen(Namespace)::name = NULL;

CppGen(BoolMode) CppGen(Bool)::mode = CppGen(integers);
ILUCPP_BOOL CppGen(Bool)::val = ILUCPP_FALSE;

CppGen(TemplateStaticMode) CppGen(TemplateStatic)::mode = CppGen(templateStaticPortable);

CppGen(CastMode) CppGen(Cast)::mode = CppGen(cCast);
const char * CppGen(Cast)::type = NULL;
const char * CppGen(Cast)::expression = NULL;



class Herald {

    friend CppParseStream(DynOutProc)* CppGen(herald)(const char *, const char *);

    static
    CppParseStream(ofstream)&
    doHerald(CppParseStream(ofstream)& ofs) {
        ofs << "/* This file was automatically generated by ILU (version "
            << ILU_VERSION_STRING << ") tools" << endl;
        ofs << " * at " << getCurrentTime() << " by " << getLogin() << endl;
        ofs << " * running " << executable << " of " << modTime(executable) << endl;
        ofs << " * on " << isl << " of " << modTime(isl) << endl;
        ofs << " *" << endl;
        ofs << " * ILU is Copyright 1991-1997 Xerox Corporation, "
            << "All Rights Reserved." << endl;
        ofs << " * ILU information:  "
            << "ftp://ftp.parc.xerox.com/pub/ilu/ilu.html." << endl;
        ofs << " */" << endl;
        
        return ofs;
    };

    // Note: GetCurrentTime, GetLogin, and ModTime exist within the parser
    // library, but are declared static and hidden. They are duplicated
    // here for this stubber's use.

    static
    const char *
    getCurrentTime () {
        time_t now;
        static char timebuf[30];

        time(&now);
        strcpy(timebuf, (char *) ctime(&now));
        timebuf[24] = '\0';
        return (timebuf);
    };

    static
    const char *
    getLogin () {
        #ifdef _IS_POSIX
            char *name;
            struct passwd *pw;
        
            if ((name = (char *) getlogin()) == NULL
                && (name = (char *) (((pw = getpwuid(getuid())) == NULL) ? NULL : pw->pw_name)) == NULL
                && (name = (char *) getenv("USER")) == NULL)
                return "nobody";
            else
                return name;
        #else
            return "nobody";
        #endif
    };

    static
    const char *
    modTime (const char * path) {
	    static char timebuf[30];

        #if defined(WIN32)
	        struct _stat statbuf;
        #else
	        struct stat statbuf;
        #endif

        #if defined(WIN32)
	        _stat(path, &statbuf);
        #else
	        stat(path, &statbuf);
        #endif

	    strcpy(timebuf, (char *) ctime(&statbuf.st_mtime));
	    timebuf[24] = '\0';
	    return (timebuf);
    };

    static const char * executable;
    static const char * isl;

};

const char * Herald::executable = NULL;
const char * Herald::isl = NULL;


CppParseStream(DynOutProc) *
CppGen(herald) (const char * executable, const char * isl) {
    Herald::executable = executable;
    Herald::isl = isl;
    return (&Herald::doHerald);
};


CppParseStream(DynOutProc) *
CppGen(Namespace)::open (const char * nsName) {
    name = nsName;
    return (&CppGen_(Namespace)::doOpen);
};

CppParseStream(DynOutProc) *
CppGen(Namespace)::close (const char * nsName) {
    name = nsName;
    return (&CppGen_(Namespace)::doClose);
};

CppParseStream(DynOutProc) *
CppGen(Namespace)::declareExtern () {
    return (&CppGen_(Namespace)::doDeclareExtern);
};

CppParseStream(ofstream)&
CppGen(Namespace)::doOpen (CppParseStream(ofstream)& ofs) {
    switch (mode) {
    case CppGen_(interfacePortable):
        ofs << "#define " << name << "_(name) NAME_INSIDE_SCOPE(" <<
            name << ", name)" << endl;
        ofs << "#define " << name << "(name) NAME_OUTSIDE_SCOPE(" <<
            name << ", name)" << endl;
        ofs << endl;
        ofs << "BEGIN_NAMESPACE(" << name << ")";
        break;
    case CppGen_(namespaces):
// TMP 9/21        ofs << "namespace " << name << "{";
        ofs << "namespace " << name << " {";  // TMP 9/21: NEW
        break;
    case CppGen_(classes):
        ofs << "class " << name << " { public:  // Open Namespace " << name;
        break;
    default:  // underscores
        ofs << "// Open Namespace " << name;
    };
    ofs << endl;
    return ofs;
};


CppParseStream(ofstream)&
CppGen(Namespace)::doClose (CppParseStream(ofstream)& ofs) {
    switch (mode) {
    case CppGen_(interfacePortable):
        ofs << "END_NAMESPACE;  // " << name;
        break;
    case CppGen_(namespaces):
    case CppGen_(classes):
        ofs << "};  ";
        break;
    default:  // underscores
        ofs << "// Open Namespace " << name;
    };
    ofs << endl;
    return ofs;
};


CppParseStream(ofstream)&
CppGen(Namespace)::doDeclareExtern (CppParseStream(ofstream)& ofs) {
    switch (mode) {
    case CppGen_(interfacePortable):
        ofs << "NS_EXTERN";
        break;
    case CppGen_(classes):
        ofs << "static";
        break;
    default:
        ofs << "extern";
    };
    return ofs;
};


CppParseStream(ofstream)&
CppGen(TemplateStatic)::doDeclareStatic (CppParseStream(ofstream)& ofs) {
    switch (mode) {
    case CppGen_(templateStaticPortable):
        ofs << "TEMPLATE_STATIC";
        break;
    case CppGen_(staticStorage):
        ofs << "static";
        break;
    default:
        ofs << "/* static */";
    };
    return ofs;
};

    
CppParseStream(DynOutProc) *
CppGen(Bool)::
type () {
    return (&CppGen_(Bool)::doType);
};

void
CppGen(Bool)::
post () {
    static CppGen(Bool) boolInstance;
    CppParse(Bool)::set(&boolInstance);
};


CppParseStream(DynOutProc) *
CppGen(Bool)::
value (ILUCPP_BOOL b) {
    val = b;
    return (&CppGen_(Bool)::doValue);
};

CppParseStream(ofstream)&
CppGen(Bool)::
doValue (CppParseStream(ofstream)& ofs) {
    ofs << (val ? CppParse(Bool)::trueValue() : CppParse(Bool)::falseValue());
    return ofs;
};

CppParseStream(ofstream)&
CppGen(Bool)::
doType (CppParseStream(ofstream)& ofs) {
    switch (mode) {
    case CppGen_(boolPortable):
        ofs << "ILUCPP_BOOL";
        break;
    case CppGen_(boolType):
        ofs << "bool";
        break;
    default:  // integers
        ofs << "int";
    };
    return ofs;
};

const char *
CppGen(Bool)::
_trueValue () {
    static char rtnPortable[] = "ILUCPP_TRUE";
    static char rtnBoolType[] = "true";
    static char rtnInt[] = "1";
    const char * rtn;
    switch (mode) {
    case CppGen_(boolPortable):
        rtn = rtnPortable;
        break;
    case CppGen_(boolType):
        rtn = rtnBoolType;
        break;
    default:  // integers
        rtn = rtnInt;
        break;
    };
    return rtn;
};

const char *
CppGen(Bool)::
_falseValue () {
    static char rtnPortable[] = "ILUCPP_FALSE";
    static char rtnBoolType[] = "false";
    static char rtnInt[] = "0";
    const char * rtn;
    switch (mode) {
    case CppGen_(boolPortable):
        rtn = rtnPortable;
        break;
    case CppGen_(boolType):
        rtn = rtnBoolType;
        break;
    default:  // integers
        rtn = rtnInt;
        break;
    };
    return rtn;
};


CppParseStream(DynOutProc) *
CppGen(Cast)::
staticCast (const char * targetType, const char * expr) {
    type = targetType;
    expression = expr;
    return (&CppGen_(Cast)::doStaticCast);
};

CppParseStream(DynOutProc) *
CppGen(Cast)::
reinterpretCast (const char * targetType, const char * expr) {
    type = targetType;
    expression = expr;
    return (&CppGen_(Cast)::doReinterpretCast);
};

CppParseStream(DynOutProc) *
CppGen(Cast)::
constCast (const char * targetType, const char * expr) {
    type = targetType;
    expression = expr;
    return (&CppGen_(Cast)::doConstCast);
};

CppParseStream(ofstream)&
CppGen(Cast)::
doStaticCast (CppParseStream(ofstream)& ofs) {
    switch (mode) {
    case CppGen_(castPortable):
        ofs << "STATIC_CAST("  << type << ", ";
        break;
    case CppGen_(cppCast):
        ofs << "STATIC_cast<" << type << ">(";
        break;
    default:  // cCast
        ofs << "(" << type << ")(";
    };
    if (expression != NULL)
        ofs << expression << ")";
    return ofs;
};

CppParseStream(ofstream)&
CppGen(Cast)::
doReinterpretCast (CppParseStream(ofstream)& ofs) {
    switch (mode) {
    case CppGen_(castPortable):
        ofs << "REINTERPRET_CAST("  << type << ", ";
        break;
    case CppGen_(cppCast):
        ofs << "reinterpret_cast<" << type << ">(";
        break;
    default:  // cCast
        ofs << "(" << type << ")(";
    };
    if (expression != NULL)
        ofs << expression << ")";
    return ofs;
};

CppParseStream(ofstream)&
CppGen(Cast)::
doConstCast (CppParseStream(ofstream)& ofs) {
    switch (mode) {
    case CppGen_(castPortable):
        ofs << "CONST_CAST("  << type << ", ";
        break;
    case CppGen_(cppCast):
        ofs << "const_cast<" << type << ">(";
        break;
    default:  // cCast
        ofs << "(" << type << ")(";
    };
    if (expression != NULL)
        ofs << expression << ")";
    return ofs;
}


CppGen(Type)::
CppGen_(Type) (::iluptype::Type from)
  : CppParse(Type)(from),
    CppParseName(TypeName)(from),
    CppParseName(Name)(from)
{
}

ILUCPP_BOOL
CppGen(Type)::
needsSurrogateSideCleanup () const {
    return ILUCPP_FALSE;
}

ILUCPP_BOOL
CppGen(Type)::
needsPostTrueMethodRevise (CppParseName(TypeUsage)) const {
    return ILUCPP_FALSE;
}


CppGen(Member)::
CppGen_(Member) (::iluptype::Argument from)
:   CppParse(NamedValue)(from, CppParseName(recordMember)),
    CppGen_(NamedValue)(from, CppParseName(recordMember)),
    CppParse(Member)(from)
{
}


CppGen(Enumerator)::
CppGen_(Enumerator) (::iluptype::EnumField from)
: CppParse(Enumerator)(from)
{
}

CppGen(Enumeration)::
CppGen_(Enumeration) (::iluptype::Type from)
  : CppParse(Type)(from),
    CppGen_(Type)(from),
    CppParse(Enumeration)(from),
    CppParseName(TypeName)(from),
    CppParseName(Name)(from)
{
}


static const char elementName[] = "_element";  // TMP 9/8: NEW

CppGen(SequenceElement)::  // TMP 9/9: NEW
CppGen_(SequenceElement) (const CppGen_(Sequence) * _sequence_)
  : CppGen_(NamedValue)(_sequence_),
    CppParse(NamedValue)(CppParseName(Name)(elementName, NULL), CppParseName(element), _sequence_),
	_sequence(_sequence_) {
}

#ifdef _MSC_VER
    #pragma warning(disable: 4355)  // MSVC4.1 Compiler Note #2
#endif  // _MSC_VER

CppGen(Sequence)::
CppGen_(Sequence) (::iluptype::Type from)
: CppParse(Type)(from),
  CppGen_(Type)(from),
  CppParse(Sequence)(from),
  CppParseName(Name)(from),
  CppParseName(TypeName)(from),
  element(this)  // TMP 9/9: NEW
/* TMP 7/4
  _containsObjects(CppGen_(Type)::narrow(elementType())->containsObjects())
*/
{
    #ifdef __SUNPRO_CC  // SunPro4.1 Compiler Note #1
        CppParse(Type)::reInit(from);
        // Do we need a special reInit to deal with _members ?
    #endif  // __SUNPRO_CC
}

#ifdef _MSC_VER
    #pragma warning(default: 4355)  // MSVC4.1 Compiler Note #2
#endif  // _MSC_VER


static  // TMP 7/23: NEW
ILUCPP_BOOL
containsObjectsTypeEnumProc (const CppParse(Type) * type, void * untyped_state) {
// CppParse::TypeEnumProc
    ILUCPP_BOOL *const objectFound = STATIC_CAST(ILUCPP_BOOL*, untyped_state);
    if (CppGen(Type)::narrow(type)->needsSurrogateSideCleanup())
        *objectFound = ILUCPP_TRUE;
    return !(*objectFound);
}

ILUCPP_BOOL
CppGen(Sequence)::
needsSurrogateSideCleanup () const {
/* TMP 7/4
    return _containsObjects;
*/
// TMP 7/23    return CppGen_(Type)::narrow(elementType())->containsObjects();  // TMP 7/4: NEW
    ILUCPP_BOOL rtn = ILUCPP_FALSE;  // TMP 7/23: NEW
// TMP 7/27    elementType()->enumerateContained(containsObjectsTypeEnumProc, &rtn);  // TMP 7/23: NEW
    enumerateContained(containsObjectsTypeEnumProc, &rtn);  // TMP 7/27: NEW
    return rtn;  // TMP 7/23: NEW
}

ILUCPP_BOOL
CppGen(Sequence)::
needVarBuffer () const {
    return ILUCPP_FALSE;
}

CppParseStream(ofstream) &
CppGen(Sequence)::
_dataElementType (CppParseStream(ofstream) & ofs) {
// TMP 9/21    ofs << elementType()->name(scope());
	/*
	   TEMP: it would be better to have a CppParseName::Scope* parameter to pass
	   along in the call to name below
	*/
    ofs << elementType()->name();  // TMP 9/21
    return ofs;
};


CppGen(ObjectSequence)::
CppGen_(ObjectSequence) (::iluptype::Type from)
  : CppParse(Sequence)(from),
    CppParse(Type)(from),
    CppGen_(Sequence)(from),
    CppParse(ObjectSequence)(from),
    CppParseName(TypeName)(from),
    CppParseName(Name)(from)
{
}

CppParseStream(ofstream) &
CppGen(ObjectSequence)::
_dataElementType (CppParseStream(ofstream) & ofs) {
// TMP 9/21    ofs << elementType()->usageName(CppParseName(ptr), scope());
	/*
	   TEMP: it would be better to have a CppParseName::Scope* parameter to pass
	   along in the call to name below
	*/
    ofs << elementType()->usageName(CppParseName(ptr));  // TMP 9/21
    return ofs;
};

ILUCPP_BOOL
CppGen(ObjectSequence)::
needVarBuffer () const {
    return ILUCPP_TRUE;
}

CppGen(StringSequence)::
CppGen_(StringSequence) (::iluptype::Type from)
  : CppParse(Sequence)(from),
    CppParse(Type)(from),
    CppGen_(Sequence)(from),
    CppParse(StringSequence)(from),
    CppParseName(TypeName)(from),
    CppParseName(Name)(from)
{
}

ILUCPP_BOOL
CppGen(StringSequence)::
needVarBuffer () const {
    return ILUCPP_TRUE;
}

/* TMP 9/9
CppParseStream(ofstream) &
CppGen(StringSequence)::
_dataElementType (CppParseStream(ofstream) & ofs) {
    ofs << CppParseName(CorbaString_var)()->name();
    return ofs;
};
TMP 9/9 */

CppGen(WideStringSequence)::
CppGen_(WideStringSequence) (::iluptype::Type from)
  : CppParse(Sequence)(from),
    CppParse(Type)(from),
    CppGen_(Sequence)(from),
    CppParse(WideStringSequence)(from),
    CppParseName(TypeName)(from),
    CppParseName(Name)(from)
{
}

ILUCPP_BOOL
CppGen(WideStringSequence)::
needVarBuffer () const {
    return ILUCPP_TRUE;
}

/* TMP 9/9
CppParseStream(ofstream) &
CppGen(WideStringSequence)::
_dataElementType (CppParseStream(ofstream) & ofs) {
    // TEMP: don't know yet what this should be
    return ofs;
};
TMP 9/9 */

CppGen(String)::
CppGen_(String) (::iluptype::Type from)
  : CppParse(Type)(from),
    CppGen_(Type)(from),
    CppParse(String)(from),
    CppParseName(TypeName)(from),
    CppParseName(Name)(from)
{
}

ILUCPP_BOOL
CppGen(String)::
needsPostTrueMethodRevise (CppParseName(TypeUsage) usage) const {
    return (usage == CppParseName(out) || usage == CppParseName(inOut) || usage == CppParseName(returnVal));
}

CppGen(WideString)::
CppGen_(WideString) (::iluptype::Type from)
  : CppParse(Type)(from),
    CppGen_(Type)(from),
    CppParse(WideString)(from),
    CppParseName(TypeName)(from),
    CppParseName(Name)(from)
{
}

ILUCPP_BOOL
CppGen(WideString)::
needsPostTrueMethodRevise (CppParseName(TypeUsage) usage) const {
    return (usage == CppParseName(out) || usage == CppParseName(inOut) || usage == CppParseName(returnVal));
}


/* TMP 7/24
static
ILUCPP_BOOL
containsObjects (const CppParse(MemberList) & members) {
    CppParse(MemberListIter) memberListIter(members);
    ILUCPP_BOOL rtn = ILUCPP_FALSE;
    const CppParse(Member) * member;
    while ((member = memberListIter.next()) != NULL)
        if ((CppGen(Type)::narrow(member->type()))->containsObjects()) {
            rtn = ILUCPP_TRUE;
            break;
        };
    return rtn;
};
*/

CppGen(Record)::
CppGen_(Record) (::iluptype::Type from)
: CppParse(Type)(from),
  CppGen_(Type)(from),
  CppParse(Record)(from),
  CppParseName(Name)(from),
  CppParseName(TypeName)(from)  // TEMP 4/28 NEW
// TMP 7/4  _containsObjects(::containsObjects(members()))
{
}

ILUCPP_BOOL
CppGen(Record)::
needsSurrogateSideCleanup () const {
// TMP 7/4    return _containsObjects;
// TMP 7/24    return ::containsObjects(members());  // TMP 7/4: NEW
    ILUCPP_BOOL rtn = ILUCPP_FALSE;  // TMP 7/23: NEW
    enumerateContained(containsObjectsTypeEnumProc, &rtn);  // TMP 7/23: NEW
    return rtn;  // TMP 7/23: NEW
};


CppGen(ConstantValue)::
CppGen_(ConstantValue) (::iluptype::ConstantValue from)
:   CppParse(ConstantValue)(from)
{
}


CppGen(UnionArm)::
CppGen_(UnionArm) (::iluptype::Argument from)
:   CppGen_(NamedValue)(from, CppParseName(unionMember)),
    CppParse(NamedValue)(from, CppParseName(unionMember)),
    CppParse(UnionArm)(from)
{
}


CppGen(Union)::
CppGen_(Union) (::iluptype::Type from)
:   CppParse(Type)(from),
    CppParse(Record)(from),
    CppGen(Record)(from),
    CppParse(Union)(from),
    CppParseName(TypeName)(from),
    CppParseName(Name)(from)
{
}


CppGen(Alias)::
CppGen_(Alias) (::iluptype::Type from)
:   CppParse(Type)(from),
    CppGen_(Type)(from),
    CppParse(Alias)(from),
    CppParseName(TypeName)(from),
    CppParseName(Name)(from)
{
}


CppGen(ArrayDimension)::
CppGen_(ArrayDimension) (long unsigned from)
: CppParse(ArrayDimension)(from)
{
}


/* TMP 9/8
CppGen(ArrayElement)::
CppGen_(ArrayElement) (const CppGen_(Array) * _array_)
  : CppGen_(NamedValue)(_array), CppParse(NamedValue)(*_array_, CppParseName(element), _array_), _array(_array_) {
}
TMP 9/8 */

CppGen(ArrayElement)::  // TMP 9/8: NEW
CppGen_(ArrayElement) (const CppGen_(Array) * _array_)
  : CppGen_(NamedValue)(_array),
    CppParse(NamedValue)(CppParseName(Name)(elementName, NULL), CppParseName(element), _array_),
	_array(_array_) {
}

#ifdef _MSC_VER
    #pragma warning(disable: 4355)  // MSVC4.1 Compiler Note #2
#endif  // _MSC_VER

    CppGen(Array)::
    CppGen_(Array) (::iluptype::Type from)
    : 
      CppParse(Type)(from),
      CppGen_(Type)(from),
      CppParse(Array)(from),
      CppParseName(Name)(from),
      CppParseName(TypeName)(from),
      element(this)
// TMP 7/4      _containsObjects(CppGen_(Type)::narrow(elementType())->containsObjects())
    {
    }

#ifdef _MSC_VER
    #pragma warning(default: 4355)  // MSVC4.1 Compiler Note #2
#endif  // _MSC_VER

ILUCPP_BOOL
CppGen(Array)::
needsSurrogateSideCleanup () const {
// TMP 7/4    return _containsObjects;
// TMP 7/23    return CppGen_(Type)::narrow(elementType())->containsObjects();  // TMP 7/4: NEW
    ILUCPP_BOOL rtn = ILUCPP_FALSE;  // TMP 7/23: NEW
// TMP 7/27    elementType()->enumerateContained(containsObjectsTypeEnumProc, &rtn);  // TMP 7/23: NEW
    enumerateContained(containsObjectsTypeEnumProc, &rtn);  // TMP 7/27: NEW
    return rtn;  // TMP 7/23: NEW
}

ILUCPP_BOOL
CppGen(Array)::
needsPostTrueMethodRevise (CppParseName(TypeUsage) usage) const {
// TMP 7/15    return (usage == CppParseName(out) && variableLength());
    return ILUCPP_FALSE;  // TMP 7/15
}


#ifdef _MSC_VER
    #pragma warning(disable: 4355)  // MSVC4.1 Compiler Note #2
#endif  // _MSC_VER

    CppGen(Optional)::
    CppGen_(Optional) (::iluptype::Type from)
    : 
      CppParse(Type)(from),
      CppGen_(Type)(from),
      CppParseName(Name)(from),
      CppParseName(TypeName)(from),
      CppParse(Optional)(from)
    {
    }

#ifdef _MSC_VER
    #pragma warning(default: 4355)  // MSVC4.1 Compiler Note #2
#endif  // _MSC_VER

ILUCPP_BOOL
CppGen(Optional)::
needsSurrogateSideCleanup () const {
// TMP 7/23    return CppGen_(Type)::narrow(valueType())->containsObjects();
    ILUCPP_BOOL rtn = ILUCPP_FALSE;  // TMP 7/23: NEW
// TMP 7/27    valueType()->enumerateContained(containsObjectsTypeEnumProc, &rtn);  // TMP 7/23: NEW
    enumerateContained(containsObjectsTypeEnumProc, &rtn);  // TMP 7/27: NEW
    return rtn;  // TMP 7/23: NEW
}

ILUCPP_BOOL
CppGen(Optional)::
needsPostTrueMethodRevise (CppParseName(TypeUsage) usage) const {
    return CppGen_(Type)::narrow(valueType())->needsPostTrueMethodRevise(usage);
}


CppGen(Object)::
CppGen_(Object) (::iluptype::Type from)
  : CppParse(Type)(from),
    CppGen(Type)(from),
    CppParse(Object)(from),
    CppParseName(TypeName)(from),
    CppParseName(Name)(from)
{
}

ILUCPP_BOOL
CppGen(Object)::
needsSurrogateSideCleanup () const {
    return ILUCPP_TRUE;
}

ILUCPP_BOOL
CppGen(Object)::
needsPostTrueMethodRevise (CppParseName(TypeUsage) usage) const {
    return (usage == CppParseName(out) || usage == CppParseName(inOut) || usage == CppParseName(returnVal));
}


CppGen(Import)::
CppGen_(Import) (::iluptype::Imported from)
  :  CppParse(Import)(from)
{
}


CppGen(Interface)::
CppGen_(Interface) (::iluptype::Interface from)
: CppParse(Interface)(from), CppParseName(Name)(from) {
// TMP 6/14	CppParse(ObjectListIter) objs(objects());
    CppParse(ObjectListIter) objs(objects());  // TMP 6/14: NEW
	const CppGen_(Object) * obj;
// TMP 6/14	CppParse(ExceptionListIter) excps(exceptions());
// TMP 6/14	const CppGen_(Exception) * excp;
    int num;
	while ((obj = CppGen_(Object)::narrow(objs.next())) != NULL) {
		CppParse(ProcedureListIter) procs(obj->procedures());
		const CppGen_(Procedure) * proc;
		num = 0;
		while ((proc = CppGen_(Procedure)::narrow(procs.next())) != NULL)
			(CONST_CAST(CppGen_(Procedure)*, proc))->_methodNum = num++;
	};
/* TMP 6/14
    num = 0;
	while ((excp = CppGen_(Exception)::narrow(excps.next())) != NULL)
        (CONST_CAST(CppGen_(Exception)*, excp))->_exceptionNum = num++;
*/
}


#ifdef _MSC_VER
    #pragma warning(disable: 4355)  // MSVC4.1 Compiler Note #2
#endif  // _MSC_VER

    CppGen(ExceptionValue)::
    CppGen_(ExceptionValue) (::iluptype::Exception from)
      : CppGen_(NamedValue)(from),
        CppParse(NamedValue)(from),
        CppParse(ExceptionValue)(from)
    {
    }

#ifdef _MSC_VER
    #pragma warning(default: 4355)  // MSVC4.1 Compiler Note #2
#endif  // _MSC_VER


#ifdef _MSC_VER
    #pragma warning(disable: 4355)  // MSVC4.1 Compiler Note #2
#endif  // _MSC_VER

    CppGen(Exception)::
    CppGen_(Exception) (::iluptype::Exception from)
    :   CppParseName(Name)(from),
        CppParse(Exception)(from)
    {
    }

#ifdef _MSC_VER
    #pragma warning(default: 4355)  // MSVC4.1 Compiler Note #2
#endif  // _MSC_VER


void
CppGen(Exception)::
indexName (const CppParseName(Scope) * context, CppParseStream(ofstream) & ofs) const {

    // all exception index names begin with this
    ofs << "_ilu_nsconst_";

    if (context != NULL) {
        
        const CppParseName(Scope) * contextTop;  // highest scope (Interface) above context
        for (contextTop = context; contextTop->scope() != NULL; contextTop = contextTop->scope());

        // determine if this exception is defined in
        // tree below highest scope
        const CppParseName(Scope) * parent;
        for (parent = scope(); parent != NULL && parent != contextTop; parent = parent->scope());

        // if not in same tree, append name of context's highest scope
        if (parent == NULL)
            ofs << contextTop->name() << "_";

    };

    // append fully-qualified name of this exception
    ofs << name(CppGen_(underscore_key)) << "_index";

    // guard against possibility of same-named exceptions defined
    // at top level (above all interfaces), and also within an interface
    if (scope() == NULL || context == NULL)
        ofs << "_";

}


CppGen(IDLException)::
CppGen_(IDLException) (::iluptype::Exception from)
: CppParseName(Name)(from),
  CppParse(Exception)(from),
  CppParse(IDLException)(from),
  CppGen_(Exception)(from)
{
}


CppGen(NamedValue)::
CppGen_(NamedValue) (::iluptype::Argument from)
: CppParse(NamedValue)(from) {
}

CppGen(NamedValue)::
CppGen_(NamedValue) (::iluptype::Argument from, CppParseName(TypeUsage) usage)
: CppParse(NamedValue)(from, usage) {
}

CppGen(NamedValue)::
CppGen_(NamedValue) (::iluptype::Procedure from)
: CppParse(NamedValue)(from) {
}

CppGen(NamedValue)::
CppGen_(NamedValue) (const CppGen_(Array) * array)
: CppParse(NamedValue)(*array, CppParseName(element), array) {
}

CppGen(NamedValue)::  // TMP 9/9: NEW
CppGen_(NamedValue) (const CppGen_(Sequence) * array)
: CppParse(NamedValue)(*array, CppParseName(element), array) {
}

CppGen(NamedValue)::
CppGen_(NamedValue) (const ::iluptype::Exception from)
: CppParse(NamedValue)(from) {
}

CppGen(NamedValue)::
CppGen_(NamedValue) (const CppParseName(Name)& name, CppParseName(TypeUsage) usage, const CppGen_(Type) * type)
: CppParse(NamedValue)(name, usage, type) {
}


CppGen(Parameter)::
CppGen_(Parameter) (::iluptype::Argument from)
: CppGen_(NamedValue)(from), CppParse(NamedValue)(from) {
}


CppGen(Parameter)::
CppGen_(Parameter) (::iluptype::Procedure from)
: CppGen_(NamedValue)(from), CppParse(NamedValue)(from) {
}

CppGen(Parameter)::
CppGen_(Parameter) (const CppParseName(Name)& name, CppParseName(TypeUsage) usage, const CppGen_(Type) * type)
: CppParse(NamedValue)(name, usage, type), CppGen_(NamedValue)(name, usage, type) {
}

ILUCPP_BOOL
CppGen(Parameter)::
sibling () const {
    const CppGen_(Argument) * arg = CppGen_(Argument)::narrow(this);
    return arg == NULL ? ILUCPP_FALSE : arg->CppParse_(Argument)::sibling();
}


CppGen(Argument)::
CppGen_(Argument) (::iluptype::Argument from)
: CppParse(Argument)(from), CppParse(NamedValue)(from), CppGen_(Parameter)(from)
{
}


CppGen(ReturnVal)::
CppGen_(ReturnVal) (::iluptype::Procedure from)
: CppParse(ReturnVal)(from), CppParse(NamedValue)(from), CppGen_(Parameter)(from)
{
}


CppGen(Procedure)::
CppGen_(Procedure) (::iluptype::Procedure from)
  : CppParse(Procedure)(from),
    CppParseName(Name)(from)  // TMP 7/3: NEW
{
}

int
CppGen(Procedure)::
methodNum () {
	return (_methodNum);
}


CppParse(IDLException) *  // TMP 5/30 NEW
CppGen_FactoryT<CppGen(IDLException), ::iluptype::Exception, CppParse(IDLException)>::  // TMP 5/30 NEW
_create (::iluptype::Exception from) const {  // TMP 5/30 NEW
  CppParse(IDLException) * rtn = new(from) CppGen(IDLException)(from);  // TMP 5/30 NEW
  return rtn;  // TMP 5/30 NEW
}  // TMP 5/30 NEW

CppParse(Object) *  // TMP 7/3 NEW
CppGen_FactoryT<CppGen(Object), ::iluptype::Type, CppParse(Object)>::  // TMP 7/3 NEW
_create (::iluptype::Type from) const {  // TMP 7/3 NEW
  CppParse(Object) * rtn = new(from) CppGen(Object)(from);  // TMP 7/3 NEW
  return rtn;  // TMP 7/3 NEW
}  // TMP 7/3 NEW

CppParse(Record) *  // TMP 7/20 NEW
CppGen_FactoryT<CppGen(Record), ::iluptype::Type, CppParse(Record)>::  // TMP 7/20 NEW
_create (::iluptype::Type from) const {  // TMP 7/20 NEW
  CppParse(Record) * rtn = new(from) CppGen(Record)(from);  // TMP 7/20 NEW
  return rtn;  // TMP 7/20 NEW
}  // TMP 7/20 NEW

CppParse(Union) *  // TMP 7/20 NEW
CppGen_FactoryT<CppGen(Union), ::iluptype::Type, CppParse(Union)>::  // TMP 7/20 NEW
_create (::iluptype::Type from) const {  // TMP 7/20 NEW
  CppParse(Union) * rtn = new(from) CppGen(Union)(from);  // TMP 7/20 NEW
  return rtn;  // TMP 7/20 NEW
}  // TMP 7/20 NEW

CppParse(Interface) *  // TMP 8/13 NEW
CppGen_FactoryT<CppGen(Interface), ::iluptype::Interface, CppParse(Interface)>::
_create (::iluptype::Interface from) const {
  CppParse(Interface) * rtn = new(from) CppGen(Interface)(from);
  return rtn;
}

template <class T, class FROM, class PARSET>
PARSET *
CppGen_FactoryT<T, FROM, PARSET>::
_create (FROM from) const {
  PARSET * rtn = new T(from);  // TEMP
  return rtn;  // TEMP
}

template <class X, class FROM, class PARSET>  // MSVC4.1 Compiler Note #1
void
CppGen_FactoryT<X, FROM, PARSET>::
_destroy (PARSET * destroyMe) const {
  delete X::narrow(destroyMe);
}



// G++2.7.1 Compiler Note #1, SunPro4.1 Compiler Note #1


#ifdef _MSC_VER

    #define INSTANTIATE_FACTORY(T, FROM, UNUSED1, UNUSED2, UNUSED3)          \
        template CppGen_FactoryT<CppGen(T), FROM, CppParse(T)>;              \
        CppGen_FactoryT<CppGen(T), FROM, CppParse(T)>                        \
        CppGen_FactoryT<CppGen(T), FROM, CppParse(T)>::_default;             \
        CppGen_FactoryT<CppGen(T), FROM, CppParse(T)> *                      \
        CppGen_FactoryT<CppGen(T), FROM, CppParse(T)>::_current = &_default;

    #pragma warning(disable: 4660)  // MSVC4.1 Compiler Note #1
        CppParse_ENUMERATE_CREATABLES(INSTANTIATE_FACTORY);
    #pragma warning(default: 4660)

#else

    #define INSTANTIATE_FACTORY(T, FROM, UNUSED1, UNUSED2, UNUSED3)          \
        CppGen_FactoryT<CppGen(T), FROM, CppParse(T)>                        \
        CppGen_FactoryT<CppGen(T), FROM, CppParse(T)>::_default;             \
        CppGen_FactoryT<CppGen(T), FROM, CppParse(T)> *                      \
        CppGen_FactoryT<CppGen(T), FROM, CppParse(T)>::_current = &_default;

    CppParse_ENUMERATE_CREATABLES(INSTANTIATE_FACTORY);

#endif  // _MSC_VER



void
CppGen(post) () {
    #define POST_FACTORY(T, FROM, UNUSED1, UNUSED2, UNUSED3)   \
        CppGen_FactoryT<CppGen(T), FROM, CppParse(T)>::post();
    CppParse_ENUMERATE_CREATABLES(POST_FACTORY);
    CppGen_(Bool)::post();
};


#define INSTANTIATE_NARROWABLE(T, FROM, UNUSED1, UNUSED2, UNUSED3) \
    int CppGen(T)::cid;

CppParse_ENUMERATE_CREATABLES(INSTANTIATE_NARROWABLE)


int CppGen(Parameter)::cid;



/*

    G++2.7.1 Compiler Note #1, SunPro4.1 Compiler Note #1 - Neither compiler supports the "automatic" instantiation/initialization of template class static members. So instead, we initialize separately for each class, with the help of a macro. Note that "INSTANTIATE_FACTORY" is really a misnomer; g++ uses the non-standard "#pragma interface" and "#pragma implementation" to determine where templates are instantiated.

    SunPro4.1 Compiler Note #1 - See note regarding "reInit" methods in cppparse.hpp.

    MSVC4.1 Compiler Note #1 - It's difficult to determine which template classes/class members will be automatically instantiated. So, we just explicitly instantiate everything. (C4660 is the compiler warning generated for multiply-instantiated templates).

    MSVC4.1 Compiler Note #2 - The compiler issues warning C4355 ("'this' : used in base member initializer list"). However, the ANSI C++ April, 1995 Working Draft (X3J16/95-0087; section 12.7, paragraph 2) implies that such use of "this" is legal.

*/
