/* Copyright (C) 1996-1997 Xerox Corporation.  All Rights Reserved.

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: cppgentrue.cpp,v 1.11 1997/08/13 19:12:58 srjohnso Exp $
*/

#include <string.h>

#include "cppgen.hpp"
#include "cppparse.hpp"
#include "cppparsestream.hpp"
#include "cppportability.hpp"


// TEMP should move this to some common place
class ReusableString {
public:
    ReusableString (int initialMaxLen = 100) {
        initialMaxLen = (initialMaxLen < 0) ? 0 : initialMaxLen;
        maxLen = 0;
        resize(initialMaxLen);
    }
    ~ReusableString () {
        if (str != NULL)
            delete [] str;
    }
    char * resize (int newMaxLen) {
        char * old = str;
        str = new char[(maxLen = newMaxLen) + 1];
        return old;
    }
    void strcpy (const char * from, int extraBytes = 100) {
        str[0] = '\0';
        strcat(from, extraBytes);
    }
    void strcat (const char * from, int extraBytes = 100) {
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        if (from == NULL)
            from = "";
        const int newLen = strlen(str) + strlen(from);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, from);
    }
    void ucat (unsigned long u, int extraBytes = 100) {
        #define CHARS_FOR_2E64 20  // string length needed for max 64-bit unsigned
        char num[CHARS_FOR_2E64 + 1];
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        sprintf(num, "%lu", u);
        const int newLen = strlen(str) + strlen(num);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, num);
    }
    char * str;
    int maxLen;
};


CppParseStream(ofstream) &
CppGen(Interface)::
_trueDef (CppParseStream(ofstream) & ofs) {

  const char * myName = NULL;
// TMP 6/14  CppParse(ObjectListIter) objectListIter(objects());
  CppParse(ObjectListIter) objectListIter(objects());  // TMP 6/14: NEW
  const CppGen_(Object) * object;

  if (definedIn == NULL) {
    myName = localName();
    ofs << "// Prevent multiple inclusions" << endl;
    ofs << "#ifndef __" << myName << "_cpptrue_hpp_" << endl;
    ofs << "#define __" << myName << "_cpptrue_hpp_" << endl;
    ofs << endl;
    ofs << "#include \"" << myName << "-cpp.hpp\"" << endl;
    ofs << endl;
  };

  ofs << CppGen_(Namespace)::open(name(CppGen_(true_key)));
  ofs.indent++;
  ofs << endl;

  while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) {
    ofs << object->trueDefInitializer();
    ofs << endl;
  };

  ofs.indent--;
  ofs << CppGen_(Namespace)::close(localName(CppGen_(true_key)));

  if (definedIn == NULL) {
    ofs << endl;
    ofs << "#endif // " << myName << "_cpptrue_hpp_" << endl;
  };
  return ofs;
}


CppParseStream(ofstream) &
CppGen(Object)::
_trueDefInitializer (CppParseStream(ofstream) & ofs) {

  static ReusableString tempStr;
  CppParseName(TempName) initializer;
  const char * initializer_local_name;

  tempStr.strcpy(simpleName());
  tempStr.strcat("_initializer");
  initializer.reset(tempStr.str, scope());
  initializer_local_name = initializer.localName(CppGen_(true_key));

  ofs << "class " << initializer_local_name << " {" << endl;
  ofs.indent++;

  ofs << "public:" << endl;
  ofs.indent++;
  ofs << initializer_local_name << " ();" << endl;
  ofs << "void* ensure_instantiation ();" << endl;
  ofs << "static " << initializer_local_name << " sm_the_true_" << simpleName()
      << "_initializer;" << endl;
  ofs.indent--;

  ofs << "private:" << endl;
  ofs.indent++;
  ofs << "static void iluInitialize ();" << endl;
  ofs << "// set to 1 once initialization has occured." << endl;
  ofs << "static int initialized;" << endl;
  ofs.indent--;

  ofs.indent--;
  ofs << "};" << endl;

  return ofs;
}


CppParseStream(ofstream) &
CppGen(Interface)::
_trueImpl (CppParseStream(ofstream) & ofs) {

// TMP 6/14  CppParse(ObjectListIter) objectListIter(objects());
  CppParse(ObjectListIter) objectListIter(objects());  // TMP 6/14: NEW
  CppParse(ExceptionListIter) exceptionListIter(exceptions());
  CppParse(ExceptionListIter) importedExceptionListIter(importedExceptions());  // TMP 6/15: NEW
  const CppGen_(Object) * object;
  const CppGen_(Exception) * exception;

  ofs << "#include \"" << localName() << "-cpptrue.hpp\"" << endl;
  ofs << "#include \"optionaltemplates.hpp\"  // TMP 6/28" << endl;
  ofs << endl;

  ofs << "// Globals and statics" << endl;
  ofs << endl;
  while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) {
    ofs << object->trueImplInitializerInstantiation();
    ofs << endl;
  };

  ofs << "// Exception Forwarding" << endl;
  ofs << endl;
  while ((exception = CppGen_(Exception)::narrow(exceptionListIter.next())) != NULL) {
// TMP 6/14    ofs << exception->trueImplSend();
    exception->trueImplSend(this, ofs);  // TMP 6/14
    ofs << endl;
  };
  while ((exception = CppGen_(Exception)::narrow(importedExceptionListIter.next())) != NULL) {  // TMP 6/15: NEW
    exception->trueImplSend(this, ofs);  // TMP 6/15: NEW
    ofs << endl;  // TMP 6/15: NEW
  };  // TMP 6/15: NEW

  ofs << "// Method Stubs" << endl;
  ofs << endl;
  objectListIter.reset();
  while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) {
    CppParse(ProcedureListIter) procListIter(object->procedures());
    const CppGen_(Procedure) * proc;
    procListIter.reset();
    while ((proc = CppGen_(Procedure)::narrow(procListIter.next())) != NULL) {
      ofs << proc->trueImpl();
      ofs << endl;
    };
    ofs << endl;
  };

  ofs << "// Class Initializers" << endl;
  ofs << endl;
  objectListIter.reset();
  while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) {
    ofs << object->trueImplInitializer();
    ofs << endl;
  };

  return ofs;
}


CppParseStream(ofstream) &
CppGen(Object)::
_trueImplInitializer (CppParseStream(ofstream) & ofs) {

  CppParse(ProcedureListIter) procListIter(procedures());
  const CppGen_(Procedure) * proc;
  static ReusableString initializer_simple_name;
  CppParseName(TempName) initializer;
  CppParseName(TempName) initialization_function_list(
	  "_initialization_function_list",
	  scope());
  unsigned methodIndex;

  initializer_simple_name.strcpy(simpleName());
  initializer_simple_name.strcat("_initializer");
  initializer.reset(initializer_simple_name.str, scope());

  ofs << initializer.name(CppGen_(true_key)) << "::" << endl;
  ofs << initializer.localName(CppGen_(true_key)) << " () {" << endl;
  ofs.indent++;
  ofs << "iluCppInternal::iluAddInitializationFunction(" << endl;
  ofs.indent++;
  ofs << "&" << initialization_function_list.name(this) << "," << endl;
  ofs << "iluInitialize" << endl;
  ofs.indent--;
  ofs << ");" << endl;
  ofs.indent--;
  ofs << "}" << endl;
  ofs << endl;

  ofs << "void*" << endl;
  ofs << initializer.name(CppGen_(true_key)) << "::" << endl;
  ofs << "ensure_instantiation () {" << endl;
  ofs.indent++;
  ofs << "return this;" << endl;
  ofs.indent--;
  ofs << "}" << endl;
  ofs << endl;

  ofs << "void" << endl;
  ofs << initializer.name(CppGen_(true_key)) << "::" << endl;
  ofs << "iluInitialize () {" << endl;
  ofs.indent++;
  ofs << "if (initialized == 1)" << endl;
  ofs.indent++;
  ofs << "return;" << endl;
  ofs.indent--;
  procListIter.reset();
  methodIndex = 0;
  while ((proc = CppGen_(Procedure)::narrow(procListIter.next())) != NULL) {
    static ReusableString stubProcName;
    stubProcName.strcpy(proc->name(CppGen_(underscore_key)));
    stubProcName.strcat("_stub");
    ofs << "ilu_SetMethodStubProc(" << endl;
    ofs.indent++;
    ofs << this->name() << "::iluGetILUClassRecord()->cl_methods + "
      << methodIndex << "," << endl;
    ofs << CppGen_(Cast)::staticCast("ilu_StubProc", stubProcName.str) << "," << endl;
    ofs << "iluCppInternal::iluGetCppLanguageIndex()" << endl;
    ofs.indent--;
    ofs << ");" << endl;
    methodIndex++;
  };
  ofs << "initialized = 1;" << endl;
  ofs.indent--;
  ofs << "}" << endl;
  ofs << endl;

  return ofs;

}

CppParseStream(ofstream) &
CppGen(Object)::
_trueImplInitializerInstantiation (CppParseStream(ofstream) & ofs) {

  static ReusableString initializer_simple_name;
  CppParseName(TempName) initializer;

  initializer_simple_name.strcpy(simpleName());
  initializer_simple_name.strcat("_initializer");
  initializer.reset(initializer_simple_name.str, scope());

  ofs << "int " << initializer.name(CppGen_(true_key)) << "::initialized;"
    << endl;
  ofs << initializer.name(CppGen_(true_key)) << " "
      << initializer.name(CppGen_(true_key));
  ofs << "::sm_the_true_" << simpleName()
      << "_initializer;" << endl;

  return ofs;

}


CppParseStream(ofstream) &
CppGen(Procedure)::
_trueImpl (CppParseStream(ofstream) & ofs) {
    
    const CppGen_(Object) * obj = CppGen_(Object)::narrow(object());
    const CppGen_(ReturnVal) * return_val = CppGen_(ReturnVal)::narrow(returnVal());
    const CppParse(ExceptionList) excps = exceptions();
    CppParse(ArgumentListIter) argListIter(arguments());
    CppParse(ExceptionListIter) exceptionListIter(excps);
    unsigned long nInArgs = 0;   // number of in & inOut arguments
    unsigned long nOutArgs = 0;  // number of out & inOut arguments
    const CppGen_(Argument) * arg;
    const CppParse(Exception) * exception;
    
    // begin function
    ofs << "static" << endl;
    ofs << "void" << endl;
    ofs << name(CppGen_(underscore_key)) << "_stub (iluCall _iluCall) {" << endl;
    ofs.indent++;
    ofs << endl;

    // Let ILU know whether we might raise exceptions
    ofs << "iluTrueCall _call(_iluCall, " << CppGen_(Bool)::value(excps.count() > 0) << ");" << endl;
    ofs << endl;

    // Begin try block
    ofs << "try {" << endl;
    ofs.indent++;
    ofs << endl;

    ofs << obj->usageName(CppParseName(ptr)) << " _trueObject;" << endl;

    // declare discriminator  // TMP 7/1
    ofs << "iluObjectWrapper _discriminator(" << CppGen_(Bool)::value(ILUCPP_TRUE) << ", " << obj->name()  // TMP 7/1
        << "::iluGetILUClassRecord());" << endl;  // TMP 7/1
    
    // definitions for each arg and return value, if any
    argListIter.reset();
    while ((arg = CppGen_(Argument)::narrow(argListIter.next())) != NULL) {
        switch (arg->usage()) {
        case CppParseName(inOut):
            nOutArgs++;
        case CppParseName(in):
            ofs << arg->initialDeclsInput();
            nInArgs++;
            break;
        default:  // CppParse::out
            ofs << arg->initialDeclsOutput();
            nOutArgs++;
            break;
        };
    };
    if (return_val->type() != NULL)
            ofs << return_val->initialDeclsOutput();
    

/* TMP 7/1
    // declare discriminator
    ofs << "iluObjectWrapper _discriminator(" << CppGen_(Bool)::value(ILUCPP_TRUE) << ", " << obj->name()
        << "::iluGetILUClassRecord());" << endl;
    ofs << endl;
*/
    
    // read in discriminator
    ofs << endl;  // TMP 7/1
    ofs << "// Read in discriminator" << endl;
    ofs << "_call >> _discriminator;" << endl;
    ofs << "_trueObject = "
        << CppGen_(Cast)::reinterpretCast(obj->usageName(CppParseName(ptr)), "_discriminator.m_pv_iluobject") << ";"
        << endl;
    ofs << endl;

    // read in arguments
    if (nInArgs > 0) {
        ofs << "// Read in arguments" << endl;
        argListIter.reset();
        while ((arg = CppGen_(Argument)::narrow(argListIter.next())) != NULL) {
            const CppParseName(TypeUsage) dir = arg->usage();
            if ((dir == CppParseName(in)) || (dir == CppParseName(inOut)))
                ofs << arg->trueReceive();
        };
    };
    ofs << "_call << iluParametersFinishedMode;" << endl;
    ofs << endl;

    // invoke method on true object
    ofs << "// Invoke actual method" << endl;
    if (return_val->type() != NULL)
    ofs << return_val->localName() << " = ";
    if (arguments().count() == 0)
        ofs << "_trueObject->" << localName() << "();" << endl;
    else {
        ofs << "_trueObject->" << localName() << "(" << endl;
        ofs.indent++;
        argListIter.reset();
        ILUCPP_BOOL firstArg = ILUCPP_TRUE;
        while ((arg = CppGen_(Argument)::narrow(argListIter.next())) != NULL) {
            if (firstArg)
                firstArg = ILUCPP_FALSE;
            else
                ofs << ", " << endl;
            ofs << arg->truePassToTrueMethod();
        };
        ofs.indent--;
        ofs << endl;
        ofs << ");" << endl;
    };
    ofs << endl;

    // perform post-call agument processing
    argListIter.reset();
    while ((arg = CppGen_(Argument)::narrow(argListIter.next())) != NULL) {
// TMP 6/29        if ((arg->usage() == CppParseName(out)) || (arg->usage() == CppParseName(inOut)))
        if (arg->usage() == CppParseName(out) ||  // TMP 6/29: NEW
            arg->usage() == CppParseName(inOut) ||  // TMP 6/29: NEW
            CppGen_(Type)::narrow(arg->type())->needsPostTrueMethodRevise(arg->usage()))  // TMP 6/29: NEW
            ofs << arg->truePostTrueMethodProcessing();
    };
    if (return_val->type() != NULL)
        ofs << return_val->truePostTrueMethodProcessing();

    if (!asynch()) {  // TEMP: perhaps we need to check against nOutArgs & return_val->type() as well
        
        // do sizing for reply
        if ((return_val->type() != NULL) || (nOutArgs > 0)) {
            ofs << endl;
            ofs << "// Size return" << endl;
            ofs << "if (_call.iluNeedsSizing()) {" << endl;
            ofs.indent++;
            ofs << "_call << iluSizeReplyMode;" << endl;
            if (return_val->type() != NULL)
                ofs << return_val->sizing();
            argListIter.reset();
            while ((arg = CppGen_(Argument)::narrow(argListIter.next())) != NULL) {
                const CppParseName(TypeUsage) dir = arg->usage();
                if ((dir == CppParseName(out)) || (dir == CppParseName(inOut)))
                    ofs << arg->sizing();
            };
            ofs.indent--;
            ofs << "};" << endl;
        };
        
        // send reply (must go into SendReplyMode even if there is nothing to return)
        ofs << endl;
        ofs << "// Send reply" << endl;
        ofs << "_call << iluSendReplyMode;" << endl;
        if (return_val->type() != NULL)
            ofs << return_val->send();
        argListIter.reset();
        while ((arg = CppGen_(Argument)::narrow(argListIter.next())) != NULL) {
            const CppParseName(TypeUsage) dir = arg->usage();
            if ((dir == CppParseName(out)) || (dir == CppParseName(inOut)))
                ofs << arg->send();
        };
        
    };

    // end try block
    ofs.indent--;
    ofs << "}" << endl;
    ofs << endl;

    // catch User-defined exceptions
    while ((exception = exceptionListIter.next()) != NULL) {
        ofs << "catch(" << exception->name() << "& _exception) {" << endl;
        ofs.indent++;
        ofs << "_send_" << exception->name(CppGen_(underscore_key)) << "(_call, _exception);" << endl;
        ofs.indent--;
        ofs << "}" << endl;
    };

    // catch CORBA::SystemException
    ofs << "catch (" << CppParseName(CorbaSystemException)()->name() << "& _exception) {" << endl;
    ofs.indent++;
    ofs << "_call.iluSetErrorType(_exception.exception_kind());" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    // catch Unexpected exceptions
    ofs << "catch (...) {" << endl;
    ofs.indent++;
    ofs << "ILUCPP_WARN_UNEXPECTED_EXCEPTION(\"" << name(CppGen(underscore_key)) << "_stub\");" << endl;
    ofs << "_call.iluSetErrorType(CORBA_ERRTYP(unknown));" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    
    // end function
    ofs.indent--;
    ofs << "}" << endl;
    return ofs;
}


/* TMP 6/14
CppParseStream(ofstream) &
CppGen(Exception)::
_trueImplSend (CppParseStream(ofstream) & ofs) {
*/
void  // TMP 6/14
CppGen(Exception)::  // TMP 6/14
trueImplSend (const CppParseName(Scope) * sendingFrom, CppParseStream(ofstream) & ofs) const {  // TMP 6/14

  // begin function
  ofs << "static" << endl;
  ofs << "void" << endl;
  ofs << "_send_" << name(CppGen_(underscore_key))
    << " (iluTrueCall & _call, " << name() << "& _exception) {" << endl;
  ofs.indent++;

  // begin try block
  ofs << "try {" << endl;
  ofs.indent++;

  // size exception, send it
  ofs << "_call.iluSizeExceptionMode("; indexName(sendingFrom, ofs); ofs << " + 1);" << endl;  // TMP 6/14
  ofs << "_call += _exception;" << endl;
  ofs << "_call << _exception;" << endl;

  // end try block
  ofs.indent--;
  ofs << "}" << endl;

  // catch CORBA::SystemException
  ofs << "catch (" << CppParseName(CorbaSystemException)()->name()
      << "& _exception) {" << endl;
  ofs.indent++;
  ofs << "_call.iluSetErrorType(_exception.exception_kind());" << endl;
  ofs.indent--;
  ofs << "}" << endl;

  // catch other exceptions
  ofs << "catch (...) {" << endl;
  ofs.indent++;
  ofs << "ILUCPP_WARN_UNEXPECTED_EXCEPTION(\"_send_"
      << name(CppGen(underscore_key)) << "\");" << endl;
  ofs << "_call.iluSetErrorType(CORBA_ERRTYP(unknown));" << endl;
  ofs.indent--;
  ofs << "}" << endl;

  // end function
  ofs.indent--;
  ofs << "}" << endl;
// TMP 6/14  return ofs;
}
