/* Form definition file generated with fdesign. */

#include "forms.h"
#include <stdlib.h>
#include <string.h>
#include "Xmysql.h"
#include "XmysqlDB.h"
#include "Xmysql_def.h"


FD_Xmysql_main *create_form_Xmysql_main(void)
{
  /* build pixmap name */
  char pixmapName[FL_PATH_MAX+20];
  FL_OBJECT *obj;
  FD_Xmysql_main *fdui = (FD_Xmysql_main *) fl_calloc(1, sizeof(*fdui));

  /* save screen */
  Xmysql_main_screen = fdui;

  fdui->Xmysql_main = fl_bgn_form(FL_NO_BOX, 810, 370);
  obj = fl_add_box(FL_UP_BOX,0,0,810,370,"");
  fdui->xmysql_showDatabases = obj = fl_add_button(FL_NORMAL_BUTTON,10,30,110,30,"Show Databases");
    fl_set_object_callback(obj,ShowDatabasesCB,0);
  fdui->xmysql_databases = obj = fl_add_browser(FL_HOLD_BROWSER,10,80,120,170,"Databases");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,SelectedDatabaseCB,0);
  fdui->xmysql_exit = obj = fl_add_button(FL_NORMAL_BUTTON,10,320,90,30,"Exit");
    fl_set_object_callback(obj,ExitCB,0);
  fdui->xmysql_tables = obj = fl_add_browser(FL_HOLD_BROWSER,140,80,190,170,"Tables");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,SelectedTableCB,0);
  fdui->xmysql_tableFieldDefinitions = obj = fl_add_browser(FL_HOLD_BROWSER,340,80,450,170,"Table Field Definitions");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,SelectedTableFieldCB,0);
    /* replace admin database with batch SQL */
    fdui->xmysql_batch = obj = fl_add_button(FL_NORMAL_BUTTON,330,320,100,30,"Batch SQL");
  fl_set_object_callback(obj,BatchSQLCB,0);
  /* grey out for now */
  fl_deactivate_object(Xmysql_main_screen->xmysql_batch);
  fl_set_object_lcol(Xmysql_main_screen->xmysql_batch, FL_INACTIVE);

  /* NOT USED *******
  fdui->xmysql_adminDatabases = obj = fl_add_button(FL_NORMAL_BUTTON,330,320,100,30,"Admin Databases");
    fl_set_object_callback(obj,AdminDatabasesCB,0);
    ************/

  fdui->xmysql_adminTables = obj = fl_add_button(FL_NORMAL_BUTTON,450,320,100,30,"Admin Tables");
    fl_set_object_callback(obj,AdminTablesCB,0);
    /* grey out for now */
  fl_deactivate_object(Xmysql_main_screen->xmysql_adminTables);
  fl_set_object_lcol(Xmysql_main_screen->xmysql_adminTables, FL_INACTIVE);

  fdui->xmysql_sqlQuery = obj = fl_add_button(FL_NORMAL_BUTTON,570,320,100,30,"SQL Query");
    fl_set_object_callback(obj,SqlQueryCB,0);
    /* grey out for now */
  fl_deactivate_object(Xmysql_main_screen->xmysql_sqlQuery);
  fl_set_object_lcol(Xmysql_main_screen->xmysql_sqlQuery, FL_INACTIVE);

  fdui->xmysql_quickSelect = obj = fl_add_button(FL_NORMAL_BUTTON,690,320,100,30,"Quick Select *");
    fl_set_object_callback(obj,QuickSelectCB,0);
    /* grey out for now */
  fl_deactivate_object(Xmysql_main_screen->xmysql_quickSelect);
  fl_set_object_lcol(Xmysql_main_screen->xmysql_quickSelect, FL_INACTIVE);

  /* set version in button */
  sprintf(pixmapName, "%s %s %s",
	  "XmySQL",
	  XMYSQL_VERSION,
	  "(c) 1998 Rick Mehalick");
  fdui->xmysql_title = obj = fl_add_button(FL_NORMAL_BUTTON,200,10,390,30,pixmapName);
    fl_set_object_boxtype(obj,FL_SHADOW_BOX);
    fl_set_object_lcolor(obj,FL_YELLOW);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lstyle(obj,FL_FIXEDBOLDITALIC_STYLE+FL_SHADOW_STYLE);
    fl_set_object_callback(obj,XmySQL_abboutCB,0);

  fdui->image = obj = fl_add_pixmap(FL_NORMAL_PIXMAP,700,20,80,40,"");
  /* pixmap */
  sprintf(pixmapName, "%s/%s", CURRENT_RD, "mysql.xpm");
  fl_set_pixmap_file(obj, pixmapName);

  fdui->xmysql_main_status = obj = fl_add_input(FL_NORMAL_INPUT,10,280,780,30,"Status");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_TOP_LEFT);
    /* deactivate object */
    fl_deactivate_object(obj);

    fdui->xmysql_help = obj = fl_add_button(FL_NORMAL_BUTTON,110,320,90,30,"SQL Help");
    fl_set_object_callback(obj,HelpCB,0);

  fdui->xmysql_config = obj = fl_add_button(FL_NORMAL_BUTTON,220,320,90,30,"Configure");
    fl_set_object_callback(obj,ConfigCB,0);
  fl_end_form();

  fdui->Xmysql_main->fdui = fdui;

  /* Default at close function */
  fl_set_atclose(XmysqlDefaultAtCloseCB, (void*)0);

  /* CHANGE BROWSER FONT */
  fl_set_browser_fontstyle(fdui->xmysql_tableFieldDefinitions, 
			   FL_FIXED_STYLE);

  /* load databases */
  XmysqlDB(XMYSQL_GET_DATABASES, 0);

  /* add an idle callback for the results window */
  fl_set_idle_callback(Results_IdleCB, 0);

  return fdui;
}
/*---------------------------------------*/

FD_Xmysql_sql *create_form_Xmysql_sql(void)
{
  FL_OBJECT *obj;
  FD_Xmysql_sql *fdui = (FD_Xmysql_sql *) fl_calloc(1, sizeof(*fdui));

  /* save the screen */
  Xmysql_sql_screen = fdui;

  fdui->Xmysql_sql = fl_bgn_form(FL_NO_BOX, 900, 330);
  obj = fl_add_box(FL_UP_BOX,0,0,900,330,"SQL");
  fdui->xmysql_freeForm = obj = fl_add_input(FL_MULTILINE_INPUT,520,50,370,170,"Freeform or by selection");
  /* make size of font a little bigger */
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
  fdui->xmysql_command = obj = fl_add_browser(FL_HOLD_BROWSER,10,50,110,70,"Command");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,SqlCommandCB,0);
  fdui->xmysql_fields = obj = fl_add_browser(FL_HOLD_BROWSER,130,50,160,170,"Fields");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,SQLFieldCB,0);
  fdui->xmysql_conditionals = obj = fl_add_browser(FL_HOLD_BROWSER,300,50,120,170,"Conditionals");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,SQLConditionalsCB,0);
  fdui->xmysql_operators = obj = fl_add_browser(FL_HOLD_BROWSER,430,50,80,170,"Operators");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,SQLOperatorsCB,0);
  fdui->xmysql_exit = obj = fl_add_button(FL_NORMAL_BUTTON,10,280,70,30,"Exit");
    fl_set_object_callback(obj,SQLExitCB,0);
  fdui->xmysql_save = obj = fl_add_button(FL_NORMAL_BUTTON,820,280,70,30,"Save");
    fl_set_object_callback(obj,SQLSaveCB,0);
  fdui->xmysql_load = obj = fl_add_button(FL_NORMAL_BUTTON,730,280,70,30,"Load");
    fl_set_object_callback(obj,SQLLoadCB,0);
  fdui->xmysql_clear = obj = fl_add_button(FL_NORMAL_BUTTON,640,280,70,30,"Clear");
    fl_set_object_callback(obj,SQLClearCB,0);
  fdui->xmysql_submit = obj = fl_add_button(FL_NORMAL_BUTTON,550,280,70,30,"Submit");
    fl_set_object_callback(obj,SQLSubmitCB,0);
  fdui->xmysql_sql_status = obj = fl_add_input(FL_NORMAL_INPUT,10,240,880,30,"Status");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_TOP_LEFT);
    /* deactivate object */
    fl_deactivate_object(obj);
  fdui->xmysql_sql_tables = obj = fl_add_browser(FL_HOLD_BROWSER,10,140,110,80,"Tables");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,SQLTablesCB,0);
  fl_end_form();

  fdui->Xmysql_sql->fdui = fdui;

  /* load sql keyword list */
  fl_add_browser_line(fdui->xmysql_command, "SELECT");
  fl_add_browser_line(fdui->xmysql_command, "SELECT DISTINCT");
  fl_add_browser_line(fdui->xmysql_command, "SELECT ALL");
  fl_add_browser_line(fdui->xmysql_command, "INSERT INTO");
  fl_add_browser_line(fdui->xmysql_command, "UPDATE");
  fl_add_browser_line(fdui->xmysql_command, "DELETE FROM");
  
  /* load conditionals keyword list */
  fl_add_browser_line(fdui->xmysql_conditionals, "FROM");
  fl_add_browser_line(fdui->xmysql_conditionals, "WHERE");
  fl_add_browser_line(fdui->xmysql_conditionals, "INTO");
  fl_add_browser_line(fdui->xmysql_conditionals, "GROUP BY");
  fl_add_browser_line(fdui->xmysql_conditionals, "ORDER BY");
  fl_add_browser_line(fdui->xmysql_conditionals, "ASC");
  fl_add_browser_line(fdui->xmysql_conditionals, "DESC");
  fl_add_browser_line(fdui->xmysql_conditionals, "HAVING");
  fl_add_browser_line(fdui->xmysql_conditionals, "LIMIT");
  fl_add_browser_line(fdui->xmysql_conditionals, "PROCEDURE");
  fl_add_browser_line(fdui->xmysql_conditionals, "INTO OUTFILE '");
  fl_add_browser_line(fdui->xmysql_conditionals, "VALUES");
  fl_add_browser_line(fdui->xmysql_conditionals, "SET");
  
  /* load operators list */
  fl_add_browser_line(fdui->xmysql_operators, "AND");
  fl_add_browser_line(fdui->xmysql_operators, "OR");
  fl_add_browser_line(fdui->xmysql_operators, "LIKE");
  fl_add_browser_line(fdui->xmysql_operators, "<");
  fl_add_browser_line(fdui->xmysql_operators, ">");
  fl_add_browser_line(fdui->xmysql_operators, "=");
  fl_add_browser_line(fdui->xmysql_operators, "<=");
  fl_add_browser_line(fdui->xmysql_operators, ">=");
  fl_add_browser_line(fdui->xmysql_operators, "<>");
  fl_add_browser_line(fdui->xmysql_operators, "!=");
  fl_add_browser_line(fdui->xmysql_operators, "BETWEEN");
  fl_add_browser_line(fdui->xmysql_operators, "IS NULL");
  fl_add_browser_line(fdui->xmysql_operators, "IS NOT NULL");

  /* setup current sql table */
  strcpy(CURRENT_SQL_TABLE, CURRENT_TABLE);
  XmysqlDB(XMYSQL_SQLGET_FIELDS, 0);

  XmysqlDB(XMYSQL_SQLGET_TABLES, 0);

  /* select the current sql table in the browser */
  {
    int i;
    const char *tab = 0;
    int maxLines = fl_get_browser_maxline(fdui->xmysql_sql_tables);
    for (i=1; i < maxLines; i++) {
      tab = fl_get_browser_line(fdui->xmysql_sql_tables, i);
      if (tab)
	if (strcmp(tab, CURRENT_SQL_TABLE) == 0)
	  fl_select_browser_line(fdui->xmysql_sql_tables, i);
    }
  }


  return fdui;
}
/*---------------------------------------*/

FD_Xmysql_query_results *create_form_Xmysql_query_results(void)
{
  FL_OBJECT *obj;
  FD_Xmysql_query_results *fdui = (FD_Xmysql_query_results *) fl_calloc(1, sizeof(*fdui));

  /* save the screen */
  Xmysql_query_results_screen = fdui;

  fdui->Xmysql_query_results = fl_bgn_form(FL_NO_BOX, 670, 370);
  obj = fl_add_box(FL_UP_BOX,0,0,670,370,"");
  fdui->xmysql_results = obj = fl_add_browser(FL_NORMAL_BROWSER,10,60,650,240,"");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    /* make font larger */
    fl_set_browser_fontsize(obj, FL_NORMAL_SIZE);

  fdui->xmysql_exit = obj = fl_add_button(FL_NORMAL_BUTTON,20,320,80,30,"Exit");
    fl_set_object_callback(obj,Result_ExitCB,0);
  fdui->xmysql_rows_affected = obj = fl_add_input(FL_NORMAL_INPUT,490,320,170,30,"Rows affected");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    /* deactivate object */
    fl_deactivate_object(obj);

  fdui->xmysql_font_type = obj = fl_add_choice(FL_NORMAL_CHOICE2,130,320,80,30,"");
    fl_set_object_callback(obj,Result_FontCB,0);
    /* add choices */
    fl_addto_choice(obj, "NORMAL|TINY|SMALL|MEDIUM|LARGE|HUGE");

    fdui->xmysql_save = obj = fl_add_button(FL_NORMAL_BUTTON,240,320,70,30,"Save");
    fl_set_object_callback(obj,Result_SaveCB,0);
    /* add results header */
    fdui->xmysql_header = obj = fl_add_input(FL_NORMAL_INPUT,10,20,650,40,"");
    /*fl_set_object_boxtype(obj,FL_UP_BOX);*/
    fl_set_object_color(obj,FL_COL1,FL_COL1);
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_lstyle(obj, FL_FIXED_STYLE);
    /* deactivate object */
    fl_deactivate_object(obj);

  fl_end_form();

  fdui->Xmysql_query_results->fdui = fdui;

  /* CHANGE BROWSER FONT */
  fl_set_browser_fontstyle(fdui->xmysql_results, 
			   FL_FIXED_STYLE);
  fl_set_input(fdui->xmysql_rows_affected, "0");

  return fdui;
}
/*---------------------------------------*/

FD_Xmysql_table_admin *create_form_Xmysql_table_admin(void)
{
  FL_OBJECT *obj;
  FD_Xmysql_table_admin *fdui = (FD_Xmysql_table_admin *) fl_calloc(1, sizeof(*fdui));

  /* save screen */
  Xmysql_table_admin_screen = fdui;

  fdui->Xmysql_table_admin = fl_bgn_form(FL_NO_BOX, 620, 340);
  obj = fl_add_box(FL_UP_BOX,0,0,620,340,"");
  /* made HOLD */
  fdui->xmysql_command = obj = fl_add_browser(FL_HOLD_BROWSER,10,40,130,80,"Command");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,TblCommandCB,0);
    
    /* made HOLD */
  fdui->xmysql_datatypes = obj = fl_add_browser(FL_HOLD_BROWSER,150,40,130,170,"Data Types");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,TblDataTypesCB,0);
  fdui->xmysql_freeform = obj = fl_add_input(FL_MULTILINE_INPUT,290,40,310,170,"Freeform or by selection");
  /* make size of font a little bigger */
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,TblFreeFormCB,0);
  fdui->xmysql_exit = obj = fl_add_button(FL_NORMAL_BUTTON,10,290,80,30,"Exit");
    fl_set_object_callback(obj,TblExitCB,0);
  fdui->xmysql_save = obj = fl_add_button(FL_NORMAL_BUTTON,520,290,80,30,"Save");
    fl_set_object_callback(obj,TblSaveCB,0);
  fdui->xmysql_load = obj = fl_add_button(FL_NORMAL_BUTTON,430,290,80,30,"Load");
    fl_set_object_callback(obj,TblLoadCB,0);
  fdui->xmysql_clear = obj = fl_add_button(FL_NORMAL_BUTTON,340,290,80,30,"Clear");
    fl_set_object_callback(obj,TblClearCB,0);
  fdui->xmyql_submit = obj = fl_add_button(FL_NORMAL_BUTTON,250,290,80,30,"Submit");
    fl_set_object_callback(obj,TblSubmitCB,0);
  fdui->xmysql_admin_status = obj = fl_add_input(FL_NORMAL_INPUT,10,240,590,30,"Status");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_lalign(obj,FL_ALIGN_TOP_LEFT);
    /* deactivate object */
    fl_deactivate_object(obj);
    
    /* made HOLD */
    fdui->xmysql_tables = obj = fl_add_browser(FL_HOLD_BROWSER,10,140,130,70,"Tables");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
    fl_set_object_callback(obj,TblTableCB,0);
  fl_end_form();

  fdui->Xmysql_table_admin->fdui = fdui;

  /* load sql keyword list */
  fl_add_browser_line(fdui->xmysql_command, "CREATE TABLE");
  fl_add_browser_line(fdui->xmysql_command, "DROP TABLE");
  fl_add_browser_line(fdui->xmysql_command, "ALTER TABLE");

  /* add tables */
  XmysqlDB(XMYSQL_ADMIN_TABLES, 0);

  /* load datatypes list */
  fl_add_browser_line(fdui->xmysql_datatypes, "CHAR( )");
  fl_add_browser_line(fdui->xmysql_datatypes, "BIT");
  fl_add_browser_line(fdui->xmysql_datatypes, "VARCHAR( )");
  fl_add_browser_line(fdui->xmysql_datatypes, "VARCHAR( ) binary");
  fl_add_browser_line(fdui->xmysql_datatypes, "INT");
  fl_add_browser_line(fdui->xmysql_datatypes, "INTEGER");
  fl_add_browser_line(fdui->xmysql_datatypes, "BIGINT");
  fl_add_browser_line(fdui->xmysql_datatypes, "TINYINT");
  fl_add_browser_line(fdui->xmysql_datatypes, "SMALLINT");
  fl_add_browser_line(fdui->xmysql_datatypes, "MEDIUMINT");
  fl_add_browser_line(fdui->xmysql_datatypes, "REAL");
  fl_add_browser_line(fdui->xmysql_datatypes, "FLOAT");
  fl_add_browser_line(fdui->xmysql_datatypes, "DOUBLE");
  fl_add_browser_line(fdui->xmysql_datatypes, "DECIMAL( )");
  fl_add_browser_line(fdui->xmysql_datatypes, "SET( )");
  fl_add_browser_line(fdui->xmysql_datatypes, "ENUM( )");
  fl_add_browser_line(fdui->xmysql_datatypes, "BLOB");
  fl_add_browser_line(fdui->xmysql_datatypes, "TEXT");
  fl_add_browser_line(fdui->xmysql_datatypes, "TINYBLOB");
  fl_add_browser_line(fdui->xmysql_datatypes, "TINYTEXT");
  fl_add_browser_line(fdui->xmysql_datatypes, "MEDIUMBLOB");
  fl_add_browser_line(fdui->xmysql_datatypes, "MEDIUMTEXT");
  fl_add_browser_line(fdui->xmysql_datatypes, "LONGBLOB");
  fl_add_browser_line(fdui->xmysql_datatypes, "LONGTEXT");
  fl_add_browser_line(fdui->xmysql_datatypes, "DATETIME");
  fl_add_browser_line(fdui->xmysql_datatypes, "DATE");
  fl_add_browser_line(fdui->xmysql_datatypes, "TIME");
  fl_add_browser_line(fdui->xmysql_datatypes, "TIMESTAMP( )");
  fl_add_browser_line(fdui->xmysql_datatypes, "PRIMARY KEY");
  fl_add_browser_line(fdui->xmysql_datatypes, "NULL");
  fl_add_browser_line(fdui->xmysql_datatypes, "NOT NULL");
  fl_add_browser_line(fdui->xmysql_datatypes, "DEFAULT");
  fl_add_browser_line(fdui->xmysql_datatypes, "PRIMARY INDEX");
  fl_add_browser_line(fdui->xmysql_datatypes, "KEY");
  fl_add_browser_line(fdui->xmysql_datatypes, "INDEX");
  fl_add_browser_line(fdui->xmysql_datatypes, "UNIQUE");
  fl_add_browser_line(fdui->xmysql_datatypes, "AUTO_INCREMENT");
  fl_add_browser_line(fdui->xmysql_datatypes, "ZEROFILL");
  fl_add_browser_line(fdui->xmysql_datatypes, "UNSIGNED");
  fl_add_browser_line(fdui->xmysql_datatypes, "ADD COLUMN");
  fl_add_browser_line(fdui->xmysql_datatypes, "ADD INDEX");
  fl_add_browser_line(fdui->xmysql_datatypes, "CHANGE COLUMN");
  fl_add_browser_line(fdui->xmysql_datatypes, "DROP COLUMN");
  fl_add_browser_line(fdui->xmysql_datatypes, "DROP PRIMARY INDEX");
  fl_add_browser_line(fdui->xmysql_datatypes, "DROP INDEX");

  return fdui;
}
/*---------------------------------------*/

FD_Xmysql_batch_query *create_form_Xmysql_batch_query(void)
{
  FL_OBJECT *obj;
  FD_Xmysql_batch_query *fdui = (FD_Xmysql_batch_query *) fl_calloc(1, sizeof(*fdui));

  /* save the screen */
  Xmysql_batch_query_screen = fdui;

  fdui->Xmysql_batch_query = fl_bgn_form(FL_NO_BOX, 670, 340);
  obj = fl_add_box(FL_UP_BOX,0,0,670,340,"");
  fdui->xmysql_batch = obj = fl_add_browser(FL_MULTI_BROWSER,10,30,650,240,"Batch SQL by file only");
    fl_set_object_lalign(obj,FL_ALIGN_TOP);
  /* make font larger */
    fl_set_browser_fontsize(obj, FL_NORMAL_SIZE);
    fl_set_object_callback(obj,Batch_SelectCB, 0);
  fdui->xmysql_exit = obj = fl_add_button(FL_NORMAL_BUTTON,20,290,80,30,"Exit");
    fl_set_object_callback(obj,Batch_ExitCB,0);

    fdui->xmysql_submit = obj = fl_add_button(FL_NORMAL_BUTTON,470,290,80,30,"Submit");
    fl_set_object_callback(obj,Batch_SubmitCB,0);

    fdui->xmysql_load = obj = fl_add_button(FL_NORMAL_BUTTON,570,290,80,30,"Load");
    fl_set_object_callback(obj,Batch_LoadCB,0);

  fl_end_form();
  fdui->Xmysql_batch_query->fdui = fdui;

  /* CHANGE BROWSER FONT */
  fl_set_browser_fontstyle(fdui->xmysql_batch, 
			   FL_FIXED_STYLE);
  return fdui;
}
/*---------------------------------------*/

FD_Xmysql_about *create_form_Xmysql_about(void)
{
  /* setup version */
  char versionStr[200];

  FL_OBJECT *obj;
  FD_Xmysql_about *fdui = (FD_Xmysql_about *) fl_calloc(1, sizeof(*fdui));
  
  /* save the screen */
  Xmysql_about_screen = fdui;

  fdui->Xmysql_about = fl_bgn_form(FL_NO_BOX, 400, 330);
  obj = fl_add_box(FL_UP_BOX,0,0,400,330,"");
  fdui->mysql_exit = obj = fl_add_button(FL_NORMAL_BUTTON,20,290,80,30,"Exit");
    fl_set_object_callback(obj,About_ExitCB,0);
  fdui->xmysql_about = obj = fl_add_browser(FL_NORMAL_BROWSER,10,10,380,270,"");
    fl_set_object_color(obj,FL_BLACK,FL_BLACK);
    fl_set_object_lcolor(obj,FL_YELLOW);
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
  fl_end_form();

  fdui->Xmysql_about->fdui = fdui;

  /* load about info */
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l@bXmySQL");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l ");
  sprintf(versionStr, "@c@f@lVersion %s", XMYSQL_VERSION);
  fl_add_browser_line(fdui->xmysql_about, versionStr);
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l ");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l(c) 1998");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l ");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@lBy");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l ");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@lRick Mehalick");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l ");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@lhttp://web.wt.net/~dblhack");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l ");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l@bemail: dblhack@wt.net");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l ");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l 12018 Villa Lea");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l ");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l Houston, TX 77071");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l ");
  fl_add_browser_line(fdui->xmysql_about, "@c@f@l ");
  sprintf(versionStr, "@c@f@lmySQL Version %s", MYSQL_VERSION);
  fl_add_browser_line(fdui->xmysql_about, versionStr);
  return fdui;
}
/*---------------------------------------*/

FD_Xmysql_help *create_form_Xmysql_help(void)
{
  /* build help file */
  char helpName[FL_PATH_MAX+20];

  FL_OBJECT *obj;
  FD_Xmysql_help *fdui = (FD_Xmysql_help *) fl_calloc(1, sizeof(*fdui));

  /* save the screen */
  Xmysql_help_screen = fdui;

  fdui->Xmysql_help = fl_bgn_form(FL_NO_BOX, 650, 420);
  obj = fl_add_box(FL_UP_BOX,0,0,650,420,"");
  fdui->xmysql_help = obj = fl_add_browser(FL_NORMAL_BROWSER,20,20,610,340,"");
  /* make size of font a little bigger */
    fl_set_browser_fontsize(obj,FL_MEDIUM_SIZE);
  fdui->xmysql_exit = obj = fl_add_button(FL_NORMAL_BUTTON,30,380,90,30,"Exit");
    fl_set_object_callback(obj,Help_ExitCB,0);
  fdui->xmysql_search_string = obj = fl_add_input(FL_NORMAL_INPUT,140,380,280,30,"");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_callback(obj,Help_SearchTxtCB,0);
  fdui->xymsql_search = obj = fl_add_button(FL_RETURN_BUTTON,430,380,70,30,"Search");
    fl_set_object_callback(obj,Help_FindCB,0);
    fdui->xmysql_previous = obj = fl_add_button(FL_NORMAL_BUTTON,520,380,50,30,"@<");
    fl_set_object_callback(obj,Help_PreviousCB,0);
  fdui->xmysql_next = obj = fl_add_button(FL_NORMAL_BUTTON,580,380,50,30,"@>");
    fl_set_object_callback(obj,Help_NextCB,0);
  fl_end_form();

  fdui->Xmysql_help->fdui = fdui;

  /* load help */
  sprintf(helpName, "%s/%s", CURRENT_HD, "sqlhelp.txt");
  fl_load_browser(fdui->xmysql_help, helpName);

  return fdui;
}
/*---------------------------------------*/
FD_Xmysql_config *create_form_Xmysql_config(void)
{
  /* for quick limit */
  char lim[100];

  FL_OBJECT *obj;
  FD_Xmysql_config *fdui = (FD_Xmysql_config *) fl_calloc(1, sizeof(*fdui));

  /* save screen */
  Xmysql_config_screen = fdui;

  fdui->Xmysql_config = fl_bgn_form(FL_NO_BOX, 270, 400);
  obj = fl_add_box(FL_UP_BOX,0,0,270,400,"");
  fdui->xmysql_exit = obj = fl_add_button(FL_NORMAL_BUTTON,45,340,80,30,"Exit");
    fl_set_object_callback(obj,Config_ExitCB,0);
  fdui->xmysql_host = obj = fl_add_input(FL_NORMAL_INPUT,110,20,150,30,"Host");
  fdui->xmysql_accept = obj = fl_add_button(FL_NORMAL_BUTTON,155,340,80,30,"Accept");
    fl_set_object_callback(obj,Config_AcceptCB,0);
  obj = fl_add_button(FL_NORMAL_BUTTON,450,-120,10,10,"Button");
  fdui->xmysql_user = obj = fl_add_input(FL_NORMAL_INPUT,110,70,150,30,"User");
  fdui->xmysql_password = obj = fl_add_input(FL_SECRET_INPUT,110,120,150,30,"Password");
  fdui->xmysql_qlimit = obj = fl_add_input(FL_NORMAL_INPUT,160,170,100,30,"Quick Limit (-1 No Limit)");
  fdui->xmysql_port = obj = fl_add_input(FL_NORMAL_INPUT,160,220,100,30,"Port");
#ifndef HAVE_MYSQL_REAL_CONNECT
  /* grey out for now */
  fl_deactivate_object(fdui->xmysql_port);
#endif
  fdui->xmysql_socket = obj = fl_add_input(FL_NORMAL_INPUT,70,270,190,30,"Socket");
#ifndef HAVE_MYSQL_REAL_CONNECT
  /* grey out for now */
  fl_deactivate_object(fdui->xmysql_socket);
#endif
  fl_end_form();

  fdui->Xmysql_config->fdui = fdui;

  /* load current values */
  fl_set_input(fdui->xmysql_host, CURRENT_SERVER);
  if (CURRENT_USER)
    fl_set_input(fdui->xmysql_user, CURRENT_USER);

  /* NOTE: This doesn't seem to work, but it was asked for by a user */
  if (CURRENT_PASSWORD) {
     memset(lim, 0, sizeof(lim));
     memset(lim, '*', strlen(CURRENT_PASSWORD)); 	
     fl_set_input(fdui->xmysql_password, CURRENT_PASSWORD);
  }

  if (CURRENT_PORT)
    fl_set_input(fdui->xmysql_port, CURRENT_PORT);
  if (CURRENT_SOCKET)
    fl_set_input(fdui->xmysql_socket, CURRENT_SOCKET);
  sprintf(lim, "%d", QUICK_LIMIT);
  fl_set_input(fdui->xmysql_qlimit, lim);
  return fdui;
}

/*---------------------------------------*/
FD_Xmysql_add_record *create_form_Xmysql_add_record(void)
{
  /* for loading screen */
  int i;
  char line[1000];
  FieldInfo *f = 0;
  int maxSize = 0;
  FL_OBJECT *obj;
  const char *result = 0;

  FD_Xmysql_add_record *fdui = (FD_Xmysql_add_record *) fl_calloc(1, sizeof(*fdui));

  /* save screen */
  Xmysql_addrec_screen = fdui;

  fdui->Xmysql_add_record = fl_bgn_form(FL_NO_BOX, 600, 380);
  obj = fl_add_box(FL_UP_BOX,0,0,600,380,"");
  fdui->xmysql_exit = obj = fl_add_button(FL_NORMAL_BUTTON,10,330,70,30,"Exit");
    fl_set_object_callback(obj,AddRec_ExitCB,0);
  fdui->xmysql_add = obj = fl_add_button(FL_NORMAL_BUTTON,110,330,70,30,"Accept");
    fl_set_object_callback(obj,AddRec_AddCB,0);
  fdui->xmysql_record = obj = fl_add_browser(FL_HOLD_BROWSER,10,20,580,250,"");
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
    fl_set_object_callback(obj,AddRec_SelectedFieldCB,0);
    /* CHANGE BROWSER FONT */
    fl_set_browser_fontstyle(fdui->xmysql_record, 
			     FL_FIXED_STYLE);
    /* make font larger */
    fl_set_browser_fontsize(fdui->xmysql_record, FL_NORMAL_SIZE);
  fdui->xmysql_input = obj = fl_add_input(FL_NORMAL_INPUT,10,280,410,30,"");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
  fdui->xmysql_ok = obj = fl_add_button(FL_RETURN_BUTTON,430,280,70,30,"Ok");
    fl_set_object_callback(obj,AddRec_OkCB,0);
  fdui->xmysql_clear = obj = fl_add_button(FL_NORMAL_BUTTON,510,280,70,30,"Clear");
    fl_set_object_callback(obj,AddRec_ClearCB,0);
  fl_end_form();

  fdui->Xmysql_add_record->fdui = fdui;

  /* get the fields, one per line */
  XmysqlDB(XMYSQL_BUILD_TABLEFIELD_INFO, 0);
  
  if (SPECIAL_EDIT == SPECIAL_ADD_REC) {
    maxSize = GetMaxFieldSize();
    
    for (i=0; i < TABLEFIELDINFO.nbrFields; i++) {
      f = TABLEFIELDINFO.fields[i];
      sprintf(line, "%-*s", maxSize, f->field.name);
      fl_add_browser_line(fdui->xmysql_record, line);
    }
    fl_select_browser_line(fdui->xmysql_record, 1);
  }
  if (SPECIAL_EDIT == SPECIAL_UPDATE_REC) {
    result = fl_show_input("Enter WHERE clause to find record for update", "");
    if (result && strlen(result) > 0) {
      sprintf(BATCH_SQL, "SELECT * FROM %s WHERE %s",
	     TABLEFIELDINFO.tableName, result);
      if (XmysqlDB(XMYSQL_FINDREC_FOR_UPDATE, 0) == TRUE)
	return 0;
      sprintf(UPDATE_WHERE, " WHERE %s", result);
      fl_select_browser_line(fdui->xmysql_record, 1);
      AddRec_SelectedFieldCB(0, 0);
    }
    else 
      return 0;
  }
  return fdui;
}
/*---------------------------------------*/
