/***************************************************************************
**    xIrcCommands.h  $Revision: 1.6 $ - $Name: V2-0 $ 
**    Class for handling IRC Commands
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#ifndef _xIRCCOMMANDS_H
#define _xIRCCOMMANDS_H

#include <qobject.h>

class xIrcCommands
{
public:
   xIrcCommands();
   
   int         code(const char *pCmd);
   char        *name(int cmd);
   const char  *text(int cmd);
   bool        is(int cmd, char *pStr)
   {
      return((strcmp(name(cmd), pStr) == 0) ? TRUE : FALSE);
   };
   
private:
   char  **commandList;
};

#define IRCRESP_First     20
#define IRCRESP_Last      99
#define IRCRESP_Unknown   -1

#endif
