/***************************************************************************
**    xIrcPeopleEntry.cpp  $Revision: 1.2 $ - $Name: V2-0 $ 
**    Builds an entry for the People list
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <ctype.h>
#include <qregexp.h>
#include <stdio.h>
#include <xMessageBox.h>
#include "xIrcConnect.h"
#include "xIrcPeopleEntry.h"

static int dbg = 0;

extern xIrcConnect *pTWindow;
extern xIrcCommands ircResponses;

xIrcPeopleEntry::xIrcPeopleEntry(xIrcMessage *pMsg, bool atAround)
{
   const char *cp, *cp1;

   if (pMsg->rspCode == 352)
   {
      const char *cp;

      /*
      ** Skip past the user's server name and the Irc server's name and
      ** any spaces in the middle (Namely get the 3rd field of msgStr
      */
      if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Gleening Nick from: |%s|\n",
                                (const char *)pMsg->msgStr);
      if (dbg) fflush(stdout);
      cp = pMsg->msgStr;
      cp1 = pMsg->dstStr;
      if (*cp1 == '#')
      {
         if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Skipping Username: |%s|\n",
                                  (const char *)cp);
         for (; *cp != ' '; cp++);
      }
      if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Skipping WS: |%s|\n",
         (const char *)cp);
      if (dbg) fflush(stdout);
      for (; *cp == ' '; cp++);
      if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Skipping Hostname: |%s|\n",
         (const char *)cp);
      if (dbg) fflush(stdout);
      for (; *cp != ' '; cp++);
      if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Skipping WS: |%s|\n",
         (const char *)cp);
      if (dbg) fflush(stdout);
      for (; *cp == ' '; cp++);
      if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Skipping Server name: |%s|\n",
         (const char *)cp);
      if (dbg) fflush(stdout);
      for (; *cp != ' '; cp++);
      if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Skipping WS: |%s|\n",
         (const char *)cp);
      if (dbg) fflush(stdout);
      for (; *cp == ' '; cp++);
      /*
      ** Assume that the 4th field is the nick
      */
      if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Nick: |%s|\n",
         (const char *)cp);
      if (dbg) fflush(stdout);
      for (; *cp != ' '; cp++)
         Nick += *cp;
      Mask = buildMask(pMsg, atAround);
   }
   else if (ircResponses.is(pMsg->rspCode, "NOTICE") ||
            ircResponses.is(pMsg->rspCode, "PRIVMSG"))
   {
      Nick = pMsg->srcNick;
      Mask = "";
      for (cp = pMsg->srcAddr; *cp != '@'; cp++)
         Mask += *cp;
      if (atAround == TRUE)
         Mask += "@*";
      else
         Mask += " *";
      for (cp = pMsg->srcAddr; *cp != '.'; cp++);
      for (cp = pMsg->srcAddr; *cp; cp++);
         Mask += *cp;
   }
   Flag = 1;
   State = 0;
}

xIrcPeopleEntry::xIrcPeopleEntry(const char *pNick, const char *pMask, const char *pMsg,
                                 int flag)
{
   Nick = pNick;
   Mask = pMask;
   Message = pMsg;
   Flag = flag;
   State = 0;

   if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Nick = |%s|\n",
                             (const char *)Nick);
   if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Mask = |%s|\n",
                             (const char *)Mask);
   if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Message = |%s|\n",
                             (const char *)Message);
   if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Flag = |%d|\n",
                             Flag);
}

xIrcPeopleEntry::xIrcPeopleEntry(xIrcPeopleEntry &e)
{
   Mask = e.mask();
   Nick = e.nick();
   Message = e.message();
   Flag = e.flag();
   State = 0;
   if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Nick = |%s|\n",
                             (const char *)Nick);
   if (dbg) fprintf(stdout, "xIrcPeopleEntry::xIrcPeopleEntry():Mask = |%s|\n",
                             (const char *)Mask);
}

int xIrcPeopleEntry::compare(xIrcPeopleEntry *e)
{
   return(strcmp(Nick, e->nick()));
}

bool xIrcPeopleEntry::is(xIrcMessage *pMsg, int byAddr)
{
   bool rv = FALSE;

   if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():Enter\n");
   if (dbg) fflush(stdout);
   if (pMsg->rspCode == 352)
   {
      if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():Testing Who Message\n");
      if (dbg) fflush(stdout);
      if (byAddr >= 0)
      {
         QRegExp reMask(Mask, FALSE, TRUE);
         QString tmpMask(buildMask(pMsg));
         if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():By Addr: |%s| == |%s|?\n",
                         (const char *)tmpMask, (const char *)Mask);
         if (dbg) fflush(stdout);
         if (reMask.match(tmpMask) >= 0)
            rv = TRUE;
      }
      else
      {
         const char *cp;
         QString tmpNick;

         if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():By nick\n");
         if (dbg) fflush(stdout);

         /*
         ** If the destination is a channel name, the 4th field of the message
         ** string has the nick
         */
         cp = pMsg->dstStr;
         if (*cp == '#')
         {
            for (cp = pMsg->msgStr; *cp != ' '; cp++);
            for (; *cp == ' '; cp++);

            for (; *cp != ' '; cp++);
            for (; *cp == ' '; cp++);

            for (; *cp != ' '; cp++);
            for (; *cp == ' '; cp++);
         }

         /*
         ** Assume the cp points to the nick
         */
         for (; *cp != '\0' && *cp != ' '; cp++)
            tmpNick += *cp;
         if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():By Nick: |%s| == |%s|?\n",
                         (const char *)tmpNick, (const char *)Nick);
         if (strcmp(tmpNick, Nick) == 0)
            rv = TRUE;
      }
   }
   else if (pMsg->rspCode == 315)
   {
      const char *cp;

      if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():Testing End of Who Message\n");
      if (dbg) fflush(stdout);

      if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():By nick\n");
      if (dbg) fflush(stdout);
      QString tmpNick;
      for (cp = pMsg->rawMsg; *cp != ' '; cp++);
      for (; *cp == ' '; cp++);
      for (; *cp != ' '; cp++);
      for (; *cp == ' '; cp++);
      for (; *cp != ' '; cp++);
      for (; *cp == ' '; cp++);
      /*
      ** Assume that the 4th field is the nick
      */
      for (; *cp != ' '; cp++)
         tmpNick += *cp;
      if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():By Nick: |%s| == |%s|?\n",
                      (const char *)tmpNick, (const char *)Nick);
      if (byAddr >= 0)
      {
         if (strstr(Mask, tmpNick) != NULL)
            rv = TRUE;
      }
      else if (strcmp(tmpNick, Nick) == 0)
         rv = TRUE;
   }
   else if (ircResponses.is(pMsg->rspCode, "NOTICE") ||
            ircResponses.is(pMsg->rspCode, "PRIVMSG"))
   {
      if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():Testing Notice or PrivMsg\n");
      if (dbg) fflush(stdout);
      if (byAddr < 0)
      {
         if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():By Nick: |%s| == |%s|?\n",
                         (const char *)pMsg->srcNick, (const char *)Nick);
         if (dbg) fflush(stdout);
         if (strcmp(Nick, pMsg->srcNick) == 0)
            rv = TRUE;
      }
      else
      {
         const char *cp, *cp1;

         cp = pMsg->srcAddr;
         cp1 = Mask;
         if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():By Nick: |%s| == |%s|?\n",
                         cp, cp1);
         if (dbg) fflush(stdout);
         for (rv = FALSE; rv != TRUE;)
         {
            if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():By Nick: |%c| == |%c|- ",
                            *cp, *cp1);
            if (dbg) fflush(stdout);
            if (*cp1 != '*')
            {
               if (dbg) fprintf(stdout, "Not in Mask");
               if (dbg) fflush(stdout);
               if (*cp != *cp1)
                  break;
               else
               {
                  if (dbg) fprintf(stdout, " Matched!!\n");
                  if (dbg) fflush(stdout);
                  cp++;
                  cp1++;
               }
            }
            else
            {
               if (*cp != '.')
               {
                  if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():Skipping\n");
                  if (dbg) fflush(stdout);
                  cp++;
               }
               else
               {
                  cp1++;
                  if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():Proceding\n");
                  if (dbg) fflush(stdout);
               }
            }
            if (*cp1 == '\0')
               rv = TRUE;
         }
      }
   }   
   if (dbg) fprintf(stdout, "xIrcPeopleEntry::is():Exit(%d)\n", rv);
   if (dbg) fflush(stdout);
   return(rv);
}

QString xIrcPeopleEntry::buildMask(xIrcMessage *pMsg, bool atAround)
{
   QString rv;
   const char *cp;

   if (pMsg->rspCode == 352)
   {
      cp = pMsg->dstStr;
      if (*cp != '#')
      {
         rv += pMsg->dstStr;
         for (cp = pMsg->msgStr; *cp == ' '; cp++);
      }
      else
      {
         for (cp = pMsg->msgStr; *cp == ' '; cp++);
         for (; *cp != ' '; cp++)
            rv += *cp;
      }
      if (atAround == TRUE)
         rv += "@";
      else
         rv += " ";
      for (; *cp == ' '; cp++);
      if (isdigit(*cp))
      {
         for (; *cp != ' '; cp++)
            rv += *cp;
      }
      else
      {
         char ch = ' ';

         rv += "*";
         for (; *cp != '.'; cp++);
         for (; *cp != ' '; cp++)
         {
            if (isdigit(ch) && isdigit(*cp))
               continue;
            else if (isdigit(*cp))
            {
               ch = *cp;
               rv += '*';
               continue;
            }
            ch = *cp;
            rv += *cp;
         }
      }
   }
   else
      rv = "";
   return(rv);
}

