#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include "optutil.h"
#include "open_app.h"
#include "main.h"

int main(int argc, char *argv[])
{
  Pilot pilot;

  ResourceOption ros[] = {
    {"<filename>", "file to read the ROM from",
     {"romfile", "Romfile", XtRString, sizeof(String),
      XtOffset(Pilot_P, RomFile), XtRString, "pilot.rom"},
     {"-romfile", "*romfile", XrmoptionSepArg, (caddr_t) NULL}},
    {"<filename>", "file to put the RAM in",
     {"ramfile", "Ramfile", XtRString, sizeof(String),
      XtOffset(Pilot_P, RamFile), XtRString, "pilot.ram"},
     {"-ramfile", "*ramfile", XrmoptionSepArg, (caddr_t) NULL}},
    {"<filename>", "file to use for scratch data",
     {"scratchfile", "ScratchFile", XtRString, sizeof(String),
      XtOffset(Pilot_P, ScratchFile), XtRString, "pilot.scratch"},
     {"-scratchfile", "*scratchfile", XrmoptionSepArg, (caddr_t) NULL}},
    {"<dirname>", "default directory for files",
     {"datadir", "Datadir", XtRString, sizeof(String),
      XtOffset(Pilot_P, DataDir), XtRString, "~/.xcopilot"},
     {"-datadir", "*datadir", XrmoptionSepArg, (caddr_t) NULL}},
    {"<n>", "set debug mode (off, old, gdb)",
     {"debug", "Debug", XtRString, sizeof(String),
      XtOffset(Pilot_P, Debugging), XtRString, "off"},
     {"-debug", "*debug", XrmoptionSepArg, (caddr_t) NULL}},
    {"[debug options]", "set debug options",
     {"debugargs", "debugargs", XtRString, sizeof(String),
      XtOffset(Pilot_P, DebugArgs), XtRString, ""},
     {"-debugargs", "*debugargs", XrmoptionSepArg, (caddr_t) NULL}},
    {"<colorname>", "color of backlit background",
     {"bbg", "Bbg", XtRString, sizeof(String),
      XtOffset(Pilot_P, bbg), XtRString, "PaleGreen1"},
     {"-bbg", "*bbg", XrmoptionSepArg, (caddr_t) NULL}},
    {NULL, "don't use Xshm",
     {"noxshm", "Noxshm", XtRInt, sizeof(unsigned),
      XtOffset(Pilot_P, NoXShm), XtRString, "0"},
     {"-noxshm", "*noxhsm", XrmoptionNoArg, (caddr_t) "1"}},
    {NULL, "use serial port",
     {"serial", "Serial", XtRInt, sizeof(unsigned),
      XtOffset(Pilot_P, Serial), XtRString, "0"},
     {"-serial", "*serial", XrmoptionNoArg, (caddr_t) "1"}},
    {"<devfile>", "device file for serial port to use",
     {"port", "Port", XtRString, sizeof(String),
      XtOffset(Pilot_P, SerialPort), XtRString, "/dev/ptyqe"},
     {"-port", "*port", XrmoptionSepArg, (caddr_t) NULL}},
    {"<n>", "size of emulated RAM",
     {"ramsize", "Ramsize", XtRInt, sizeof(unsigned),
      XtOffset(Pilot_P, RamSize), XtRString, "1024"},
     {"-ramsize", "*ramsize", XrmoptionSepArg, (caddr_t) NULL}},
    {"<n>", "pixel magnification factor",
     {"magfactor", "Magfactor", XtRInt, sizeof(unsigned),
      XtOffset(Pilot_P, MagFactor), XtRString, "1"},
     {"-magfactor", "*magfactor", XrmoptionSepArg, (caddr_t) NULL}},
    {NULL, "double pixels (magfactor 2)",
     {"double", "Double", XtRInt, sizeof(unsigned),
      XtOffset(Pilot_P, DoublePixels), XtRString, "0"},
     {"-double", "*double", XrmoptionNoArg, (caddr_t) "1"}},
    {NULL, "use a private colormap",
     {"private", "Private", XtRInt, sizeof(unsigned),
      XtOffset(Pilot_P, PrivateColormap), XtRString, "0"},
     {"-private", "*private", XrmoptionNoArg, (caddr_t) "1"}},
    {"<n>", "version of memory",
     {"memversion", "Memversion", XtRInt, sizeof(unsigned),
      XtOffset(Pilot_P, MemVersion), XtRString, "1"},
     {"-memversion", "*memversion", XrmoptionSepArg, (caddr_t) NULL}},
    {NULL, "emulate a reset",
     {"reset", "Reset", XtRInt, sizeof(unsigned),
      XtOffset(Pilot_P, ResetPilot), XtRString, "0"},
     {"-reset", "*reset", XrmoptionNoArg, (caddr_t) "1"}},
    {NULL, "don't check the start vector",
     {"nocheck", "Nocheck", XtRInt, sizeof(unsigned),
      XtOffset(Pilot_P, NoCheck), XtRString, "0"},
     {"-nocheck", "*nocheck", XrmoptionNoArg, (caddr_t) "1"}},
  };

  XtResource *resources = OU_GetResources(ros, XtNumber(ros));
  XrmOptionDescRec *opts = OU_GetOptions(ros, XtNumber(ros));
  const char env_args[] = "XCOPILOTARGS";

  OU_GetEnvironment(env_args, &argv, &argc);

  pilot.topWidget = XtVaOpenApplication(&pilot.context, "XCopilot", opts,
                                        XtNumber(ros), &argc, argv, NULL,
                                        applicationShellWidgetClass, NULL);

  if (argc > 1) {
    int i;

    fprintf(stderr, "%s: unable to handle option%s:", argv[0],
            argc > 2 ? "s" : "");
    for (i = 1; i < argc; i++)
      fprintf(stderr, " %s", argv[i]);
    fprintf(stderr, "\n");
    fprintf(stderr, "usage: %s [options]\n", argv[0]);
    fprintf(stderr, "Where options can be any of the standard Xt options"
            " (e.g. -display, -bg) or\nthe following:\n");
    OU_DumpOptions(ros, XtNumber(ros), stderr);
    fprintf(stderr,
            "Options can also be passed in via the %s environment variable.\n",
            env_args);
    return 1;
  }

  XtGetApplicationResources(pilot.topWidget, &pilot, resources, XtNumber(ros),
                            NULL, 0);

  if (pilot.DoublePixels)
    pilot.MagFactor = 2;

  init(&pilot);
  return 0;
}
