// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <qcombo.h>
#include <qlabel.h>
#include <qmlined.h>
#include <qpushbt.h>
#include "ConsoleWindow.h"

ConsoleWindow::ConsoleWindow()
{
    setCaption( "QWeb: Console" );
    setIconText( "QWeb: Console" );

    _debugLevelLabel = new QLabel( "Debugging Level:", this );

    _debugLevelCombo = new QComboBox( this );
    _debugLevelCombo->insertItem( "Debug" );
    _debugLevelCombo->insertItem( "Warning" );
    _debugLevelCombo->setCurrentItem( 1 );
    
    _mle = new QMultiLineEdit( this );

    _dismiss = new QPushButton( "Dismiss", this );
    connect( _dismiss, SIGNAL( clicked() ), this, SLOT( dismiss() ) );

    resize( 600, 400 );
}

ConsoleWindow::~ConsoleWindow()
{
}

void ConsoleWindow::resizeEvent( QResizeEvent* )
{
    const int pad = 4;
    const int bw  = 100;
    const int bh  = 24;

    _debugLevelLabel->setGeometry( pad, pad, 150, bh );

    _debugLevelCombo->setGeometry( 150 + 2 * pad, pad, 100, bh );
    
    _mle->setGeometry( pad, bh + 2 * pad, width() - 2 * pad, height() - 2 * bh - 4 * pad );
    _mle->setReadOnly( TRUE );

    _dismiss->setGeometry( width() - bw - pad, height() - bh - pad, bw, bh );
}

void ConsoleWindow::dismiss()
{
    hide();
}

void ConsoleWindow::debug( const char* fmt )
{
    if ( _debugLevelCombo->currentItem() > Debug ) return;
    
    QString tmp;
    tmp.sprintf( fmt );
    tmp.prepend( "Debug: " );
    _mle->append( tmp );
    _mle->setCursorPosition( _mle->numLines(), 0 );
}

void ConsoleWindow::debug( const char* fmt, const char* arg1 )
{
    if ( _debugLevelCombo->currentItem() > Debug ) return;

    if ( !arg1 ) arg1 = "(null)";
    
    QString tmp;
    tmp.sprintf( fmt, arg1 );
    tmp.prepend( "Debug: " );
    _mle->append( tmp );
    _mle->setCursorPosition( _mle->numLines(), 0 );
}

void ConsoleWindow::warning( const char* fmt )
{
    if ( _debugLevelCombo->currentItem() > Warning ) return;
    
    QString tmp;
    tmp.sprintf( fmt );
    tmp.prepend( "Warning: " );
    _mle->append( tmp );
    _mle->setCursorPosition( _mle->numLines(), 0 );
}

void ConsoleWindow::warning( const char* fmt, const char* arg1 )
{
    if ( _debugLevelCombo->currentItem() > Warning ) return;

    if ( !arg1 ) arg1 = "(null)";
    
    QString tmp;
    tmp.sprintf( fmt, arg1 );
    tmp.prepend( "Warning: " );
    _mle->append( tmp );
    _mle->setCursorPosition( _mle->numLines(), 0 );
}

void ConsoleWindow::warning( const char* fmt, int arg1 )
{
    if ( _debugLevelCombo->currentItem() > Warning ) return;
    
    QString tmp;
    tmp.sprintf( fmt, arg1 );
    tmp.prepend( "Warning: " );
    _mle->append( tmp );
    _mle->setCursorPosition( _mle->numLines(), 0 );
}

void ConsoleWindow::warning( const char* fmt, int arg1, int arg2 )
{
    if ( _debugLevelCombo->currentItem() > Warning ) return;
    
    QString tmp;
    tmp.sprintf( fmt, arg1, arg2 );
    tmp.prepend( "Warning: " );
    _mle->append( tmp );
    _mle->setCursorPosition( _mle->numLines(), 0 );
}
