// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _Dtd_h_
#define _Dtd_h_

#include <qlist.h>
#include "SgmlElement.h"
#include "SgmlEntity.h"

class StyleEditor;

//: The Dtd class provides a container for an SGML Document Type Declaration.
//. Each Dtd has a style sheet associated with it, to determine how documents
//. of this type are rendered.  The Dtd also manages a StyleEditor for editing
//. its associated style sheet.
class Dtd {
    QString            _soi;
    QList<SgmlEntity>  _entities;
    QList<SgmlElement> _elements;
    SgmlElement*       _start;
public:
    //. Create a new DTD.
    Dtd();

    //. Destroy the DTD, its associated style sheet, and the StylEditor (if
    //. any).
    ~Dtd();

    //. Return the storage object identifier for the DTD.
    QString soi() { return _soi; }

    //. Set the storage object identifier for the DTD.
    void    soi( const QString& soi ) { _soi = soi.copy(); }

    //. Return the entire list of parameter entities.
    QList<SgmlEntity>& entities() { return _entities; }

    //. Lookup a parameter entity reference, and return the text in
    //. <VAR>text</VAR> if found.  Returns TRUE if found.
    bool getEntity( QString name, QString& text );

    //. Return the entire list of elements for this DTD.
    QList<SgmlElement>& elements() { return _elements; }

    //. Lookup the SgmlElement with the given name, and return it if found.
    SgmlElement* getElement( QString name );

    //. Return the starting element for the document type.
    SgmlElement* start() { return _start; }

    //. Set the starting element for the document type.
    void start( SgmlElement* e ) { _start = e; }
};

#endif
