#ifndef __EXPL_VFSL_H__
#define __EXPL_VFSL_H__
// vi:ts=4:sw=4:
// $Id$
//
// $Author$
//
// $Locker$
//
// $State$
//
// $Revision$
//
/*
 * $Log$
 */

#ifdef USE_RCS_ID
static const char rcs_id[]="$Id$";
#endif /* USE_RCS_ID */

/*
 * Explorer Virtual FileSystem Layer
 * CopyLeft 1997 Ruben van Staveren
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif  // HAVE_CONFIG_H

#ifdef HAVE_DLFCN_H
#include <dlfcn.h>
#endif  // HAVE_DLFCN_H

#ifdef SYMBOL_NEEDS_UNDERSCORE
#define DLSYMBOL(a) "_" ## a
#else
#define DLSYMBOL(a) a
#endif  // SYMBOL_NEEDS_UNDERSCORE

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

class vfsldevice;


//
// Stub for creating a object loader for your own vfsl
// Usage: VFSL_CREATE("Zipdevice")
//
// this will assign a instance of the class Zipdevice, which must be derivated
// from vfsldevice at least to a tracking pointer.
//
//	Remark! this macro must be used exactly once!


#define VFSL_CREATE(a)					\
#extern "C" {							\
	static vfsldevice* spDevice=NULL;	\
	const vfsldevice* Opendevice(void)	\
	{									\
		if (!spDevice)					\
			spDevice = new a;			\
		return spDevice->Handler();		\
	}									\
	void Closedevice(void)				\
	{									\
		if (spDevice)					\
			delete spDevice;			\
		spDevice = NULL;				\
	}									\
}										\

#define VFSL_HANDLES(a)					\
#extern "C" {							\
	const char* Devicecapabilities(void)\
	{									\
		return a;						\
	}									\
}										\

class	vfsldevice
{
	// Allocater and tracker for vfsldir's 
	vfsldevice
};


class	vfslfile
{
	// file information calls

	getstat()
	setstat()

	// file io calls

	read(void *buf, size_t buflen);
	write(void *buf, size_t buflen);

};

class   vfsldir
{

	// Allocater and tracker for vfslfile's 

	enum status {errno, action_not_implemented, user_base};

	public:

	vfsldir(const vfsldir *parent);
	virtual ~vfsldir();

	// directory related functions

	int     chdir(const char *);
	const char *getpwd(void);

	int opendir(const char *filename)
	struct dirent *readdir(void);
	int telldir(void);
	int rewinddir(void);
	int closedir(void);
	
	open(const char *filename)
	close(const char *filename)

	getstat()
	setstat()
};



#endif  // __EXPL_VFSL_H__
