#include <sys/param.h>
#include <sys/ucred.h>
#include <sys/mount.h>

#include <stdlib.h>
#include <iostream.h>
#include <errno.h>
#include <string.h>

// vi:ts=4:sw=4
//
// mtab, a mounted filesystems lister
// copyleft 1997 RvS
// 

int main(void)
{
	int iRc=0,
		iNummounts;

	struct statfs	*spStatfs_buf=NULL;

//	if (((iNummounts = getfsstat(NULL, sizeof(struct statfs), MNT_WAIT)) != -1) && (spStatfs_buf = new struct statfs[iNummounts]) && (( iNummounts = getfsstat(spStatfs_buf, iNummounts * sizeof(statfs), MNT_WAIT)) != -1))
	if ((iNummounts = getmntinfo(&spStatfs_buf, MNT_WAIT)) != -1)
	{
		cout << iNummounts << " entries in fstab actually mounted " << endl;
		for (int iCurrentEntry=0; iCurrentEntry < iNummounts; iCurrentEntry++)
		{
			cout	<< "device: " << spStatfs_buf[iCurrentEntry].f_mntfromname 
					<< " fsttype: " << spStatfs_buf[iCurrentEntry].f_fstypename 
					<< " mounted on " << spStatfs_buf[iCurrentEntry].f_mntonname 
					<< endl;
		}
		
//		delete spStatfs_buf;
	}
	else
	{
		cerr << "mtab: " << strerror(errno) << endl;
		iRc = 1;
	}
	return iRc;
}

