/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: ewidgets.cpp,v $
 *
 * $Revision: 1.5 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker: ruben $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: ewidgets.cpp,v $
 * Revision 1.5  1997/07/11 11:05:54  ruben
 * moved hidden option to getopt in main()
 *
 * Revision 1.4  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
// Revision 1.3  1997/05/27  09:10:46  ruben
// Hacked for CopyProgressDlg
//
// Revision 1.3  1997/05/27  09:10:46  ruben
// Hacked for CopyProgressDlg
//
 * Revision 1.2  1997/04/06 21:19:37  ruben
 * reworked char* signals to const char* ones
 * added mounted devices rescan routine
 * added directory notifier, not connected to a rescan operation though
 *
 * Revision 1.1  1997/03/28 17:04:14  ruben
 * Initial revision
 *
 */

//#define __DEBUG__ 1   

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#ifdef USE_RCS_ID
static const char rcs_id[] = "$Id: ewidgets.cpp,v 1.5 1997/07/11 11:05:54 ruben Exp ruben $";
#endif	 /* USE_RCS_ID */

#include <qtooltip.h>
#include <qbttngrp.h>

#include "data_win.h"
#include "diagnostic.h"
#include "ewidgets.h"
#include "dialogs.h"
#include "cursors.h"
#include "plugin_m.h"
#include "ecommand.h"

char temp_cp_dir [PATH_MAX];

/*---------------------------------------------------------------------------*/
/*                                                                           */
/* This functions looks if the file operations are logically permitted.      */
/* It does not check for file permissions                                    */
/*                                                                           */
/*---------------------------------------------------------------------------*/ 
bool ExploreClass::validate_operation (FileTreeNode *target_node,
                                       FileTreeNode *source_list)
{

 FileTreeNode *temp_node=source_list;

 while (temp_node!=NULL)
 {
  if ((temp_node==target_node) && (temp_node->node_selected ()==TRUE))
  {
   QMessageBox::message ("Operation Error",
                         "Source and destination are the same. Do you want\n" \
                         "to continue and remove this entry from the list\n",
                         "Ok");        
   return (FALSE); // yeah we'll fill it in later
  }

  temp_node=temp_node->get_next ();
 }

 //>--------

 if (target_node==source_list->get_parent ())
 {
  QMessageBox::message ("Operation Error",
                        "You cannot copy a file or directory to itself",
                        "Ok");   
  return (FALSE);
 } 

 //>--------

 return (TRUE);
}
/*---------------------------------------------------------------------------*/
void ExploreClass::copy_a_file (char *source,char *target)
{
 int return_val;

 if (operation_busy==FALSE)
 {
   operation_busy=TRUE;

	QStrList szSources;
	// need to do QString(source)). source only gives a segmentviolation.. :(
	szSources.append(QString(source));
	
   CopyProgressDlg copy_dialog(szSources,target,CopyProgressDlg::CopyAs,this);

   #ifdef __DEBUG__
     printf ("Copying [%s] to [%s]\n",source,target);
   #else
     return_val=copy_dialog.exec(); 
   #endif

   operation_busy=FALSE;
 }
}
/*---------------------------------------------------------------------------*/
void ExploreClass::copy_failed (int /* errornum unused */)
{
 //fprintf (stderr,"Copy returned : [%d]\n",errornum);
 //validate_sys_error ();

 //operation_busy=FALSE;  

}
/*---------------------------------------------------------------------------*/
void ExploreClass::copy_complete ()
{
 //operation_busy=FALSE; 
}
/*---------------------------------------------------------------------------*/
void ExploreClass::copy_list (FileTreeNode *temp_list)
{
  int current_t_len;
  int current_s_len;

  while (temp_list!=NULL)
  { 

    if (temp_list->node_selected ()==TRUE)
    {      

       if (temp_list->get_file_type ()==NODE_ISFILE)
       {

          current_t_len = strlen (target_directory);
          current_s_len = strlen (source_directory);

          temp_cp_dir[0] = 0;

          // create proper directory source names

          sprintf (temp_cp_dir,
                   "%s%s",
                   source_directory,
                   temp_list->get_node_name ());

          strcpy (source_directory,
                  temp_cp_dir);

          // create proper directory target names

          sprintf (temp_cp_dir,
                   "%s%s",
                   target_directory,
                   temp_list->get_node_name ());

          strcpy (target_directory,
                  temp_cp_dir);

          copy_a_file (source_directory,target_directory);

          target_directory [current_t_len]=0;
          source_directory [current_s_len]=0;
           
       }
       else
       {

          current_t_len = strlen (target_directory);
          current_s_len = strlen (source_directory);

          temp_cp_dir[0] = 0;

          // create proper directory source names

          sprintf (temp_cp_dir,
                   "%s%s/",
                   source_directory,
                   temp_list->get_node_name ());

          strcpy (source_directory,
                  temp_cp_dir);

          // create proper directory target names

          sprintf (temp_cp_dir,
                   "%s%s/",
                   target_directory,
                   temp_list->get_node_name ());

          strcpy (target_directory,
                  temp_cp_dir);

          create_directory (target_directory,
                            temp_list->get_rights ());

          if (temp_list->get_tree_top ()==NULL)
            read_directory (temp_list,source_directory);

          if (temp_list->get_tree_top ()!=NULL)
          {
           if (temp_list->get_tree_top ()->has_access ()==TRUE)
            temp_list->get_tree_top ()->copy_tree_op ();   
          }

          target_directory [current_t_len]=0;
          source_directory [current_s_len]=0;
       }   

    }

    temp_list=temp_list->get_next ();
  }
}
/*---------------------------------------------------------------------------*/
void ExploreClass::copy_files (bool do_it)
{
 FileTreeNode *temp_target; 
 FileTreeNode *temp_list;

 // char *target_dir; unused

 if (do_it==FALSE)
 {
    temp_target=dirview->get_child ()->get_target ();
    if (temp_target==NULL) // whoops false alarm
     return;

    temp_list  =fileview->get_child ()->get_filelist ();

    //>----------------------------------------------------------
    // first see if the operation we want to perform is valid

    if (validate_operation (temp_target,temp_list)==FALSE)
    {

    }
    else
    {
      // prepare path strings

      target_directory [0]=0;
      source_directory [0]=0;

      // create base dir for target
      //>----------------------------------------------------------      
      compose_dir [0]=0;
      temp_target->set_target (TRUE); 
      root_node->compose_directory ();
      temp_target->set_target (FALSE); 

      strcpy (target_directory,compose_dir); 

      // create base dir for source
      //>----------------------------------------------------------      
      compose_dir [0]=0;
      temp_list->get_parent()->set_target (TRUE); 
      root_node->compose_directory ();
      temp_list->get_parent()->set_target (FALSE); 
      
      strcpy (source_directory,compose_dir);

      // now we show the copy dialog

      // in other words copy "temp_list" to "temp_target"
       
      copy_list (temp_list);

      // hide the copy dialog

      //copy_dialog->hide ();
    }

    dragging_and_dropping (FALSE);

    // remove target from tree and refresh widgets
    root_node->remove_targets();
    dirview->get_child ()->deselect ();

    dirview->get_child ()->update ();
    fileview->get_child ()->update ();
  }
}
/*---------------------------------------------------------------------------*/
void ExploreClass::move_list (FileTreeNode *temp_list)
{
  int current_t_len;
  int current_s_len;

  while (temp_list!=NULL)
  { 

    if (temp_list->node_selected ()==TRUE)
    {      

       if (temp_list->get_file_type ()==NODE_ISFILE)
       {

          current_t_len = strlen (target_directory);
          current_s_len = strlen (source_directory);

          temp_cp_dir[0] = 0;

          // create proper directory source names

          sprintf (temp_cp_dir,
                   "%s%s",
                   source_directory,
                   temp_list->get_node_name ());

          strcpy (source_directory,
                  temp_cp_dir);

          // create proper directory target names

          sprintf (temp_cp_dir,
                   "%s%s",
                   target_directory,
                   temp_list->get_node_name ());

          strcpy (target_directory,
                  temp_cp_dir);

          copy_a_file (source_directory,target_directory);
          remove_a_file (source_directory); 

          target_directory [current_t_len]=0;
          source_directory [current_s_len]=0;
           
       }
       else
       {

          current_t_len = strlen (target_directory);
          current_s_len = strlen (source_directory);

          temp_cp_dir[0] = 0;

          // create proper directory source names

          sprintf (temp_cp_dir,
                   "%s%s/",
                   source_directory,
                   temp_list->get_node_name ());

          strcpy (source_directory,
                  temp_cp_dir);

          // create proper directory target names

          sprintf (temp_cp_dir,
                   "%s%s/",
                   target_directory,
                   temp_list->get_node_name ());

          strcpy (target_directory,
                  temp_cp_dir);

          create_directory (target_directory,temp_list->get_rights ());

          if (temp_list->get_tree_top ()==NULL)
            read_directory (temp_list,source_directory);

          if (temp_list->get_tree_top ()!=NULL)
          {
           if (temp_list->get_tree_top ()->has_access ()==TRUE)
            temp_list->get_tree_top ()->move_tree_op ();   
          }

          remove_a_dir (source_directory); 

          target_directory [current_t_len]=0;
          source_directory [current_s_len]=0;
       }   

    }

    temp_list=temp_list->get_next ();
  }
}
/*---------------------------------------------------------------------------*/
void ExploreClass::move_files (bool do_it) 
{
 FileTreeNode *temp_target; 
 FileTreeNode *temp_list;

 // char *target_dir; unused

 if (do_it==FALSE)
 {
    temp_target=dirview->get_child ()->get_target ();
    if (temp_target==NULL) // whoops false alarm
     return;

    temp_list  =fileview->get_child ()->get_filelist ();

    //>----------------------------------------------------------
    // first see if the operation we want to perform is valid

    if (validate_operation (temp_target,temp_list)==FALSE)
    {

    }
    else
    {
      // prepare path strings

      target_directory [0]=0;
      source_directory [0]=0;

      // create base dir for target
      //>----------------------------------------------------------      
      compose_dir [0]=0;
      temp_target->set_target (TRUE); 
      root_node->compose_directory ();
      temp_target->set_target (FALSE); 

      strcpy (target_directory,compose_dir); 

      // create base dir for source
      //>----------------------------------------------------------      
      compose_dir [0]=0;
      temp_list->get_parent()->set_target (TRUE); 
      root_node->compose_directory ();
      temp_list->get_parent()->set_target (FALSE); 
      
      strcpy (source_directory,compose_dir);

      // in other words move "temp_list" to "temp_target"
       
      move_list (temp_list);

      // hide the copy dialog

      // copy_dialog->hide ();
    }

    dragging_and_dropping (FALSE);

    // remove target from tree and refresh widgets
    root_node->remove_targets();
    dirview->get_child ()->deselect ();

    dirview->get_child ()->update ();
    fileview->get_child ()->update ();
  }
}
/*---------------------------------------------------------------------------*/
void ExploreClass::remove_list (FileTreeNode *temp_list)
{
  int current_t_len;
  int current_s_len;

  while (temp_list!=NULL)
  { 

    if (temp_list->node_selected ()==TRUE)
    {      

       if (temp_list->get_file_type ()==NODE_ISFILE)
       {

          current_t_len = strlen (target_directory);
          current_s_len = strlen (source_directory);

          temp_cp_dir[0] = 0;

          // create proper directory source names

          sprintf (temp_cp_dir,
                   "%s%s",
                   source_directory,
                   temp_list->get_node_name ());

          strcpy (source_directory,
                  temp_cp_dir);

          // create proper directory target names

          sprintf (temp_cp_dir,
                   "%s%s",
                   target_directory,
                   temp_list->get_node_name ());

          strcpy (target_directory,
                  temp_cp_dir);

          remove_a_file (source_directory); 

          target_directory [current_t_len]=0;
          source_directory [current_s_len]=0;
           
       }
       else
       {

          current_t_len = strlen (target_directory);
          current_s_len = strlen (source_directory);

          temp_cp_dir[0] = 0;

          // create proper directory source names

          sprintf (temp_cp_dir,
                   "%s%s/",
                   source_directory,
                   temp_list->get_node_name ());

          strcpy (source_directory,
                  temp_cp_dir);

          // create proper directory target names

          sprintf (temp_cp_dir,
                   "%s%s/",
                   target_directory,
                   temp_list->get_node_name ());

          strcpy (target_directory,
                  temp_cp_dir);


          if (temp_list->get_tree_top ()==NULL)
            read_directory (temp_list,source_directory);

          if (temp_list->get_tree_top ()!=NULL)
          {
           if (temp_list->get_tree_top ()->has_access ()==TRUE)
            temp_list->get_tree_top ()->remove_tree_op ();   
          }

          remove_a_dir (source_directory); 

          target_directory [current_t_len]=0;
          source_directory [current_s_len]=0;
       }   

    }

    temp_list=temp_list->get_next ();
  }
}
/*---------------------------------------------------------------------------*/
void ExploreClass::delete_files ()
{
 FileTreeNode *temp_list;

 temp_list  =fileview->get_child ()->get_filelist ();

 // prepare path strings

 source_directory [0]=0;

 // create base dir for source
 //>----------------------------------------------------------      
 
 compose_dir [0]=0;
 temp_list->get_parent()->set_target (TRUE); 
 root_node->compose_directory ();
 temp_list->get_parent()->set_target (FALSE); 
      
 strcpy (source_directory,compose_dir);

 remove_list (temp_list);

 // hide the copy dialog

 // copy_dialog->hide ();

 dragging_and_dropping (FALSE);

 dirview->get_child ()->deselect ();

 dirview->get_child ()->update ();
 fileview->get_child ()->update ();
}
/*---------------------------------------------------------------------------*/
void ExploreClass::remove_a_file (char *s1)
{
  int return_val;

  #ifdef __DEBUG__
    printf ("Removing file [%s]\n",s1);
  #else
    return_val=remove (s1);
  
    if (return_val==-1)
     validate_sys_error ();
  #endif
}
/*---------------------------------------------------------------------------*/
/*  Curious note about this function:                                        */
/*    It turned out that the shell accepts the command                       */
/*      rmdir /root/dummydir/                                                */ 
/*    But the "rmdir" function only accepts                                  */
/*      rmdir /root/dummydir                                                 */ 
/*---------------------------------------------------------------------------*/
void ExploreClass::remove_a_dir (char *new_path)
{
  int return_val;

  #ifdef __DEBUG__
    printf ("Removing directory [%s]\n",new_path);
  #else
    sprintf (temp_cp_dir,new_path);

    if (temp_cp_dir [strlen (temp_cp_dir)-1]=='/')
     temp_cp_dir [strlen (temp_cp_dir)-1]=0;

    return_val=rmdir (temp_cp_dir);

    if (return_val==-1)
     validate_sys_error ();
  #endif
}
/*---------------------------------------------------------------------------*/
/* This function responds to a signal from the Properties Dialog             */
/*---------------------------------------------------------------------------*/
void ExploreClass::delete_file (char * /*path_to_node unused */,
                                FileTreeNode * /* node_used unused */ )
{
 // blame it on another function :)
 delete_files ();
}
/*---------------------------------------------------------------------------*/
void ExploreClass::read_directory (FileTreeNode *attach,char *source_path)
{
 #ifdef __DEBUG__
   printf ("Reading undefined dir [%s]\n",source_path);
 #endif

 io_tools->vfsl_read_directory (attach,source_path);
}
/*---------------------------------------------------------------------------*/
void ExploreClass::create_directory (char *new_path,unsigned long file_prot)
{
 int return_val;

 #ifdef __DEBUG__
   printf ("Creating directory [%s]\n",new_path);
 #else

   sprintf (temp_cp_dir,new_path);

   if (temp_cp_dir [strlen (temp_cp_dir)-1]=='/')
    temp_cp_dir [strlen (temp_cp_dir)-1]=0;

   return_val=mkdir (temp_cp_dir,file_prot);

   if (return_val==-1)
     validate_sys_error ();
 #endif
}
/*---------------------------------------------------------------------------*/
void ExploreClass::file_properties (const char *old_pth,
                                    const char * /*new_pth unused */,
                                    FileTreeNode *node_used)
{ 
  struct stat temp_stat;

  //printf ("Determening rights for: [%s]\n",old_pth);
  lstat (old_pth,
         &temp_stat);
       
  node_used->set_file_rights (temp_stat.st_mode);
 
  //emit update_widgets ();
  fileview->get_child ()->update ();
}
/*---------------------------------------------------------------------------*/
void ExploreClass::link_file (char *path_to_node)
{
 LinkFrame *temp_dialog=new LinkFrame (0,NULL,path_to_node);
 temp_dialog->show (); 
}
/*---------------------------------------------------------------------------*/
void ExploreClass::op_cancel (bool /* do_it unused */)
{
 // all this does is: deselect,remove target, update

 dragging_and_dropping (FALSE);

 root_node->remove_targets();
 dirview->get_child ()->deselect ();

 dirview->get_child ()->update ();
 fileview->get_child ()->update ();
}
/*---------------------------------------------------------------------------*/




              // sofar the file operations, now on with the show




/*---------------------------------------------------------------------------*/
void ExploreClass::show_toolbar ()
{
 if (tb_show==FALSE)
 {
  tb_show=TRUE;
 
  umount_button->show ();
  dir_box->show ();
  btn1->show ();
  btn2->show ();
  btn3->show ();
  btn4->show ();
  btn5->show ();
  btn6->show ();
  btn7->show ();
  btn8->show ();
  btn9->show ();
  btn10->show ();
  btn11->show ();
 } 
 else
 {
  tb_show=FALSE;

  umount_button->hide ();
  dir_box->hide ();
  btn1->hide ();
  btn2->hide ();
  btn3->hide ();
  btn4->hide ();
  btn5->hide ();
  btn6->hide ();
  btn7->hide ();
  btn8->hide ();
  btn9->hide ();
  btn10->hide ();
  btn11->hide ();
 }

 re_layout ();
}
/*---------------------------------------------------------------------------*/
void ExploreClass::show_statusbar ()
{
 if (sb_show==FALSE)
 {
  sb_show=TRUE;
  frame3->show ();
  frame4->show ();  
 } 
 else
 {
  sb_show=FALSE;
  frame3->hide ();
  frame4->hide ();  
 }

 re_layout ();
}
/*---------------------------------------------------------------------------*/
void ExploreClass::show_framebar ()
{
 if (fr_show==FALSE)
 {
  fr_show=TRUE;
  frame1->show ();
  frame2->show (); 
 } 
 else
 {
  fr_show=FALSE;
  frame1->hide ();
  frame2->hide ();  
 }

 re_layout ();
}
/*---------------------------------------------------------------------------*/
void ExploreClass::show_pluginview ()
{
 if (pl_show==FALSE)
 {
  pl_show=TRUE;
  pl_manager->show ();
 } 
 else
 {
  pl_show=FALSE; 
  pl_manager->hide ();
 }

 re_layout ();
}
/*---------------------------------------------------------------------------*/
void ExploreClass::mouse_movement (QPoint &a_point)
{
 QPoint new_coors=mapFromGlobal(a_point);
 cursor_label->move (new_coors.x(),new_coors.y());
}
/*---------------------------------------------------------------------------*/
void ExploreClass::dragging_and_dropping(bool yes_or_no)
{
 if ((yes_or_no == TRUE) && (multiple_select==FALSE))
   cursor_label->show (); 
 else
 {
   cursor_label->hide ();
   cursor_label->move (-50,-50);
 }

 emit dnd_change (yes_or_no);
}
/*---------------------------------------------------------------------------*/
void ExploreClass::re_layout (void)
{

    delete gm_00; 
    delete gm_01;
    delete gm_02;
    delete gm_03;
    delete gm_04;

    delete gm;

	gm = new QBoxLayout(this,
						QBoxLayout::TopToBottom, 3, 3);

	gm_00 = new QBoxLayout(QBoxLayout::LeftToRight, 0);
	gm_01 = new QBoxLayout(QBoxLayout::LeftToRight);
	gm_02 = new QBoxLayout(QBoxLayout::LeftToRight);
	gm_03 = new QBoxLayout(QBoxLayout::LeftToRight);
	gm_04 = new QBoxLayout(QBoxLayout::LeftToRight);

    if (tb_show==TRUE)
      gm->addLayout(gm_00, 0);

    if (fr_show==TRUE)
      gm->addLayout(gm_01, 0);

	gm->addLayout(gm_02, 50);

    if (pl_show==TRUE)
      gm->addLayout(gm_04, 20);

    if (sb_show==TRUE)
      gm->addLayout(gm_03, 0);


    // we always have a menu bar, but it could be removed
	gm->setMenuBar (expl_menu->get_menu());

	// >------------ button toolbar

    if (tb_show==TRUE)
    { 
      gm_00->addWidget(umount_button, 0);

      gm_00->addSpacing(5);

      gm_00->addWidget(dir_box, 0);

      gm_00->addSpacing(5);

      gm_00->addWidget(btn1, 0);

      gm_00->addSpacing(5);

      gm_00->addWidget(btn2, 0);

      gm_00->addWidget(btn3, 0);

      gm_00->addWidget(btn4, 0);

      gm_00->addSpacing(5);

      gm_00->addWidget(btn5, 0);

      gm_00->addSpacing(5);

      gm_00->addWidget(btn6, 0);

      gm_00->addWidget(btn7, 0);

      gm_00->addSpacing(5);

      gm_00->addWidget(btn8, 0);

      gm_00->addWidget(btn9, 0);

      gm_00->addWidget(btn10, 0);

      gm_00->addWidget(btn11, 0);

      gm_00->addStretch(100);
    }

    if (fr_show==TRUE)
    {
       gm_01->addWidget(frame1, 0);
       gm_01->addWidget(frame2, 0);
    }

	gm_02->addWidget(dirview, 100);

	gm_02->addWidget(fileview, 100);

    if (pl_show==TRUE)
    {
       gm_04->addWidget (pl_manager,0);
    }

    if (sb_show==TRUE)
    {
       gm_03->addWidget(frame3, 0);
       gm_03->addWidget(frame4, 50);
    }

	gm->activate();
}
/*---------------------------------------------------------------------------*/
void ExploreClass::create_controls (char *backgr_name)
{

    QPixmap *backgr_map=NULL;

    if (backgr_name!=NULL)
    {
     backgr_map=new QPixmap;
     if (!(backgr_map->load (backgr_name)))
     {
      printf ("Unable to load: [%s]\n",backgr_name); // was backgr_map, fixed RvS   
      backgr_map=NULL;
     }
    } 

	// >------------ create a new layout manager

    //mouse_label=new QLabel;
    //mouse_label->setFrameStyle (QFrame::WinPanel | QFrame::Plain); 
    //mouse_label->resize (32,22);    

    //mouse_label=new QLabel (this,0,0);
    //mouse_label->setFrameStyle (QFrame::WinPanel | QFrame::Plain); 
    //mouse_label->resize (32,22);  
    //mouse_label->recreate (0,WType_Popup,FALSE);

    // >---- create popup tools

	mouse_popup = new OptionsPopup  (0, 0);
	op_popup    = new OperationPopup(0, 0);

	gm = new QBoxLayout(this,
						QBoxLayout::TopToBottom, 3, 3);

	gm_00 = new QBoxLayout(QBoxLayout::LeftToRight, 0);
	gm_01 = new QBoxLayout(QBoxLayout::LeftToRight);
	gm_02 = new QBoxLayout(QBoxLayout::LeftToRight);
    gm_04 = new QBoxLayout(QBoxLayout::LeftToRight);
	gm_03 = new QBoxLayout(QBoxLayout::LeftToRight);

	gm->addLayout (gm_00,0);
	gm->addLayout (gm_01,0);
	gm->addLayout (gm_02,50);
    gm->addLayout (gm_04,20);
	gm->addLayout (gm_03,0);

	// >------------ add top menu

	expl_menu = new ExplorerMenu(this, "menu");
	gm->setMenuBar(expl_menu->get_menu());

	// >------------ button toolbar

	umount_button = new QPushButton(this, "mount_box");
	umount_button->setPixmap(*pm[ICON_12]);
	umount_button->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	umount_button->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
    QToolTip::add (umount_button,"Unmount current mount point");
	gm_00->addWidget(umount_button, 0);

	gm_00->addSpacing(5);

	dir_box = new MountBox(this, "choose_box");
	dir_box->setMinimumSize(170, 22);
	dir_box->setMaximumSize(170, 22);
    QToolTip::add (dir_box,"Choose a mount point");
	show_mount(dir_box);
	gm_00->addWidget(dir_box, 0);

	gm_00->addSpacing(5);

	btn1 = new QPushButton(this, "num1");
	btn1->setPixmap(*pm[ICON_01]);
	btn1->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn1->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
    QToolTip::add (btn1,"Go up one directory");
	gm_00->addWidget(btn1, 0);

	gm_00->addSpacing(5);

	btn2 = new QPushButton(this, "num2");
	btn2->setPixmap(*pm[ICON_02]);
	btn2->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn2->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
    QToolTip::add (btn2,"Cut to clipboard");
	gm_00->addWidget(btn2, 0);

	btn3 = new QPushButton(this, "num3");
	btn3->setPixmap(*pm[ICON_03]);
	btn3->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn3->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
    QToolTip::add (btn3,"Paste from clipboard");
	gm_00->addWidget(btn3, 0);

	btn4 = new QPushButton(this, "num4");
	btn4->setPixmap(*pm[ICON_04]);
	btn4->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn4->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
    QToolTip::add (btn4,"Paste from clipboard");
	gm_00->addWidget(btn4, 0);

	gm_00->addSpacing(5);

	btn5 = new QPushButton(this, "num5");
	btn5->setPixmap(*pm[ICON_05]);
	btn5->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn5->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
    QToolTip::add (btn5,"Undo last action");
	gm_00->addWidget(btn5, 0);

	gm_00->addSpacing(5);

	btn6 = new QPushButton(this, "num6");
	btn6->setPixmap(*pm[ICON_06]);
	btn6->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn6->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
    QToolTip::add (btn6,"Delete file(s) or directory");
	gm_00->addWidget(btn6, 0);

	btn7 = new QPushButton(this, "num7");
	btn7->setPixmap(*pm[ICON_07]);
	btn7->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn7->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
    QToolTip::add (btn7,"Properties");
	gm_00->addWidget(btn7, 0);

	gm_00->addSpacing(5);

	// >----------- view pane toggles and trickels

    QButtonGroup *buttongroup=new QButtonGroup;
    buttongroup->setExclusive (TRUE);

	btn8 = new QPushButton(this, "num8");
	btn8->setPixmap(*pm[ICON_08]);
	btn8->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn8->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn8->setToggleButton(TRUE);
    QToolTip::add (btn8,"Large Icons");

    buttongroup->insert (btn8,-1);
	gm_00->addWidget(btn8, 0);

	btn9 = new QPushButton(this, "num9");
	btn9->setPixmap(*pm[ICON_09]);
	btn9->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn9->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn9->setToggleButton(TRUE);
    QToolTip::add (btn9,"Small Icons");

    buttongroup->insert (btn9,-1);
	gm_00->addWidget(btn9, 0);

	btn10 = new QPushButton(this, "num10");
	btn10->setPixmap(*pm[ICON_10]);
	btn10->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn10->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn10->setToggleButton(TRUE);
    QToolTip::add (btn10,"List");

    buttongroup->insert (btn10,-1);
	gm_00->addWidget(btn10, 0);

	btn11 = new QPushButton(this, "num11");
	btn11->setPixmap(*pm[ICON_11]);
	btn11->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn11->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn11->setToggleButton(TRUE);
    btn11->setOn (TRUE);
    QToolTip::add (btn11,"Details");

    buttongroup->insert (btn11,-1);
	gm_00->addWidget(btn11, 0);

	gm_00->addStretch(100);

	// >------------ indicator panels

	frame1 = new ECommandClass(this, "left_pane");
	gm_01->addWidget(frame1, 0);

	frame2 = new DirectoryFrame(this, "right_pane");
	gm_01->addWidget(frame2, 0);

	// >------------ the actual left and right file/dir panes

	dirview = new DirTreeContainer(this,
								   "dirview",
								   io_tools,
                                   mouse_popup,
                                   op_popup);
	dirview->setMinimumSize(200, 200);
	gm_02->addWidget(dirview, 100);

	fileview = new FileListContainer(this,
									 "fileview",
									 io_tools,
                                     mouse_popup,
                                     op_popup);
	fileview->setMinimumSize(200, 200);
	gm_02->addWidget(fileview, 100);


    // >------------ multiline edit for the plugin manager

    pl_manager =new EPluginManager (this, "plugin_view");
    pl_manager->setBackgroundColor(white);
    pl_manager->setReadOnly (TRUE);
    gm_04->addWidget (pl_manager,100);

	// >------------ more indicator panels

	frame3 = new ObjectFrame(this, "left_pane");
	gm_03->addWidget(frame3, 0);

	frame4 = new FileFrame(this, "right_pane");
	gm_03->addWidget(frame4, 50);

	// >------------ activate the manager

	gm->activate();

	setIcon(*pm[NODE_EXPLORER]);
	setCaption("" EXPLORER_MACHNAME " Explorer");
	setMinimumSize(510, 430);

	// >---- configure data widgets

	dirview->get_child()->set_root_node(root_node);

    if (backgr_name!=NULL)
     dirview->get_child ()->setBackgroundPixmap (*backgr_map);
    else
     dirview->get_child ()->setBackgroundColor(white);

	fileview->get_child ()->set_root_node(root_node->get_tree_top());

    if (backgr_name!=NULL)
     fileview->get_child ()->setBackgroundPixmap (*backgr_map);
    else
     fileview->get_child ()->setBackgroundColor(white);

    fileview->get_child ()->set_the_root(root_node);


    cursor_label=new QLabel (this,0);
    cursor_label->move (-50,-50);    
	cursor_label->setMaximumSize(pm [NODE_FILECLOSED]->width(), 
                                 pm [NODE_FILECLOSED]->height());
	cursor_label->setMinimumSize(pm [NODE_FILECLOSED]->width(), 
                                 pm [NODE_FILECLOSED]->height());
	cursor_label->setBackgroundPixmap(*pm [NODE_FILECLOSED]);

}
/*---------------------------------------------------------------------------*/
void ExploreClass::setup_filesystem(void)
{

	struct utsname temp_uname;

	// >------------ initialise struct with default names
	strcpy(temp_uname.nodename, "This Computer");
	strcpy(temp_uname.sysname, "Unix"); 


	// >------------ start with the root directory

	root_node = new FileTreeNode(NULL,
								 NODE_DESKTOP,
								 NODE_NEXT,
								 NODE_ISDIR,
								 "/");
	uname(&temp_uname);
	sprintf(temp_string,
			"%s [ %s ]",
			temp_uname.nodename,
			temp_uname.sysname);

	root_node->set_file_info(temp_string,
							 0, 0,
							 TRUE,
							 TRUE);
	root_node->set_expandable(NODE_EXPANDED);
	io_tools->vfsl_read_directory(root_node, "/");	// read initial directory

}
/*---------------------------------------------------------------------------*/
void    ExploreClass::setup_general(void)
{
	// >------------ set up mouse cursor for drag and drop

	QBitmap *cb1 = new QBitmap(CURSOR_X, CURSOR_Y, move_file_cur_bits, FALSE);
	QBitmap *cm1 = new QBitmap(CURSOR_X, CURSOR_Y, move_file_msk_bits, FALSE);

	QBitmap *cb2 = new QBitmap(CURSOR_X, CURSOR_Y, move_map_cur_bits, FALSE);
	QBitmap *cm2 = new QBitmap(CURSOR_X, CURSOR_Y, move_map_msk_bits, FALSE);

	QBitmap *cb3 = new QBitmap(CURSOR_X, CURSOR_Y, stop_cur_bits, FALSE);
	QBitmap *cm3 = new QBitmap(CURSOR_X, CURSOR_Y, stop_msk_bits, FALSE);

	move_file_cursor = new QCursor(*cb1, *cm1);
	move_map_cursor = new QCursor(*cb2, *cm2);
	move_stop_cursor = new QCursor(*cb3, *cm3);

	// >------------ determen font style

	QFont  *app_font = new QFont("Helvetica", 10);

	app_font->setBold(TRUE);

	qApp->setFont(*app_font, TRUE);

#ifdef EXPLORER_WIN95_INTERFACE
	qApp->setStyle(WindowsStyle);
#endif /* EXPLORER_WIN95_INTERFACE */
}
/*---------------------------------------------------------------------------*/
void    ExploreClass::signals_n_slots(void)
{
	// >------ install a SIGNAL handler
	//
	// RvS TODO! signal semantics differ a great deal on SVr4 and BSD4.4
	// SVr4 signals are unreliable and can slip trough...
	// 

	typedef void (*signal_handler)(...);
	
	signal(SIGINT, (signal_handler)SigHandler);
	signal(SIGQUIT, (signal_handler)SigHandler);
	signal(SIGFPE, (signal_handler)SigHandler);
	signal(SIGSEGV, (signal_handler)SigHandler);
	signal(SIGBUS, (signal_handler)SigHandler);
	signal(SIGPIPE, (signal_handler)SigHandler);
	signal(SIGTERM, (signal_handler)SigHandler);
	signal(SIGCHLD, (signal_handler)SigHandler);

	// >------ connect the signals wich make sure a pane can let all other
	// >------ panes know it must update their views

	connect(dirview->get_child(), 
            SIGNAL(update_widgets()),
			fileview->get_child(), 
            SLOT(update_pane()));

	connect(fileview->get_child(), 
            SIGNAL(update_widgets()),
			dirview->get_child(), 
            SLOT(update_pane()));

	// >------ let the tree view signal the list view it should focus on
	// >------ a different node as top of it's list

	connect(dirview->get_child(), 
            SIGNAL(update_root_node(FileTreeNode *)),
			fileview->get_child(), 
            SLOT(reset_root_node(FileTreeNode *)));

	connect(fileview->get_child(), 
            SIGNAL(change_dir(FileTreeNode *)),
			dirview->get_child(), 
            SLOT(change_dir(FileTreeNode *)));

	// >------ connect the widgets to info labels

	connect(dirview->get_child(),
			SIGNAL(set_dir_info(const char *)),
			frame2,
			SLOT(set_text(const char *)));

	connect(dirview->get_child(),
			SIGNAL(set_dir_info(const char *)),
			dirchanged_notifier,
			SLOT(startNotify(const char *)));

    // added the Notifier for the root dir (Mvv)
    dirchanged_notifier->startNotify ("/");

    connect (dirchanged_notifier,
             SIGNAL (fileChanged (const char *)),
             fileview->get_child (),
             SLOT (reread_dir (const char *)));
	
	connect(fileview->get_child(),
			SIGNAL(set_nr_objects(int)),
			frame3,
			SLOT    (set_objects(int)));

	connect(fileview->get_child(),
			SIGNAL(set_files_info(int, unsigned long)),
			frame4,
			SLOT    (set_info(int, unsigned long)));

	// >----- make selections mutual exclusive for view panes


    // let yourself know you have focus
    connect (dirview->get_child (),
             SIGNAL (take_focus ()),
             dirview->get_child (),
             SLOT (set_focus ()));

    // remove focus from all other widgets
    connect (dirview->get_child (),
             SIGNAL (take_focus ()),
             fileview->get_child (),
             SLOT (remove_focus ()));

    // let yourself know you have focus
    connect (fileview->get_child (),
             SIGNAL (take_focus ()),
             fileview->get_child (),
             SLOT (set_focus ()));

    // remove focus from all other widgets
    connect (fileview->get_child (),
             SIGNAL (take_focus ()),
             dirview->get_child (),
             SLOT (remove_focus ()));

	connect(dirview->get_child(),
			SIGNAL(remove_selection()),
			fileview->get_child(),
			SLOT(selection_removed()));

	connect(fileview->get_child(),
			SIGNAL(remove_selection()),
			dirview->get_child(),
			SLOT(selection_removed()));

    // >----- rework around the silly mouse problem

    connect (fileview->get_child (),
             SIGNAL(signal_movement (QPoint &)),
             dirview->get_child (),
             SLOT (remoteMoveEvent (QPoint &)));

    connect (fileview->get_child (),
             SIGNAL(signal_movement (QPoint &)),
             this,
             SLOT (mouse_movement (QPoint &)));   

	// >----- make sure the cursors indicate the correct state 
	// >----- when dragging and dropping


        // connect to parent
  
    connect(dirview->get_child(),
			SIGNAL(dragging_and_dropping(bool)),
			this,
			SLOT(copy_files (bool)));
    
    connect(fileview->get_child(),
			SIGNAL(dragging_and_dropping(bool)),
			this,
			SLOT(copy_files (bool)));

	connect(dirview->get_child(),
			SIGNAL(dragging_and_dropping(bool)),
			this,
			SLOT(dragging_and_dropping(bool)));

	connect(fileview->get_child(),
			SIGNAL(dragging_and_dropping(bool)),
			this,
			SLOT(dragging_and_dropping(bool)));

        // connect to each other

	connect(dirview->get_child(),
			SIGNAL(dragging_and_dropping(bool)),
			fileview->get_child(),
			SLOT(drag_and_drop(bool)));

	connect(fileview->get_child(),
			SIGNAL(dragging_and_dropping(bool)),
			dirview->get_child(),
			SLOT(drag_and_drop(bool)));

        // connect to yourself

	connect(dirview->get_child(),
			SIGNAL(dragging_and_dropping(bool)),
			dirview->get_child(),
			SLOT(drag_and_drop(bool)));

	connect(fileview->get_child(),
			SIGNAL(dragging_and_dropping(bool)),
			fileview->get_child(),
			SLOT(drag_and_drop(bool)));

        // connect the dnd manager to children

    connect (this,
             SIGNAL (dnd_change (bool)), 
             fileview->get_child(),             
             SLOT (drag_and_drop (bool)));

    connect (this,
             SIGNAL (dnd_change (bool)), 
             dirview->get_child(),             
             SLOT (drag_and_drop (bool)));

	// >----- Connect the mount box

	connect(dir_box,
			SIGNAL(goto_mount_point(const char *)),
			dirview->get_child(),
			SLOT    (goto_dir(const char *)));

	// >----- Connect menu options 

	connect(expl_menu,
			SIGNAL(go_to(const char *)),
			dirview->get_child(),
			SLOT    (goto_dir(const char *)));

	connect(expl_menu,
			SIGNAL(do_select_all()),
			fileview->get_child(),
			SLOT(select_all()));

	connect(expl_menu,
			SIGNAL(do_select_inverse ()),
			fileview->get_child(),
			SLOT(select_inverse()));

    connect (expl_menu,
             SIGNAL (show_toolbar()),
             this,
             SLOT (show_toolbar())); 

    connect (expl_menu,
             SIGNAL (show_statusbar()),
             this,
             SLOT (show_statusbar())); 

    connect (expl_menu,
             SIGNAL (show_framebar()),
             this,
             SLOT (show_framebar())); 

    connect (expl_menu,
             SIGNAL (show_pluginframe()),
             this,
             SLOT (show_pluginview())); 

	connect (expl_menu,
             SIGNAL(rescan_mtab()), 
             dir_box,
             SLOT(getMountedfss()));

    connect (expl_menu,
             SIGNAL (rescan_dir ()),
             fileview->get_child (),
             SLOT (reread_list ()));

	connect(umount_button,
			SIGNAL(clicked()),
			dir_box,
			SLOT(unmount()));


    // >---- Connect popup menus

    connect (mouse_popup,
             SIGNAL (emit_link (char *)),
             this,
             SLOT (link_file (char *)));

    connect (mouse_popup,
             SIGNAL (emit_delete (char *,FileTreeNode *)),
             this,
             SLOT (delete_file (char *,FileTreeNode *)));

    connect (mouse_popup,
             SIGNAL (emit_delete_nodes ()),
             this,
             SLOT (delete_files ()));

    connect (mouse_popup,
             SIGNAL (emit_prop_change (const char *,const char *,FileTreeNode *)),
             this,
             SLOT (file_properties (const char *,const char *,FileTreeNode *)));

    // >----- Connect some other stuff ( actually what it's all about )

    connect (io_tools,
             SIGNAL (sig_copy_a_file (char *,char *)),
             this,
             SLOT (copy_a_file (char *,char *)));

    connect (io_tools,
             SIGNAL (sig_read_directory (FileTreeNode *,char *)),
             this,
             SLOT (read_directory (FileTreeNode *,char *))); 

    connect (io_tools,
             SIGNAL (sig_create_directory (char *,unsigned long)),
             this,
             SLOT (create_directory (char *,unsigned long)));

    connect (io_tools,
             SIGNAL (sig_remove_a_dir (char *)),
             this,
             SLOT (remove_a_dir (char *)));

    connect (io_tools,
             SIGNAL (sig_remove_a_file (char *)),
             this,
             SLOT (remove_a_file (char *)));

    // connect operation popup to actual file ops

    connect (op_popup,
             SIGNAL (op_cancel (bool)),
             this,
             SLOT (op_cancel (bool)));

    connect (op_popup,
             SIGNAL (op_copy (bool)),
             this,
             SLOT (copy_files (bool)));

    connect (op_popup,
             SIGNAL (op_move (bool)),
             this,
             SLOT (move_files (bool))); 
}
/*---------------------------------------------------------------------------*/
ExploreClass::ExploreClass (QWidget * parent,
                            const char *name,
                            char *backgr_name) : QWidget(parent,
                                                            name)
{

    //>-------- first some undocumented stuff *grins*

	// not undocumented anymore :) RvS
	// Sorry, I need to move this to main because of the piccy getopt(3)
	
    //>-------- create a pointer to a copydialog for easy access


    //>-------- create config class

	explorer_config = new ConfigClass;

    tb_show=TRUE;
    sb_show=TRUE;
    fr_show=TRUE;
    pl_show=TRUE;

    //>-------- here we create the VFSL layer  

	io_tools = new VFSL_Class;

    //>-------- init notifiers

	dirchanged_notifier = new FileNotify (SCAN_INTERVAL);

	if (explorer_config->load_resources() != KERNEL_OK)
		exit(1);
    
	/* 
	 * if (read_types ()!=KERNEL_OK) exit (1); 
	 */

	// >---- determen some general stuff 

	setup_general();

	// >---- setup the stuff that it is all about

	setup_filesystem();

	// >---- setup the user interface parts

	create_controls (backgr_name);

    // >---- let the plugin manager setup all the plugins it can find

    pl_manager->load_plugins ();  

    io_tools->assign_plugin_list (pl_manager->get_plugin_list ());

	// >---- setup all global signals and slots

	signals_n_slots();

	// >---- the explorer should be set up now 

}
/*---------------------------------------------------------------------------*/
ExploreClass::~ExploreClass()
{
 pl_manager->unload_plugins ();

 delete mouse_popup;
 delete op_popup;

 delete io_tools;
 delete pl_manager;

 explorer_config->unload_resources();
 delete explorer_config;
}
/*---------------------------------------------------------------------------*/
/*
 * void ExploreClass::update_panes ()
 * {
 * 
 * }
 *
 *---------------------------------------------------------------------------*/





				   // >-------- Explorer (File Open/Save) dialog version





/*---------------------------------------------------------------------------*/
void ExploreFindClass::dragging_and_dropping(bool /* yes_or_no  unused*/)
{
/* 
 * if (yes_or_no==TRUE)
 * {
 * setCursor (*move_stop_cursor);
 * dirview->get_child ()->setCursor (*move_file_cursor);
 * fileview->get_child ()->setCursor (*move_file_cursor);  
 * }
 * else
 * {
 * dirview->get_child ()->setCursor (arrowCursor);
 * fileview->get_child ()->setCursor (arrowCursor);
 * setCursor (arrowCursor);
 * }
 */
}
/*---------------------------------------------------------------------------*/
void    ExploreFindClass::create_controls(void)
{
	// >------------ create a new layout manager

	// setFrameStyle (QFrame::Panel | QFrame::Sunken);

	QBoxLayout *gm = new QBoxLayout(this,
									QBoxLayout::TopToBottom,
									8, 8);

	QBoxLayout *gm_01 = new QBoxLayout(QBoxLayout::LeftToRight, 0);
	QBoxLayout *gm_02 = new QBoxLayout(QBoxLayout::LeftToRight);
	QBoxLayout *gm_03 = new QBoxLayout(QBoxLayout::LeftToRight);
	QBoxLayout *gm_04 = new QBoxLayout(QBoxLayout::LeftToRight);

	gm->addLayout(gm_01, 0);
	gm->addLayout(gm_02, 50);
	gm->addLayout(gm_03, 0);
	gm->addLayout(gm_04, 0);

	// >------------ start adding widgets to the layout

	// >---------- layer 1

	QLabel *label0 = new QLabel(this, 0);

	label0->setMinimumSize(50, 22);
	label0->setMaximumSize(50, 22);
	label0->setText("Look in:");
	label0->setAlignment(AlignCenter);
	gm_01->addWidget(label0, 50);

	dir_box = new MountBox(this, "choose_box");

	dir_box->setMinimumSize(220, 22);
	dir_box->setMaximumSize(220, 22);
	dir_box->insertItem("/", -1);
	gm_01->addWidget(dir_box, 50);

	gm_01->addSpacing(5);

	QPushButton *btn1 = new QPushButton(this, "num1");

	btn1->setPixmap(*pm[ICON_01]);
	btn1->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn1->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
	gm_01->addWidget(btn1, 0);

	gm_01->addSpacing(5);

	QPushButton *btn10 = new QPushButton(this, "num10");

	btn10->setPixmap(*pm[ICON_10]);
	btn10->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn10->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
	gm_01->addWidget(btn10, 0);

	QPushButton *btn11 = new QPushButton(this, "num11");

	btn11->setPixmap(*pm[ICON_11]);
	btn11->setMinimumSize(ICON_X_SIZE, ICON_Y_SIZE);
	btn11->setMaximumSize(ICON_X_SIZE, ICON_Y_SIZE);
	gm_01->addWidget(btn11, 0);

	// >---------- layer 2

	// >---------- create dummy labels because we only have 1 pane
	frame3 = new ObjectFrame(0, "left_pane");
	frame4 = new FileFrame(0, "right_pane");

	FileListContainer *fileview = new FileListContainer(this,
														"fileview",
														io_tools,
                                                        NULL,
                                                        NULL);

	fileview->setMinimumSize(200, 100);
	gm_02->addWidget(fileview, 100);

	// >---------- layer 3

	QLabel *label1 = new QLabel(this, 0);

	label1->setText("File name:");
	label1->setAlignment(AlignCenter);
	gm_03->addWidget(label1, 50);

	QMultiLineEdit *file_box = new QMultiLineEdit(this, "choose_box");

	file_box->setMinimumSize(200, 22);
	file_box->setMaximumSize(4200, 22);
	file_box->setText(" ");
	gm_03->addWidget(file_box, 50);

	QPushButton *ok = new QPushButton(this, "num");

	ok->setText("OK");
	ok->setMinimumSize(74, 22);
	ok->setMaximumSize(74, 22);
	gm_03->addWidget(ok, 0);

	// >---------- layer 4

	QLabel *label2 = new QLabel(this, 0);

	label2->setText("Files of type:");
	label2->setAlignment(AlignCenter);
	gm_04->addWidget(label2, 50);

	QComboBox *choose_box = new QComboBox(this, "choose_box");

	choose_box->setMinimumSize(200, 22);
	choose_box->setMaximumSize(4200, 22);
	choose_box->insertItem("Programs", -1);
	choose_box->insertItem("All files (*.*)", -1);
	gm_04->addWidget(choose_box, 50);

	QPushButton *cancel = new QPushButton(this, "num");

	cancel->setText("Cancel");
	cancel->setMinimumSize(74, 22);
	cancel->setMaximumSize(74, 22);
	gm_04->addWidget(cancel, 0);

	// >------------ activate the manager

	gm->activate();

	setIcon(*pm[NODE_EXPLORER]);
	setCaption("Exploring '/'");
	setMinimumSize(424, 244);
	setMaximumSize(424, 244);

	// >---- configure data widgets

	fileview->get_child()->set_root_node(root_node->get_tree_top());
	fileview->setBackgroundColor(white);
}
/*---------------------------------------------------------------------------*/
void    ExploreFindClass::setup_filesystem(char *dirName, char * /* filter unused */)
{
	VFSL_Class *temp_io_class = new VFSL_Class;

	// >------------ determen start directory

	if ((dirName == NULL) || (dirName[0] != '/'))
	{
		root_node = new FileTreeNode(NULL,
									 NODE_DESKTOP,
									 NODE_NEXT,
									 NODE_ISDIR,
									 "/");

		struct utsname temp_uname;

		uname(&temp_uname);
		sprintf(temp_string,
				"%s [ %s ]",
				temp_uname.nodename,
				temp_uname.sysname);
		root_node->set_file_info(temp_string,
								 0, 0,
								 TRUE,
								 TRUE);
		root_node->set_expandable(NODE_EXPANDED);
		temp_io_class->vfsl_read_directory(root_node, "/");		// read initial directory

	}
	else
	{
		root_node = new FileTreeNode(NULL,
									 NODE_DESKTOP,
									 NODE_NEXT,
									 NODE_ISDIR,
									 dirName);

		root_node->set_file_info(dirName,
								 0, 0,
								 TRUE,
								 TRUE);
		root_node->set_expandable(NODE_EXPANDED);
		temp_io_class->vfsl_read_directory(root_node,
										   dirName);	// read initial directory

	}

	delete  temp_io_class;
}
/*---------------------------------------------------------------------------*/
void    ExploreFindClass::setup_general(void)
{
	// >------------ set up mouse cursor for drag and drop

	QBitmap *cb1 = new QBitmap(CURSOR_X, CURSOR_Y, move_file_cur_bits, FALSE);
	QBitmap *cm1 = new QBitmap(CURSOR_X, CURSOR_Y, move_file_msk_bits, FALSE);

	QBitmap *cb2 = new QBitmap(CURSOR_X, CURSOR_Y, move_map_cur_bits, FALSE);
	QBitmap *cm2 = new QBitmap(CURSOR_X, CURSOR_Y, move_map_msk_bits, FALSE);

	QBitmap *cb3 = new QBitmap(CURSOR_X, CURSOR_Y, stop_cur_bits, FALSE);
	QBitmap *cm3 = new QBitmap(CURSOR_X, CURSOR_Y, stop_msk_bits, FALSE);

	move_file_cursor = new QCursor(*cb1, *cm1);
	move_map_cursor = new QCursor(*cb2, *cm2);
	move_stop_cursor = new QCursor(*cb3, *cm3);

	// >------------ determen font style

	QFont  *app_font = new QFont("Helvetica", 10);

	app_font->setBold(TRUE);

	qApp->setFont(*app_font, TRUE);

#ifdef EXPLORER_WIN95_INTERFACE
	qApp->setStyle(WindowsStyle);
#endif /* EXPLORER_WIN95_INTERFACE */
}
/*---------------------------------------------------------------------------*/
void    ExploreFindClass::signals_n_slots(void)
{

}
/*---------------------------------------------------------------------------*/
ExploreFindClass::ExploreFindClass(char *dirName,
				 char *filter,
				 QWidget * parent,
				 const char *name,
				 bool modal):QDialog(parent, name, modal)
{
	explorer_config = new ConfigClass;

	io_tools = new VFSL_Class;

	if (explorer_config->load_resources() != KERNEL_OK)
		exit(1);

	/* 
	 * if (read_types ()!=KERNEL_OK) 
	 *  exit (1); 
	 */

	// >---- determen some general stuff 

	setup_general();

	// >---- setup the stuff that it is all about

	setup_filesystem(dirName, filter);

	// >---- setup the user interface parts

	create_controls();

	// >---- setup all global signals and slots

	signals_n_slots();

	// >---- the explorer dialog should be set up now
}
/*---------------------------------------------------------------------------*/
ExploreFindClass::~ExploreFindClass()
{
	explorer_config->unload_resources();

	delete  io_tools;
	delete  explorer_config;
}
/*---------------------------------------------------------------------------*/ 
